/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.ViewsConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class ViewsElementReader
implements ConfigElementReader {
    public static final String ELEMENT_VIEW = "view";
    public static final String ELEMENT_VIEWIMPL = "view-impl";
    public static final String ELEMENT_VIEWDEFAULTS = "view-defaults";
    public static final String ELEMENT_PAGESIZE = "page-size";
    public static final String ELEMENT_SORTCOLUMN = "sort-column";
    public static final String ELEMENT_SORTDIRECTION = "sort-direction";
    private static Log logger = LogFactory.getLog(ViewsElementReader.class);

    public ConfigElement parse(Element element) {
        ViewsConfigElement configElement = null;
        if (element != null) {
            String name = element.getName();
            if (!name.equals("views")) {
                throw new ConfigException("ViewsElementReader can only parse views elements, the element passed was '" + name + "'");
            }
            configElement = new ViewsConfigElement();
            Iterator renderers = element.elementIterator(ELEMENT_VIEWIMPL);
            while (renderers.hasNext()) {
                Element renderer = (Element)renderers.next();
                configElement.addView(renderer.getTextTrim());
            }
            Element viewDefaults = element.element(ELEMENT_VIEWDEFAULTS);
            if (viewDefaults != null) {
                Iterator pages = viewDefaults.elementIterator();
                while (pages.hasNext()) {
                    Element sortDir;
                    Element sortColumn;
                    Element page = (Element)pages.next();
                    String pageName = page.getName();
                    Element defaultView = page.element(ELEMENT_VIEW);
                    if (defaultView != null) {
                        String viewName = defaultView.getTextTrim();
                        configElement.addDefaultView(pageName, viewName);
                    }
                    if ((sortColumn = page.element(ELEMENT_SORTCOLUMN)) != null) {
                        String column = sortColumn.getTextTrim();
                        configElement.addDefaultSortColumn(pageName, column);
                    }
                    if ((sortDir = page.element(ELEMENT_SORTDIRECTION)) != null) {
                        configElement.addSortDirection(pageName, sortDir.getTextTrim());
                    }
                    this.processPageSizeElement(page.element(ELEMENT_PAGESIZE), pageName, configElement);
                }
            }
        }
        return configElement;
    }

    private void processPageSizeElement(Element pageSizeElement, String page, ViewsConfigElement configElement) {
        if (pageSizeElement != null) {
            Iterator views = pageSizeElement.elementIterator();
            while (views.hasNext()) {
                Element view = (Element)views.next();
                String viewName = view.getName();
                String pageSize = view.getTextTrim();
                try {
                    configElement.addDefaultPageSize(page, viewName, Integer.parseInt(pageSize));
                }
                catch (NumberFormatException nfe) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("Failed to set page size for view '" + viewName + "' in page '" + page + "' as '" + pageSize + "' is an invalid number!"));
                }
            }
        }
    }
}

