/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.ConfigDeployer;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.source.UrlConfigSource;

public class WebClientConfigBootstrap
implements ApplicationContextAware,
BeanNameAware,
ConfigDeployer {
    private String beanName;
    private ApplicationContext applicationContext;
    private ConfigService configService;
    private List<String> configs;

    public void setConfigs(List<String> configs) {
        this.configs = configs;
    }

    public void init() {
        ConfigService configService;
        if (this.applicationContext.containsBean("webClientConfigService") && (configService = (ConfigService)this.applicationContext.getBean("webClientConfigService")) != null) {
            this.setConfigService(configService);
            this.register();
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public String getSortKey() {
        return this.beanName;
    }

    public void register() {
        if (this.configService == null) {
            throw new AlfrescoRuntimeException("Config service must be provided");
        }
        this.configService.addDeployer((ConfigDeployer)this);
    }

    public List<ConfigDeployment> initConfig() {
        if (this.configService != null && this.configs != null && this.configs.size() != 0) {
            UrlConfigSource configSource = new UrlConfigSource(this.configs);
            return this.configService.appendConfig((ConfigSource)configSource);
        }
        return null;
    }
}

