/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.data;

import java.util.List;
import org.alfresco.web.data.Sort;

public final class QuickSort
extends Sort {
    public QuickSort(List data, String column, boolean bForward, String mode) {
        super(data, column, bForward, mode);
    }

    @Override
    public void sort() {
        if (this.data.size() != 0) {
            this.qsort(this.data, 0, this.data.size() - 1);
        }
    }

    private void qsort(List v, int lower, int upper) {
        int sliceLength = upper - lower + 1;
        if (sliceLength > 1) {
            if (sliceLength < 7) {
                for (int i = lower; i <= upper; ++i) {
                    int j;
                    if (this.bForward) {
                        for (j = i; j > lower && this.getComparator().compare(this.keys.get(j - 1), this.keys.get(j)) > 0; --j) {
                            this.swap(this.keys, j - 1, j);
                            this.swap(v, j - 1, j);
                        }
                        continue;
                    }
                    for (j = i; j > lower && this.getComparator().compare(this.keys.get(j - 1), this.keys.get(j)) < 0; --j) {
                        this.swap(this.keys, j - 1, j);
                        this.swap(v, j - 1, j);
                    }
                }
            } else {
                int pivotIndex = this.partition(v, lower, upper);
                this.qsort(v, lower, pivotIndex);
                this.qsort(v, pivotIndex + 1, upper);
            }
        }
    }

    private int partition(List v, int lower, int upper) {
        List keys = this.keys;
        Object pivotValue = keys.get(upper + lower + 1 >> 1);
        int size = keys.size();
        while (lower <= upper) {
            if (this.bForward) {
                while (this.getComparator().compare(keys.get(lower), pivotValue) < 0) {
                    ++lower;
                }
                while (this.getComparator().compare(pivotValue, keys.get(upper)) < 0) {
                    --upper;
                }
            } else {
                while (this.getComparator().compare(keys.get(lower), pivotValue) > 0) {
                    ++lower;
                }
                while (this.getComparator().compare(pivotValue, keys.get(upper)) > 0) {
                    --upper;
                }
            }
            if (lower > upper) continue;
            if (lower < upper) {
                this.swap(keys, lower, upper);
                this.swap(v, lower, upper);
            }
            ++lower;
            --upper;
        }
        return upper;
    }
}

