/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.data;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.web.data.DynamicResolver;
import org.alfresco.web.data.IDataContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Sort {
    protected List data;
    protected String column;
    protected boolean bForward;
    protected String sortMode;
    protected Collator collator;
    protected List keys = null;
    private Comparator comparator = null;
    private boolean strongStringCompare = true;
    private static Log s_logger = LogFactory.getLog(IDataContainer.class);

    public Sort(List data, String column, boolean bForward, String mode) {
        this.data = data;
        this.column = column;
        this.bForward = bForward;
        this.sortMode = mode;
        if (this.data.size() != 0) {
            Collator collator = Collator.getInstance(Locale.getDefault());
            if (mode.equals("case-insensitive")) {
                collator.setStrength(1);
            } else {
                collator.setStrength(3);
            }
            this.keys = this.buildCollationKeys(collator);
        }
    }

    public abstract void sort();

    protected List buildCollationKeys(Collator collator) {
        List data = this.data;
        int iSize = data.size();
        ArrayList<Object> keys = new ArrayList<Object>(iSize);
        try {
            String methodName = Sort.getGetterMethodName(this.column);
            Class<Object> returnType = null;
            Method getter = null;
            Object bean = this.data.get(0);
            try {
                getter = bean.getClass().getMethod(methodName, null);
                returnType = getter.getReturnType();
            }
            catch (NoSuchMethodException nsmerr) {
                if (bean instanceof Map) {
                    Object obj = ((Map)bean).get(this.column);
                    if (obj != null) {
                        returnType = obj.getClass();
                    } else {
                        if (s_logger.isInfoEnabled()) {
                            s_logger.info((Object)("Unable to get return type class for RichList column: " + this.column + ". Suggest set java type directly in sort component tag."));
                        }
                        returnType = Object.class;
                    }
                }
                throw new IllegalStateException("Unable to find bean getter or Map impl for column name: " + this.column);
            }
            boolean bknownType = true;
            if (returnType.equals(String.class)) {
                this.comparator = this.strongStringCompare ? new StringComparator() : new SimpleStringComparator();
            } else if (returnType.equals(Date.class)) {
                this.comparator = new DateComparator();
            } else if (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class)) {
                this.comparator = new BooleanComparator();
            } else if (returnType.equals(Integer.TYPE) || returnType.equals(Integer.class)) {
                this.comparator = new IntegerComparator();
            } else if (returnType.equals(Long.TYPE) || returnType.equals(Long.class)) {
                this.comparator = new LongComparator();
            } else if (returnType.equals(Float.TYPE) || returnType.equals(Float.class)) {
                this.comparator = new FloatComparator();
            } else if (returnType.equals(Timestamp.class)) {
                this.comparator = new TimestampComparator();
            } else if (DynamicResolver.class.isAssignableFrom(returnType)) {
                this.comparator = new SimpleStringComparator();
            } else {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Unsupported sort data type: " + returnType + " defaulting to .toString()"));
                }
                this.comparator = new SimpleComparator();
                bknownType = false;
            }
            for (int iIndex = 0; iIndex < iSize; ++iIndex) {
                Object obj;
                if (getter != null) {
                    try {
                        getter.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    obj = getter.invoke(data.get(iIndex), (Object[])null);
                } else {
                    obj = ((Map)data.get(iIndex)).get(this.column);
                }
                if (obj instanceof String) {
                    String str = (String)obj;
                    if (this.strongStringCompare) {
                        if (str.indexOf(32) != -1) {
                            int iLength = str.length();
                            StringBuilder s = new StringBuilder(iLength + 4);
                            for (int i = 0; i < iLength; ++i) {
                                char c = str.charAt(i);
                                if (c != ' ') {
                                    s.append(c);
                                    continue;
                                }
                                s.append('\'').append(c).append('\'');
                            }
                            str = s.toString();
                        }
                        keys.add(collator.getCollationKey(str));
                        continue;
                    }
                    keys.add(str);
                    continue;
                }
                if (bknownType) {
                    keys.add(obj);
                    continue;
                }
                if (obj != null) {
                    keys.add(obj.toString());
                    continue;
                }
                keys.add(null);
            }
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
        return keys;
    }

    protected void swap(List v, int a, int b) {
        Object temp = v.get(a);
        v.set(a, v.get(b));
        v.set(b, temp);
    }

    protected Comparator getComparator() {
        return this.comparator;
    }

    protected static String getGetterMethodName(String name) {
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    private static class TimestampComparator
    implements Comparator {
        private TimestampComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((Timestamp)obj1).compareTo((Timestamp)obj2);
        }
    }

    private static class DateComparator
    implements Comparator {
        private DateComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((Date)obj1).compareTo((Date)obj2);
        }
    }

    private static class BooleanComparator
    implements Comparator {
        private BooleanComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((Boolean)obj1).equals((Boolean)obj2) ? -1 : 1;
        }
    }

    private static class LongComparator
    implements Comparator {
        private LongComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((Long)obj1).compareTo((Long)obj2);
        }
    }

    private static class FloatComparator
    implements Comparator {
        private FloatComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((Float)obj1).compareTo((Float)obj2);
        }
    }

    private static class IntegerComparator
    implements Comparator {
        private IntegerComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((Integer)obj1).compareTo((Integer)obj2);
        }
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return ((CollationKey)obj1).compareTo((CollationKey)obj2);
        }
    }

    private static class SimpleStringComparator
    implements Comparator {
        private SimpleStringComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return obj1.toString().compareToIgnoreCase(obj2.toString());
        }
    }

    private static class SimpleComparator
    implements Comparator {
        private SimpleComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return obj1.toString().compareTo(obj2.toString());
        }
    }
}

