/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.Rendition;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public interface FormInstanceData
extends Serializable {
    public Form getForm() throws FormNotFoundException;

    public String getName();

    public String getWebappRelativePath();

    public String getSandboxRelativePath();

    public String getPath();

    public String getUrl();

    public Document getDocument() throws IOException, SAXException;

    public List<RegenerateResult> regenerateRenditions() throws FormNotFoundException;

    public List<Rendition> getRenditions();

    public List<Rendition> getRenditions(boolean var1);

    public static class RegenerateResult
    implements Serializable {
        private static final long serialVersionUID = -3827878774655260635L;
        private final RenderingEngineTemplate ret;
        private final String path;
        private final Rendition r;
        private final Exception e;
        private final String lockOwner;

        public RegenerateResult(RenderingEngineTemplate ret, String path, Rendition r, String lockOwner) {
            this.ret = ret;
            this.r = r;
            this.e = null;
            this.path = path;
            this.lockOwner = lockOwner;
        }

        public RegenerateResult(RenderingEngineTemplate ret, String path, Exception e, String lockOwner) {
            this.ret = ret;
            this.e = e;
            this.r = null;
            this.path = path;
            this.lockOwner = lockOwner;
        }

        public RenderingEngineTemplate getRenderingEngineTemplate() {
            return this.ret;
        }

        public String getPath() {
            return this.path;
        }

        public Rendition getRendition() {
            return this.r;
        }

        public Exception getException() {
            return this.e;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }
    }
}

