/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.forms.RenditionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class FormInstanceDataImpl
implements FormInstanceData {
    private static final long serialVersionUID = -7806221587661854013L;
    private static final Log logger = LogFactory.getLog(RenditionImpl.class);
    private final NodeRef nodeRef;
    private final WebProject webProject;
    private transient FormsService formsService;

    FormInstanceDataImpl(NodeRef nodeRef, FormsService formsService) {
        this(nodeRef, formsService, null);
    }

    FormInstanceDataImpl(NodeRef nodeRef, FormsService formsService, WebProject webProject) {
        Pair avmVersionPath;
        this.webProject = webProject;
        if (nodeRef == null) {
            throw new NullPointerException();
        }
        if (formsService == null) {
            throw new NullPointerException();
        }
        AVMService avmService = this.getServiceRegistry().getAVMService();
        if (avmService.lookup(((Integer)(avmVersionPath = AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef)).getFirst()).intValue(), (String)avmVersionPath.getSecond()) == null) {
            throw new IllegalArgumentException("Not found: " + (String)avmVersionPath.getSecond());
        }
        if (!avmService.hasAspect(((Integer)avmVersionPath.getFirst()).intValue(), (String)avmVersionPath.getSecond(), WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
            throw new IllegalArgumentException("node " + nodeRef + " does not have aspect " + WCMAppModel.ASPECT_FORM_INSTANCE_DATA);
        }
        this.nodeRef = nodeRef;
        this.formsService = formsService;
    }

    FormInstanceDataImpl(int version, String avmPath, FormsService formsService) {
        this(AVMNodeConverter.ToNodeRef((int)version, (String)avmPath), formsService);
    }

    private FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    public String getName() {
        return AVMNodeConverter.SplitBase((String)((String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond()))[1];
    }

    @Override
    public String getWebappRelativePath() {
        return AVMUtil.getWebappRelativePath(this.getPath());
    }

    @Override
    public String getSandboxRelativePath() {
        return AVMUtil.getSandboxRelativePath(this.getPath());
    }

    @Override
    public String getPath() {
        return (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond();
    }

    @Override
    public Document getDocument() throws IOException, SAXException {
        return XMLUtil.parse((int)((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()), (String)((String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond()), (AVMService)this.getServiceRegistry().getAVMService());
    }

    @Override
    public Form getForm() throws FormNotFoundException {
        String parentFormName = this.getParentFormName();
        try {
            if (this.getNodeRef().getStoreRef().getProtocol().equals("avm")) {
                if (this.webProject != null) {
                    return this.webProject.getForm(parentFormName);
                }
                return this.getFormsService().getWebForm(parentFormName);
            }
            return this.getFormsService().getForm(parentFormName);
        }
        catch (FormNotFoundException fnfe) {
            if (this.webProject != null) {
                throw new FormNotFoundException(parentFormName, this.webProject, (FormInstanceData)this);
            }
            throw new FormNotFoundException(parentFormName, this);
        }
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public String getUrl() {
        return AVMUtil.getPreviewURI(this.getPath());
    }

    @Override
    public List<FormInstanceData.RegenerateResult> regenerateRenditions() throws FormNotFoundException {
        String lockOwner;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("regenerating renditions of " + this));
        }
        AVMLockingService avmLockService = this.getServiceRegistry().getAVMLockingService();
        AVMService avmService = this.getServiceRegistry().getAVMService();
        PropertyValue pv = avmService.getNodeProperty(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond(), WCMAppModel.PROP_ORIGINAL_PARENT_PATH);
        String originalParentAvmPath = pv == null ? AVMNodeConverter.SplitBase((String)this.getPath())[0] : pv.getStringValue();
        HashSet<RenderingEngineTemplate> allRets = new HashSet<RenderingEngineTemplate>(this.getForm().getRenderingEngineTemplates());
        LinkedList<FormInstanceData.RegenerateResult> result = new LinkedList<FormInstanceData.RegenerateResult>();
        String path = null;
        for (Rendition r : this.getRenditions()) {
            RenderingEngineTemplate ret;
            RenderingEngineTemplateImpl retImpl;
            RenditionImpl rImpl;
            RenderingEngineTemplate ret2;
            if (r instanceof RenditionImpl && (ret2 = (rImpl = (RenditionImpl)r).getRenderingEngineTemplate()) != null && ret2 instanceof RenderingEngineTemplateImpl && !(retImpl = (RenderingEngineTemplateImpl)ret2).isExists() || (ret = r.getRenderingEngineTemplate()) == null || !allRets.contains(ret)) continue;
            lockOwner = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("regenerating rendition " + r + " using template " + ret));
                }
                if ((lockOwner = avmLockService.getLockOwner(AVMUtil.getStoreId(path = r.getPath()), AVMUtil.getStoreRelativePath(path))) != null && logger.isDebugEnabled()) {
                    logger.debug((Object)("Lock already exists for " + path));
                }
                ret.render((FormInstanceData)this, r);
                allRets.remove(ret);
                result.add(new FormInstanceData.RegenerateResult(ret, path, r, lockOwner));
            }
            catch (Exception e) {
                result.add(new FormInstanceData.RegenerateResult(ret, path, e, lockOwner));
                if (lockOwner != null) continue;
                avmLockService.removeLock(AVMUtil.getStoreId(path), AVMUtil.getStoreRelativePath(path));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Removed lock for " + path + " as it failed to generate"));
            }
        }
        String username = Application.getCurrentUser(FacesContext.getCurrentInstance()).getUserName();
        for (RenderingEngineTemplate ret : allRets) {
            lockOwner = null;
            String currentLockStore = null;
            boolean lockModified = false;
            try {
                path = ret.getOutputPathForRendition(this, originalParentAvmPath, this.getName().replaceAll("(.+)\\..*", "$1"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("regenerating rendition of " + this.getPath() + " at " + path + " using template " + ret));
                }
                String storeId = AVMUtil.getStoreId(path);
                String storePath = AVMUtil.getStoreRelativePath(path);
                String storeName = AVMUtil.getStoreName(path);
                Map lockData = avmLockService.getLockData(storeId, storePath);
                if (lockData != null) {
                    lockOwner = avmLockService.getLockOwner(storeId, storePath);
                    currentLockStore = (String)lockData.get("avm-store-name");
                }
                if (lockOwner != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Lock already exists for " + path));
                    }
                    if (!currentLockStore.equals(storeName) && lockOwner.equals(username)) {
                        lockModified = true;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("transferring lock from " + currentLockStore + " to " + storeName + " for path: " + path));
                        }
                        lockData.put("avm-store-name", storeName);
                        avmLockService.modifyLock(storeId, storePath, lockOwner, storeId, storePath, lockData);
                    }
                }
                result.add(new FormInstanceData.RegenerateResult(ret, path, ret.render((FormInstanceData)this, path), lockOwner));
            }
            catch (Exception e) {
                result.add(new FormInstanceData.RegenerateResult(ret, path, e, lockOwner));
                String storeId = AVMUtil.getStoreId(path);
                String storePath = AVMUtil.getStoreRelativePath(path);
                String storeName = AVMUtil.getStoreName(path);
                if (lockOwner == null) {
                    avmLockService.removeLock(storeId, storePath);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed lock for " + path + " as it failed to generate"));
                    continue;
                }
                if (!lockModified) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("transferring lock from " + storeName + " to " + currentLockStore + " for path: " + path));
                }
                Map lockData = avmLockService.getLockData(storeId, storePath);
                lockData.put("avm-store-name", currentLockStore);
                avmLockService.modifyLock(storeId, storePath, lockOwner, storeId, storePath, lockData);
            }
        }
        return result;
    }

    @Override
    public List<Rendition> getRenditions() {
        return this.getRenditions(false);
    }

    @Override
    public List<Rendition> getRenditions(boolean includeDeleted) {
        AVMService avmService = this.getServiceRegistry().getAVMLockingAwareService();
        PropertyValue pv = avmService.getNodeProperty(-1, this.getPath(), WCMAppModel.PROP_RENDITIONS);
        List renditionPaths = pv == null ? Collections.EMPTY_LIST : pv.getCollection(DataTypeDefinition.TEXT);
        String storeName = AVMUtil.getStoreName(this.getPath());
        ArrayList<Rendition> result = new ArrayList<Rendition>(renditionPaths.size());
        for (Serializable path : renditionPaths) {
            String avmRenditionPath = AVMUtil.buildAVMPath((String)storeName, (String)((String)((Object)path)));
            if (avmService.lookup(-1, avmRenditionPath, includeDeleted) == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("ignoring dangling rendition at: " + avmRenditionPath));
                continue;
            }
            RenditionImpl r = new RenditionImpl(-1, avmRenditionPath, this.getFormsService());
            try {
                if (!this.equals(r.getPrimaryFormInstanceData(includeDeleted))) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("rendition " + r + " points at form instance data " + r.getPrimaryFormInstanceData(includeDeleted) + " instead of " + this + ". Not including in renditions list."));
                }
            }
            catch (FileNotFoundException fnfe) {}
            continue;
            if (r.getRenderingEngineTemplate() == null) continue;
            result.add(r);
        }
        return result;
    }

    private ServiceRegistry getServiceRegistry() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Repository.getServiceRegistry(fc);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        try {
            return this.getClass().getName() + "{path : " + this.getPath() + ", form : " + this.getForm().getName() + "}";
        }
        catch (FormNotFoundException fnfe) {
            return this.getClass().getName() + "{path : " + this.getPath() + ", form : " + this.getParentFormName() + " NOT_FOUND!  }";
        }
    }

    public boolean equals(Object other) {
        return other instanceof FormInstanceDataImpl && this.getNodeRef().equals((Object)((FormInstanceDataImpl)other).getNodeRef());
    }

    protected String getParentFormName() {
        AVMService avmService = this.getServiceRegistry().getAVMService();
        return avmService.getNodeProperty(((Integer)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getFirst()).intValue(), (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.nodeRef).getSecond(), WCMAppModel.PROP_PARENT_FORM_NAME).getStringValue();
    }
}

