/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import org.alfresco.jndi.AVMFileDirContext;
import org.alfresco.util.JNDIPath;
import org.alfresco.web.forms.FormDataFunctions;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ServletContextFormDataFunctionsAdapter
extends FormDataFunctions {
    private final ServletContext servletContext;

    public ServletContextFormDataFunctionsAdapter(ServletContext servletContext) {
        super(AVMFileDirContext.getAVMRemote());
        this.servletContext = servletContext;
    }

    private String toAVMPath(String path) {
        path = this.servletContext.getRealPath(path);
        try {
            JNDIPath jndiPath = new JNDIPath(AVMFileDirContext.getAVMFileDirMountPoint(), path);
            return jndiPath.getAvmPath();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return path;
        }
    }

    @Override
    public Document parseXMLDocument(String path) throws IOException, SAXException {
        return super.parseXMLDocument(this.toAVMPath(path));
    }

    @Override
    public Map<String, Document> parseXMLDocuments(String formName, String path) throws IOException, SAXException {
        return super.parseXMLDocuments(formName, this.toAVMPath(path));
    }
}

