/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.SAXResult;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.XSLTRenderingEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.SAXException;

public class XSLFORenderingEngine
extends XSLTRenderingEngine {
    private static final Log LOGGER = LogFactory.getLog(XSLFORenderingEngine.class);
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();

    @Override
    public String getName() {
        return "XSL-FO";
    }

    @Override
    public String getDefaultTemplateFileExtension() {
        return "fo";
    }

    @Override
    public void render(Map<QName, Object> model, RenderingEngineTemplate ret, OutputStream out) throws IOException, RenderingEngine.RenderingException, SAXException {
        String mimetype = MIME_TYPES.get(ret.getMimetypeForRendition());
        if (mimetype == null) {
            throw new RenderingEngine.RenderingException("mimetype " + ret.getMimetypeForRendition() + " is not supported by " + this.getName());
        }
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            Fop fop = fopFactory.newFop(mimetype, foUserAgent, out);
            super.render(model, ret, new SAXResult(fop.getDefaultHandler()));
        }
        catch (FOPException fope) {
            throw new RenderingEngine.RenderingException((Exception)((Object)fope));
        }
        finally {
            out.close();
        }
    }

    static {
        MIME_TYPES.put("application/pdf", "application/pdf");
        MIME_TYPES.put("application/postscript", "application/postscript");
        MIME_TYPES.put("application/postscript", "application/postscript");
        MIME_TYPES.put("text/plain", "text/plain");
        MIME_TYPES.put("application/rtf", "application/rtf");
        MIME_TYPES.put("text/richtext", "application/rtf");
        MIME_TYPES.put("text/rtf", "application/rtf");
        MIME_TYPES.put("application/mif", "application/mif");
        MIME_TYPES.put("application/x-mif", "application/mif");
        MIME_TYPES.put("image/svg+xml", "image/svg+xml");
        MIME_TYPES.put("image/png", "image/png");
        MIME_TYPES.put("image/jpeg", "image/jpeg");
        MIME_TYPES.put("image/tiff", "image/tiff");
    }
}

