/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms.xforms;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.forms.Form;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Schema2XFormsProperties {
    private static final Log LOGGER = LogFactory.getLog(Schema2XFormsProperties.class);
    private final ContentService contentService;
    private final NamespaceService namespaceService;
    private final NodeService nodeService;
    private final SearchService searchService;
    private boolean formatCaption = true;
    private String[] locations;

    public Schema2XFormsProperties(ContentService contentService, NamespaceService namespaceService, NodeService nodeService, SearchService searchService) {
        this.contentService = contentService;
        this.namespaceService = namespaceService;
        this.nodeService = nodeService;
        this.searchService = searchService;
    }

    public ResourceBundle getResourceBundle(Form form, Locale locale) {
        LinkedList<ResourceBundle> bundles = new LinkedList<ResourceBundle>();
        for (String location : this.locations) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if ((location = location.replace("${form.name}", "cm:" + form.getName())).startsWith("alfresco:")) {
                location = location.substring("alfresco:".length());
                loader = new ClassLoader(loader){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public InputStream getResourceAsStream(String name) {
                        LOGGER.debug((Object)("loading resource " + name));
                        ResultSet results = Schema2XFormsProperties.this.searchService.query(Repository.getStoreRef(), "lucene", "PATH:\"" + name + "\"");
                        try {
                            LOGGER.debug((Object)("search returned " + results.length() + " results"));
                            if (results.length() == 1) {
                                NodeRef nr = results.getNodeRef(0);
                                ContentReader reader = Schema2XFormsProperties.this.contentService.getReader(nr, ContentModel.PROP_CONTENT);
                                InputStream inputStream = reader.getContentInputStream();
                                return inputStream;
                            }
                            InputStream inputStream = super.getResourceAsStream(name);
                            return inputStream;
                        }
                        finally {
                            results.close();
                        }
                    }
                };
            } else if (location.startsWith("classpath:")) {
                location = location.substring("classpath:".length());
            }
            LOGGER.debug((Object)("using loader " + loader + " for location " + location));
            try {
                ResourceBundle rb = ResourceBundle.getBundle(location, locale, loader);
                LOGGER.debug((Object)("found bundle " + rb + " for location " + location));
                bundles.addFirst(rb);
            }
            catch (MissingResourceException mse) {
                LOGGER.debug((Object)("unable to located bundle at " + location + ": " + mse.getMessage()));
            }
        }
        ResourceBundle result = null;
        for (ResourceBundle rb : bundles) {
            result = result == null ? rb : new ResourceBundleWrapper(rb, result);
        }
        return result;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public boolean isFormatCaption() {
        return this.formatCaption;
    }

    public void setFormatCaption(boolean formatCaption) {
        this.formatCaption = formatCaption;
    }

    public String toString() {
        return this.getClass().getName() + "{" + StringUtils.join((Object[])this.locations, (String)",") + "}";
    }

    private class ResourceBundleWrapper
    extends ResourceBundle {
        private final ResourceBundle bundle;
        private final ResourceBundle parent;

        public ResourceBundleWrapper(ResourceBundle bundle, ResourceBundle parent) {
            LOGGER.debug((Object)("creating bundle " + bundle + " with parent " + parent));
            this.bundle = bundle;
            this.parent = parent;
        }

        @Override
        public Enumeration<String> getKeys() {
            final Enumeration<String> bk = this.bundle.getKeys();
            final Enumeration<String> pk = this.parent.getKeys();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return bk.hasMoreElements() || pk.hasMoreElements();
                }

                @Override
                public String nextElement() {
                    return bk.hasMoreElements() ? (String)bk.nextElement() : (String)pk.nextElement();
                }
            };
        }

        @Override
        protected Object handleGetObject(String key) {
            try {
                return this.bundle.getObject(key);
            }
            catch (MissingResourceException mre1) {
                try {
                    return this.parent.getObject(key);
                }
                catch (MissingResourceException mre2) {
                    return null;
                }
            }
        }
    }
}

