/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms.xforms;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.forms.xforms.FormBuilderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

public class SchemaUtil {
    private static final Comparator<XSTypeDefinition> TYPE_EXTENSION_SORTER = new Comparator<XSTypeDefinition>(){

        @Override
        public int compare(XSTypeDefinition type1, XSTypeDefinition type2) {
            int result = 0;
            if (type1 == null && type2 != null) {
                result = -1;
            } else if (type1 != null && type2 == null) {
                result = 1;
            } else if (type1 == type2 || type1 == null && type2 == null) {
                result = 0;
            } else {
                int n = type1.derivedFromType(type2, (short)1) ? 1 : (result = type2.derivedFromType(type1, (short)1) ? -1 : type1.getName().compareTo(type2.getName()));
            }
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            return result;
        }
    };
    private static final Log LOGGER = LogFactory.getLog(SchemaUtil.class);
    private static final HashMap<Short, String> DATA_TYPE_TO_NAME = new HashMap();

    public static short getBuiltInType(XSTypeDefinition type) {
        if (DATA_TYPE_TO_NAME.get((short)1).equals(type.getName())) {
            return 1;
        }
        XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)type;
        short result = simpleType.getBuiltInKind();
        return result == 44 ? SchemaUtil.getBuiltInType((XSTypeDefinition)simpleType.getItemType()) : result;
    }

    public static String getBuiltInTypeName(XSTypeDefinition type) {
        short s = SchemaUtil.getBuiltInType(type);
        return SchemaUtil.getBuiltInTypeName(s);
    }

    public static String getBuiltInTypeName(short type) {
        return DATA_TYPE_TO_NAME.get(type);
    }

    public static XSModel parseSchema(Document schemaDocument, boolean failOnError) throws FormBuilderException {
        try {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS lsImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("XML 1.0 LS 3.0"));
            if (lsImpl == null) {
                throw new FormBuilderException("unable to create DOMImplementationLS using " + registry);
            }
            LSInput in = lsImpl.createLSInput();
            in.setStringData(XMLUtil.toString((Node)schemaDocument));
            XSImplementation xsImpl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            XSLoader schemaLoader = xsImpl.createXSLoader(null);
            DOMConfiguration config = schemaLoader.getConfig();
            final LinkedList errors = new LinkedList();
            config.setParameter("error-handler", new DOMErrorHandler(){

                @Override
                public boolean handleError(DOMError domError) {
                    errors.add(domError);
                    return true;
                }
            });
            XSModel result = schemaLoader.load(in);
            if (failOnError && errors.size() != 0) {
                HashSet<String> messages = new HashSet<String>();
                StringBuilder message = null;
                for (DOMError e : errors) {
                    message = new StringBuilder();
                    DOMLocator dl = e.getLocation();
                    if (dl != null) {
                        message.append("at line ").append(dl.getLineNumber()).append(" column ").append(dl.getColumnNumber());
                        if (dl.getRelatedNode() != null) {
                            message.append(" node ").append(dl.getRelatedNode().getNodeName());
                        }
                        message.append(": ").append(e.getMessage());
                    }
                    messages.add(message.toString());
                }
                message = new StringBuilder();
                message.append(messages.size() > 1 ? "errors" : "error").append(" parsing schema: \n");
                for (String s : messages) {
                    message.append(s).append("\n");
                }
                throw new FormBuilderException(message.toString());
            }
            if (result == null) {
                throw new FormBuilderException("invalid schema");
            }
            return result;
        }
        catch (ClassNotFoundException x) {
            throw new FormBuilderException(x);
        }
        catch (InstantiationException x) {
            throw new FormBuilderException(x);
        }
        catch (IllegalAccessException x) {
            throw new FormBuilderException(x);
        }
    }

    private static void buildTypeTree(XSTypeDefinition type, TreeSet<XSTypeDefinition> descendents, TreeMap<String, TreeSet<XSTypeDefinition>> typeTree) {
        XSTypeDefinition parentType;
        if (type == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("buildTypeTree(" + type.getName() + ", " + descendents.size() + " descendents)"));
        }
        if (descendents.size() > 0) {
            TreeSet<XSTypeDefinition> compatibleTypes = typeTree.get(type.getName());
            if (compatibleTypes == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("no compatible types found for " + type.getName() + ", creating a new set"));
                }
                compatibleTypes = new TreeSet<XSTypeDefinition>(TYPE_EXTENSION_SORTER);
                typeTree.put(type.getName(), compatibleTypes);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("adding " + descendents.size() + " descendents to " + type.getName()));
            }
            compatibleTypes.addAll(descendents);
        }
        if ((parentType = type.getBaseType()) == null || type.getTypeCategory() != parentType.getTypeCategory()) {
            return;
        }
        if (type != parentType && parentType.getName() != null && !parentType.getName().equals("anyType")) {
            XSComplexTypeDefinition complexType;
            TreeSet<XSTypeDefinition> newDescendents = typeTree.get(parentType.getName());
            if (newDescendents == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("type tree doesn't contain " + parentType.getName() + ", creating a new descendant set"));
                }
                newDescendents = new TreeSet<XSTypeDefinition>(TYPE_EXTENSION_SORTER);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("adding " + descendents.size() + " descendants to existing " + newDescendents.size() + " descendants of " + parentType.getName()));
            }
            newDescendents.addAll(descendents);
            if (type.getTypeCategory() == 15 && (complexType = (XSComplexTypeDefinition)type).getDerivationMethod() == 1 && !complexType.getAbstract() && !descendents.contains(type)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("adding " + type.getName() + " to existing " + newDescendents.size() + " descendents of " + parentType.getName()));
                }
                newDescendents.add(type);
            }
            SchemaUtil.buildTypeTree(parentType, newDescendents, typeTree);
        }
    }

    public static TreeMap<String, TreeSet<XSTypeDefinition>> buildTypeTree(XSModel schema) {
        XSTypeDefinition t;
        int i;
        TreeMap<String, TreeSet<XSTypeDefinition>> result = new TreeMap<String, TreeSet<XSTypeDefinition>>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("buildTypeTree " + schema));
        }
        XSNamedMap types = schema.getComponents((short)3);
        for (i = 0; i < types.getLength(); ++i) {
            t = (XSTypeDefinition)types.item(i);
            if (t.getTypeCategory() != 15) continue;
            XSComplexTypeDefinition type = (XSComplexTypeDefinition)t;
            SchemaUtil.buildTypeTree((XSTypeDefinition)type, new TreeSet<XSTypeDefinition>(TYPE_EXTENSION_SORTER), result);
        }
        for (i = 0; i < types.getLength(); ++i) {
            t = (XSTypeDefinition)types.item(i);
            if (t.getTypeCategory() != 16) continue;
            SchemaUtil.buildTypeTree((XSTypeDefinition)((XSSimpleTypeDefinition)t), new TreeSet<XSTypeDefinition>(TYPE_EXTENSION_SORTER), result);
        }
        if (LOGGER.isDebugEnabled()) {
            for (String typeName : result.keySet()) {
                TreeSet<XSTypeDefinition> descendents = result.get(typeName);
                LOGGER.debug((Object)(">>>> for " + typeName + " Descendants=\n "));
                for (XSTypeDefinition desc : descendents) {
                    LOGGER.debug((Object)("      " + desc.getName()));
                }
            }
        }
        return result;
    }

    public static XSParticle findCorrespondingParticleInComplexType(XSElementDeclaration elDecl) {
        XSComplexTypeDefinition complexType = elDecl.getEnclosingCTDefinition();
        if (complexType == null) {
            LOGGER.warn((Object)("unable to find corresponding particle for " + elDecl.getName() + ".  no enclosing complex type."));
            return null;
        }
        XSParticle particle = complexType.getParticle();
        XSTerm term = particle.getTerm();
        if (!(term instanceof XSModelGroup)) {
            LOGGER.warn((Object)("unable to find corresponding particle for " + elDecl.getName() + ".  term " + term + " is not a model group."));
            return null;
        }
        XSParticle result = SchemaUtil.findCorrespondingParticleInModelGroup((XSModelGroup)term, elDecl);
        if (result == null) {
            String msg = "unable to find corresponding particle for " + elDecl.getName() + " in term " + term;
            if (LOGGER.isDebugEnabled()) {
                throw new NullPointerException(msg);
            }
            LOGGER.warn((Object)msg);
        }
        return result;
    }

    private static XSParticle findCorrespondingParticleInModelGroup(XSModelGroup modelGroup, XSElementDeclaration elDecl) {
        XSObjectList particles = modelGroup.getParticles();
        if (particles == null || particles.getLength() == 0) {
            LOGGER.debug((Object)("unable to find corresponding particle for " + elDecl.getName() + ".  group " + modelGroup + " contains no particles."));
            return null;
        }
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle part = (XSParticle)particles.item(i);
            XSTerm thisTerm = part.getTerm();
            if (thisTerm instanceof XSModelGroup) {
                part = SchemaUtil.findCorrespondingParticleInModelGroup((XSModelGroup)thisTerm, elDecl);
                if (part == null) continue;
                return part;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("checking term " + thisTerm.getName() + " in " + modelGroup.getName() + "(" + modelGroup.getClass().getName() + ")"));
            }
            if (thisTerm != elDecl) continue;
            return part;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("unable to find corresponding particle for " + elDecl.getName() + ".  " + elDecl.getName() + " not found in " + particles.getLength() + " particles"));
        }
        return null;
    }

    public static boolean isElementDeclaredIn(String name, String namespace, XSComplexTypeDefinition type, boolean recursive) {
        XSTerm term;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("isElement " + name + " declared in " + type.getName()));
        }
        if (!recursive && type.getDerivationMethod() == 1) {
            XSComplexTypeDefinition parent = (XSComplexTypeDefinition)type.getBaseType();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("testing if it is not on parent " + parent.getName()));
            }
            if (SchemaUtil.isElementDeclaredIn(name, namespace, parent, true)) {
                return false;
            }
        }
        boolean found = false;
        XSParticle particle = type.getParticle();
        if (particle != null && (term = particle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup group = (XSModelGroup)term;
            found = SchemaUtil.isElementDeclaredIn(name, namespace, group);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("isElement " + name + " declared in " + type.getName() + ": " + found));
        }
        return found;
    }

    public static boolean isElementDeclaredIn(String name, String namespace, XSModelGroup group) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("isElement " + name + " declared in group " + group.getName()));
        }
        boolean found = false;
        XSObjectList particles = group.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle subPart = (XSParticle)particles.item(i);
            XSTerm subTerm = subPart.getTerm();
            if (subTerm instanceof XSElementDeclaration) {
                XSElementDeclaration elDecl = (XSElementDeclaration)subTerm;
                if (!EqualsHelper.nullSafeEquals((Object)namespace, (Object)elDecl.getNamespace()) || !name.equals(elDecl.getName())) continue;
                found = true;
                continue;
            }
            if (!(subTerm instanceof XSModelGroup)) continue;
            found = SchemaUtil.isElementDeclaredIn(name, namespace, (XSModelGroup)subTerm);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("isElement " + name + " declared in group " + group.getName() + ": " + found));
        }
        return found;
    }

    public static boolean doesElementComeFromExtension(XSElementDeclaration element, XSComplexTypeDefinition controlType) {
        XSTypeDefinition baseType;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("doesElementComeFromExtension for " + element.getName() + " and controlType=" + controlType.getName()));
        }
        if (controlType.getDerivationMethod() == 1 && (baseType = controlType.getBaseType()).getTypeCategory() == 15) {
            XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)baseType;
            if (SchemaUtil.isElementDeclaredIn(element.getName(), element.getNamespace(), complexType, true)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"doesElementComeFromExtension: yes");
                }
                return true;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"doesElementComeFromExtension: recursive call on previous level");
            }
            return SchemaUtil.doesElementComeFromExtension(element, complexType);
        }
        return false;
    }

    public static boolean isAttributeDeclaredIn(XSAttributeUse attr, XSComplexTypeDefinition type, boolean recursive) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("is Attribute " + attr.getAttrDeclaration().getName() + " declared in " + type.getName()));
        }
        if (!recursive && type.getDerivationMethod() == 1) {
            XSComplexTypeDefinition parent = (XSComplexTypeDefinition)type.getBaseType();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("testing if it is not on parent " + parent.getName()));
            }
            if (SchemaUtil.isAttributeDeclaredIn(attr, parent, true)) {
                return false;
            }
        }
        boolean found = false;
        XSObjectList attrs = type.getAttributeUses();
        for (int i = 0; i < attrs.getLength(); ++i) {
            if ((XSAttributeUse)attrs.item(i) != attr) continue;
            found = true;
            break;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("is Attribute " + attr.getName() + " declared in " + type.getName() + ": " + found));
        }
        return found;
    }

    public static boolean isAttributeDeclaredIn(String attrName, String namespace, XSComplexTypeDefinition type, boolean recursive) {
        boolean found = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("is Attribute " + attrName + " declared in " + type.getName()));
        }
        if (attrName.startsWith("@")) {
            attrName = attrName.substring(1);
        }
        if (!recursive && type.getDerivationMethod() == 1) {
            XSComplexTypeDefinition parent = (XSComplexTypeDefinition)type.getBaseType();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("testing if it is not on parent " + parent.getName()));
            }
            if (SchemaUtil.isAttributeDeclaredIn(attrName, namespace, parent, true)) {
                return false;
            }
        }
        XSObjectList attrs = type.getAttributeUses();
        for (int i = 0; i < attrs.getLength() && !found; ++i) {
            XSAttributeUse anAttr = (XSAttributeUse)attrs.item(i);
            if (anAttr == null) continue;
            String name = anAttr.getName();
            if (name == null || name.length() == 0) {
                name = anAttr.getAttrDeclaration().getName();
            }
            if (!EqualsHelper.nullSafeEquals((Object)namespace, (Object)anAttr.getAttrDeclaration().getNamespace()) || !attrName.equals(name)) continue;
            found = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("is Attribute " + attrName + " declared in " + type.getName() + ": " + found));
        }
        return found;
    }

    public static boolean doesAttributeComeFromExtension(XSAttributeUse attr, XSComplexTypeDefinition controlType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("doesAttributeComeFromExtension for " + attr.getAttrDeclaration().getName() + " and controlType=" + controlType.getName()));
        }
        if (controlType.getDerivationMethod() != 1) {
            return false;
        }
        XSTypeDefinition baseType = controlType.getBaseType();
        if (baseType.getTypeCategory() != 15) {
            return false;
        }
        XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)baseType;
        if (SchemaUtil.isAttributeDeclaredIn(attr, complexType, true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"doesAttributeComeFromExtension: yes");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"doesAttributeComeFromExtension: recursive call on previous level");
        }
        return SchemaUtil.doesAttributeComeFromExtension(attr, complexType);
    }

    public static Occurrence getOccurrence(XSElementDeclaration elDecl) {
        Occurrence result;
        XSParticle particle = SchemaUtil.findCorrespondingParticleInComplexType(elDecl);
        Occurrence occurrence = result = particle == null ? new Occurrence(1, 1) : new Occurrence(particle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getOccurrence for " + elDecl.getName() + ", " + result));
        }
        return result;
    }

    static {
        DATA_TYPE_TO_NAME.put((short)1, "anyType");
        DATA_TYPE_TO_NAME.put((short)18, "anyURI");
        DATA_TYPE_TO_NAME.put((short)17, "base64Binary");
        DATA_TYPE_TO_NAME.put((short)3, "boolean");
        DATA_TYPE_TO_NAME.put((short)36, "byte");
        DATA_TYPE_TO_NAME.put((short)8, "dateTime");
        DATA_TYPE_TO_NAME.put((short)10, "date");
        DATA_TYPE_TO_NAME.put((short)4, "decimal");
        DATA_TYPE_TO_NAME.put((short)6, "double");
        DATA_TYPE_TO_NAME.put((short)7, "duration");
        DATA_TYPE_TO_NAME.put((short)29, "ENTITY");
        DATA_TYPE_TO_NAME.put((short)5, "float");
        DATA_TYPE_TO_NAME.put((short)14, "gDay");
        DATA_TYPE_TO_NAME.put((short)13, "gMonthDay");
        DATA_TYPE_TO_NAME.put((short)15, "gMonth");
        DATA_TYPE_TO_NAME.put((short)11, "gYearMonth");
        DATA_TYPE_TO_NAME.put((short)12, "gYear");
        DATA_TYPE_TO_NAME.put((short)28, "IDREF");
        DATA_TYPE_TO_NAME.put((short)27, "ID");
        DATA_TYPE_TO_NAME.put((short)30, "integer");
        DATA_TYPE_TO_NAME.put((short)34, "int");
        DATA_TYPE_TO_NAME.put((short)23, "language");
        DATA_TYPE_TO_NAME.put((short)33, "long");
        DATA_TYPE_TO_NAME.put((short)25, "Name");
        DATA_TYPE_TO_NAME.put((short)26, "NCName");
        DATA_TYPE_TO_NAME.put((short)32, "negativeInteger");
        DATA_TYPE_TO_NAME.put((short)24, "NMTOKEN");
        DATA_TYPE_TO_NAME.put((short)37, "nonNegativeInteger");
        DATA_TYPE_TO_NAME.put((short)31, "nonPositiveInteger");
        DATA_TYPE_TO_NAME.put((short)21, "normalizedString");
        DATA_TYPE_TO_NAME.put((short)20, "NOTATION");
        DATA_TYPE_TO_NAME.put((short)42, "positiveInteger");
        DATA_TYPE_TO_NAME.put((short)19, "QName");
        DATA_TYPE_TO_NAME.put((short)35, "short");
        DATA_TYPE_TO_NAME.put((short)2, "string");
        DATA_TYPE_TO_NAME.put((short)9, "time");
        DATA_TYPE_TO_NAME.put((short)22, "TOKEN");
        DATA_TYPE_TO_NAME.put((short)41, "unsignedByte");
        DATA_TYPE_TO_NAME.put((short)39, "unsignedInt");
        DATA_TYPE_TO_NAME.put((short)38, "unsignedLong");
        DATA_TYPE_TO_NAME.put((short)40, "unsignedShort");
    }

    public static class Occurrence {
        public static final int UNBOUNDED = -1;
        public final int minimum;
        public final int maximum;

        public Occurrence(XSParticle particle) {
            this(particle.getMinOccurs(), particle.getMaxOccursUnbounded() ? -1 : particle.getMaxOccurs());
        }

        public Occurrence(int minimum) {
            this(minimum, -1);
        }

        public Occurrence(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public boolean isRepeated() {
            return this.isUnbounded() || this.maximum > 1;
        }

        public boolean isOptional() {
            return this.minimum == 0 && this.maximum == 1;
        }

        public boolean isUnbounded() {
            return this.maximum == -1;
        }

        public String toString() {
            return "minimum=" + this.minimum + ", maximum=" + this.maximum;
        }
    }
}

