/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms.xforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.util.Pair;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormProcessor;
import org.alfresco.web.forms.xforms.FormBuilderException;
import org.alfresco.web.forms.xforms.Schema2XForms;
import org.alfresco.web.forms.xforms.Schema2XFormsProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xs.XSModel;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.xforms.ChibaBean;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.core.ValidatorMode;
import org.chiba.xml.xforms.core.impl.DefaultValidatorMode;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.RepeatItem;
import org.chiba.xml.xforms.ui.Upload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.SAXException;

public class XFormsBean
implements Serializable {
    private static final long serialVersionUID = -7979077333882370784L;
    private static final Log LOGGER = LogFactory.getLog(XFormsBean.class);
    private XFormsSession xformsSession;
    private transient Schema2XFormsProperties schema2XFormsProperties;
    private AVMBrowseBean avmBrowseBean;
    private NavigationBean navigator;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Lock writeLock = this.rwLock.writeLock();
    private Lock readLock = this.rwLock.readLock();
    public static String BEAN_NAME = "XFormsBean";

    public XFormsSession getXformsSession() {
        if (this.xformsSession == null) {
            throw new IllegalStateException("Incomplete user session. Please restart the form.");
        }
        return this.xformsSession;
    }

    public void setSchema2XFormsProperties(Schema2XFormsProperties schema2XFormsProperties) {
        this.schema2XFormsProperties = schema2XFormsProperties;
    }

    protected Schema2XFormsProperties getSchema2XFormsProperties() {
        if (this.schema2XFormsProperties == null) {
            this.schema2XFormsProperties = (Schema2XFormsProperties)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "Schema2XFormsProperties");
        }
        return this.schema2XFormsProperties;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXFormsSession(XFormsSession xformsSession) throws FormBuilderException, XFormsException {
        this.xformsSession = xformsSession;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        this.writeLock.lock();
        try {
            ChibaBean chibaBean = new ChibaBean();
            chibaBean.setConfig(servletContext.getRealPath("/WEB-INF/chiba.xml"));
            Pair<Document, XSModel> chibaPair = this.getXFormsDocument();
            chibaBean.setXMLContainer((org.w3c.dom.Node)chibaPair.getFirst(), (XSModel)chibaPair.getSecond());
            EventTarget et = (EventTarget)((Object)chibaBean.getXMLContainer().getDocumentElement());
            EventListener el = new EventListener(){

                @Override
                public void handleEvent(Event e) {
                    XMLEvent xmle = (XMLEvent)e;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("received event " + xmle.getType() + ": " + xmle));
                    }
                    XFormsBean.this.xformsSession.eventLog.add(xmle);
                }
            };
            et.addEventListener("chiba-load-uri", el, true);
            et.addEventListener("chiba-render-message", el, true);
            et.addEventListener("chiba-replace-all", el, true);
            et.addEventListener("xforms-enabled", el, true);
            et.addEventListener("xforms-disabled", el, true);
            et.addEventListener("xforms-required", el, true);
            et.addEventListener("xforms-optional", el, true);
            et.addEventListener("xforms-readonly", el, true);
            et.addEventListener("xforms-readwrite", el, true);
            et.addEventListener("xforms-valid", el, true);
            et.addEventListener("xforms-invalid", el, true);
            et.addEventListener("xforms-in-range", el, true);
            et.addEventListener("xforms-out-of-range", el, true);
            et.addEventListener("xforms-select", el, true);
            et.addEventListener("xforms-deselect", el, true);
            et.addEventListener("xforms-insert", el, true);
            et.addEventListener("xforms-delete", el, true);
            chibaBean.init();
            et.addEventListener("xforms-submit", el, true);
            et.addEventListener("xforms-submit-done", el, true);
            et.addEventListener("xforms-submit-error", el, true);
            et.addEventListener("chiba-state-changed", el, true);
            et.addEventListener("chiba-prototype-cloned", el, true);
            et.addEventListener("chiba-id-generated", el, true);
            et.addEventListener("chiba-item-inserted", el, true);
            et.addEventListener("chiba-item-deleted", el, true);
            et.addEventListener("chiba-index-changed", el, true);
            et.addEventListener("chiba-switch-toggled", el, true);
            this.xformsSession.chibaBean = chibaBean;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public XFormsSession createSession(Document formInstanceData, String formInstanceDataName, Form form) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("initializing xforms session with form " + form.getName() + " and instance data " + formInstanceDataName + " (" + formInstanceData + ")"));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        String baseUrl = request.getScheme() + "://" + request.getServerName() + ':' + request.getServerPort() + request.getContextPath();
        return new XFormsSession(formInstanceData, formInstanceDataName, form, baseUrl, this.getSchema2XFormsProperties().isFormatCaption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getXForm() throws IOException, XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".getXForm()"));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        this.readLock.lock();
        try {
            ChibaBean chibaBean = this.getXformsSession().getChibaBean();
            Document xformsDocument = chibaBean.getXMLContainer();
            XMLUtil.print((org.w3c.dom.Node)xformsDocument, (Writer)out);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXFormsValue() throws XFormsException, IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String id = (String)requestParameters.get("id");
        String value = (String)requestParameters.get("value");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".setXFormsValue(" + id + ", " + value + ")"));
        }
        this.writeLock.lock();
        try {
            ChibaBean chibaBean = this.getXformsSession().getChibaBean();
            if (chibaBean.getContainer().lookup(id) instanceof Upload) {
                chibaBean.updateControlValue(id, null, value, value.getBytes("UTF-8"));
            } else {
                chibaBean.updateControlValue(id, value);
            }
            ResponseWriter out = context.getResponseWriter();
            XMLUtil.print((org.w3c.dom.Node)this.getEventLog(), (Writer)out);
            out.close();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepeatIndeces() throws XFormsException, IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String repeatIds = (String)requestParameters.get("repeatIds");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".setRepeatIndeces(" + repeatIds + ")"));
        }
        this.writeLock.lock();
        try {
            for (String id : repeatIds.split(",")) {
                int index = Integer.parseInt((String)requestParameters.get(id));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(this + ".setRepeatIndex(" + id + ", " + index + ")"));
                }
                ChibaBean chibaBean = this.getXformsSession().getChibaBean();
                chibaBean.updateRepeatIndex(id, index);
            }
            ResponseWriter out = context.getResponseWriter();
            XMLUtil.print((org.w3c.dom.Node)this.getEventLog(), (Writer)out);
            out.close();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAction() throws XFormsException, IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String id = (String)requestParameters.get("id");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".fireAction(" + id + ")"));
        }
        this.writeLock.lock();
        try {
            ChibaBean chibaBean = this.getXformsSession().getChibaBean();
            chibaBean.dispatch(id, "DOMActivate");
            ResponseWriter out = context.getResponseWriter();
            XMLUtil.print((org.w3c.dom.Node)this.getEventLog(), (Writer)out);
            out.close();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void handleAction() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".handleAction"));
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            Document result = XMLUtil.parse((InputStream)request.getInputStream());
            this.handleSubmit(result);
            Document instanceData = this.getXformsSession().getFormInstanceData();
            ResponseWriter out = context.getResponseWriter();
            XMLUtil.print((org.w3c.dom.Node)instanceData, (Writer)out, (boolean)false);
            out.close();
        }
        catch (Throwable t) {
            LOGGER.error((Object)t.getMessage(), t);
        }
    }

    public void handleSubmit(org.w3c.dom.Node result) {
        Document instanceData = this.getXformsSession().getFormInstanceData();
        Element documentElement = instanceData.getDocumentElement();
        if (documentElement != null) {
            instanceData.removeChild(documentElement);
        }
        if (result instanceof Document) {
            result = ((Document)result).getDocumentElement();
        }
        documentElement = (Element)instanceData.importNode(result.cloneNode(true), true);
        Schema2XForms.removePrototypeNodes(documentElement);
        instanceData.appendChild(documentElement);
        instanceData.normalizeDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapRepeatItems() throws Exception {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String fromItemId = (String)requestParameters.get("fromItemId");
        String toItemId = (String)requestParameters.get("toItemId");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + ".swapRepeatItems(" + fromItemId + ", " + toItemId + ")"));
        }
        this.writeLock.lock();
        try {
            ChibaBean chibaBean = this.getXformsSession().getChibaBean();
            RepeatItem from = (RepeatItem)chibaBean.getContainer().lookup(fromItemId);
            if (from == null) {
                throw new IllegalArgumentException("unable to find source repeat item " + fromItemId);
            }
            RepeatItem to = (RepeatItem)chibaBean.getContainer().lookup(toItemId);
            if (to == null) {
                throw new IllegalArgumentException("unable to find destination repeat item " + toItemId);
            }
            this.swapRepeatItems(from, to);
            ResponseWriter out = context.getResponseWriter();
            XMLUtil.print((org.w3c.dom.Node)this.getEventLog(), (Writer)out);
            out.close();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isXformValid() {
        ChibaBean chibaBean = this.getXformsSession().getChibaBean();
        try {
            chibaBean.dispatch("submit", "DOMActivate");
            org.w3c.dom.Node eventLogDoc = this.getEventLog();
            org.w3c.dom.Node eventsNode = eventLogDoc.getFirstChild();
            if (eventsNode != null && "events".equals(eventsNode.getNodeName())) {
                NodeList childNodeList = eventsNode.getChildNodes();
                for (int i = 0; i < childNodeList.getLength(); ++i) {
                    org.w3c.dom.Node childNode = childNodeList.item(i);
                    if (!"xforms-submit-error".equals(childNode.getNodeName()) || childNode.getAttributes().getNamedItem("targetId") == null || !"submission-validate".equals(childNode.getAttributes().getNamedItem("targetId").getNodeValue())) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Found xforms-submit-error, it means that form wasn't validated, throwing error");
                    }
                    return false;
                }
            }
            return true;
        }
        catch (XFormsException e) {
            return false;
        }
    }

    private void swapRepeatItems(RepeatItem from, RepeatItem to) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("swapping repeat item " + from + " with " + to));
            LOGGER.debug((Object)("from instance id  " + from.getInstanceId()));
        }
        Model model = from.getModel();
        Instance instance = model.getInstance(from.getInstanceId());
        assert (instance == to.getModel().getInstance(to.getInstanceId()));
        String fromLocationPath = from.getLocationPath();
        String toLocationPath = to.getLocationPath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("from {id: " + from.getId() + ",position: " + from.getPosition() + "} " + fromLocationPath + "=" + instance.getModelItem(fromLocationPath).getValue()));
            LOGGER.debug((Object)("to {id:" + to.getId() + ",position: " + to.getPosition() + "} " + toLocationPath + "=" + instance.getModelItem(toLocationPath).getValue()));
        }
        String beforeLocation = toLocationPath;
        int toPosition = to.getPosition();
        if (from.getPosition() < toPosition) {
            RepeatItem beforeItem = to.getRepeat().getRepeatItem(toPosition + 1);
            String string = beforeLocation = beforeItem != null ? beforeItem.getLocationPath() : to.getRepeat().getLocationPath().replaceAll("\\[position\\(\\)[\\s]*!=[\\s]*last\\(\\)]$", "[position()=last()]");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("inserting node before " + beforeLocation));
        }
        instance.insertNode(fromLocationPath, beforeLocation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("deleting from " + from.getLocationPath()));
        }
        instance.deleteNode(from.getLocationPath());
        to.getRepeat().setIndex(toPosition);
        model.getContainer().dispatch(model.getTarget(), "xforms-rebuild", null);
        model.getContainer().dispatch(model.getTarget(), "xforms-recalculate", null);
        model.getContainer().dispatch(model.getTarget(), "xforms-revalidate", null);
        model.getContainer().dispatch(model.getTarget(), "xforms-refresh", null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("swapped model data, instance data after manipulation:\n " + XMLUtil.toString((org.w3c.dom.Node)instance.getInstanceDocument())));
        }
    }

    private static void rewriteInlineURIs(Document schemaDocument, String cwdAvmPath) {
        NodeList nl = XMLUtil.combine((NodeList[])new NodeList[]{schemaDocument.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include"), schemaDocument.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import")});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("rewriting " + nl.getLength() + " includes"));
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element includeEl = (Element)nl.item(i);
            if (!includeEl.hasAttribute("schemaLocation")) continue;
            String uri = includeEl.getAttribute("schemaLocation");
            String finalURI = null;
            if (uri == null || uri.startsWith("http://") || uri.startsWith("https://")) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("not rewriting " + uri));
                continue;
            }
            if (uri.startsWith("webscript://")) {
                String ticket;
                MutableAuthenticationService authenticationService;
                String storeId;
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
                String baseURI = request.getScheme() + "://" + request.getServerName() + ':' + request.getServerPort() + request.getContextPath() + "/wcservice";
                String rewrittenURI = uri;
                if (uri.contains("${storeid}")) {
                    storeId = AVMUtil.getStoreName(cwdAvmPath);
                    rewrittenURI = uri.replace("${storeid}", storeId);
                } else if (uri.contains("{storeid}")) {
                    storeId = AVMUtil.getStoreName(cwdAvmPath);
                    rewrittenURI = uri.replace("{storeid}", storeId);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("no store id specified in webscript URI " + uri));
                }
                if (uri.contains("${ticket}")) {
                    authenticationService = Repository.getServiceRegistry(facesContext).getAuthenticationService();
                    ticket = authenticationService.getCurrentTicket();
                    rewrittenURI = rewrittenURI.replace("${ticket}", ticket);
                } else if (uri.contains("{ticket}")) {
                    authenticationService = Repository.getServiceRegistry(facesContext).getAuthenticationService();
                    ticket = authenticationService.getCurrentTicket();
                    rewrittenURI = rewrittenURI.replace("{ticket}", ticket);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("no ticket specified in webscript URI " + uri));
                }
                rewrittenURI = rewrittenURI.replaceAll("%26", "&");
                finalURI = baseURI + rewrittenURI.replace("webscript://", "/");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Final URI " + finalURI));
                }
            } else {
                String baseURI = uri.charAt(0) == '/' ? AVMUtil.getPreviewURI(AVMUtil.getStoreName(cwdAvmPath)) : AVMUtil.getPreviewURI(cwdAvmPath);
                finalURI = baseURI + uri;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("rewriting " + uri + " as " + finalURI));
            }
            includeEl.setAttribute("schemaLocation", finalURI);
        }
    }

    private org.w3c.dom.Node getEventLog() {
        Document result = XMLUtil.newDocument();
        Element eventsElement = result.createElement("events");
        result.appendChild(eventsElement);
        for (XMLEvent xfe : this.getXformsSession().getEventLog()) {
            String type = xfe.getType();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("adding event " + type + " to the event log"));
            }
            Element target = (Element)((Object)xfe.getTarget());
            Element eventElement = result.createElement(type);
            eventsElement.appendChild(eventElement);
            eventElement.setAttribute("targetId", target.getAttributeNS(null, "id"));
            eventElement.setAttribute("targetName", target.getLocalName());
            Collection properties = xfe.getPropertyNames();
            if (properties != null) {
                for (Object name : properties) {
                    Object value = xfe.getContextInfo((String)name);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("adding property {" + name + ":" + value + "} to event " + type));
                    }
                    Element propertyElement = result.createElement("property");
                    eventElement.appendChild(propertyElement);
                    propertyElement.setAttribute("name", name.toString());
                    propertyElement.setAttribute("value", value != null ? value.toString() : null);
                }
            }
            if (!LOGGER.isDebugEnabled() || !"xforms-submit-error".equals(type)) continue;
            LOGGER.debug((Object)"performing full revalidate");
            try {
                Model model = this.getXformsSession().getChibaBean().getContainer().getDefaultModel();
                Instance instance = model.getDefaultInstance();
                model.getValidator().validate(instance, "/", (ValidatorMode)new DefaultValidatorMode());
                Iterator it = instance.iterateModelItems("/");
                while (it.hasNext()) {
                    ModelItem modelItem = (ModelItem)it.next();
                    if (!modelItem.isValid()) {
                        LOGGER.debug((Object)("model node " + modelItem.getNode() + " is invalid"));
                    }
                    if (!modelItem.isRequired() || modelItem.getValue().length() != 0) continue;
                    LOGGER.debug((Object)("model node " + modelItem.getNode() + " is empty and required"));
                }
            }
            catch (XFormsException xfe2) {
                LOGGER.debug((Object)"error performing revaliation", (Throwable)xfe2);
            }
        }
        this.xformsSession.eventLog.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("generated event log:\n" + XMLUtil.toString((org.w3c.dom.Node)result)));
        }
        return result;
    }

    private Pair<Document, XSModel> getXFormsDocument() throws FormBuilderException {
        String path = null;
        path = this.getXformsSession().getForm().isWebForm() ? this.getCurrentAVMPath() : this.getCurrentPath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("building xform for schema " + this.xformsSession.form.getName() + " root element " + this.xformsSession.form.getSchemaRootElementName() + " cwd " + path));
        }
        Locale locale = Application.getLanguage(FacesContext.getCurrentInstance());
        ResourceBundle resourceBundle = this.getSchema2XFormsProperties().getResourceBundle(this.xformsSession.form, locale);
        try {
            Document schemaDocument = this.xformsSession.form.getSchema();
            XFormsBean.rewriteInlineURIs(schemaDocument, path);
            String rootElementName = this.xformsSession.form.getSchemaRootElementName();
            Pair<Document, XSModel> result = this.getXformsSession().getSchema2XForms().buildXForm(this.getXformsSession().getFormInstanceData(), schemaDocument, rootElementName, resourceBundle);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("generated xform: " + XMLUtil.toString((org.w3c.dom.Node)((org.w3c.dom.Node)result.getFirst()))));
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FormBuilderException(ioe);
        }
        catch (SAXException saxe) {
            throw new FormBuilderException(saxe);
        }
    }

    private String getCurrentAVMPath() {
        AVMNode node = this.avmBrowseBean.getAvmActionNode();
        if (node == null) {
            return this.avmBrowseBean.getCurrentPath();
        }
        String result = node.getPath();
        return node.isDirectory() ? result : AVMNodeConverter.SplitBase((String)result)[0];
    }

    private String getCurrentPath() {
        Node node = this.navigator.getCurrentNode();
        if (node == null) {
            return null;
        }
        String result = node.getPath();
        return result;
    }

    class XFormsSession
    implements FormProcessor.Session {
        private static final long serialVersionUID = 1L;
        private final Document formInstanceData;
        private final String formInstanceDataName;
        private final Form form;
        private ChibaBean chibaBean;
        private final Schema2XForms schema2XForms;
        private final List<XMLEvent> eventLog = new LinkedList<XMLEvent>();

        public XFormsSession(Document formInstanceData, String formInstanceDataName, Form form, String baseUrl, boolean formatCaption) {
            this.formInstanceData = formInstanceData;
            this.formInstanceDataName = formInstanceDataName;
            this.form = form;
            this.schema2XForms = new Schema2XForms(null, Schema2XForms.SubmitMethod.POST, "alfresco:" + XFormsBean.class.getName(), formatCaption);
        }

        @Override
        public void destroy() {
            try {
                this.chibaBean.shutdown();
            }
            catch (XFormsException xfe) {
                LOGGER.debug((Object)xfe);
            }
        }

        @Override
        public Form getForm() {
            return this.form;
        }

        @Override
        public Document getFormInstanceData() {
            return this.formInstanceData;
        }

        @Override
        public String getFormInstanceDataName() {
            return this.formInstanceDataName;
        }

        public Schema2XForms getSchema2XForms() {
            return this.schema2XForms;
        }

        public ChibaBean getChibaBean() {
            return this.chibaBean;
        }

        public List<XMLEvent> getEventLog() {
            return this.eventLog;
        }
    }

    public static class AlfrescoSubmissionHandler
    extends AbstractConnector
    implements SubmissionHandler {
        public Map submit(Submission submission, org.w3c.dom.Node instance) throws XFormsException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(((Object)((Object)this)).getClass().getName() + " recieved submission " + XMLUtil.toString((org.w3c.dom.Node)instance, (boolean)true)));
            }
            FacesContext fc = FacesContext.getCurrentInstance();
            XFormsBean xforms = (XFormsBean)FacesHelper.getManagedBean(fc, BEAN_NAME);
            xforms.handleSubmit(instance);
            return Collections.EMPTY_MAP;
        }
    }
}

