/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms.xforms;

import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.faces.context.FacesContext;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormProcessor;
import org.alfresco.web.forms.xforms.FormBuilderException;
import org.alfresco.web.forms.xforms.XFormsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chiba.xml.xforms.exception.XFormsException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.web.util.JavaScriptUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XFormsProcessor
implements FormProcessor {
    private static final Log LOGGER = LogFactory.getLog(XFormsProcessor.class);
    private static final String[][] JS_NAMESPACES = new String[][]{{"xforms", "http://www.w3.org/2002/xforms", "xf"}, {"xhtml", "http://www.w3.org/1999/xhtml", "xhtml"}, {"chiba", "http://chiba.sourceforge.net/xforms", "chiba"}, {"alfresco", "http://www.alfresco.org", "alf"}};
    private static final String[] JS_SCRIPTS = new String[]{"/scripts/tiny_mce/" + (LOGGER.isDebugEnabled() ? "tiny_mce_src.js" : "tiny_mce.js"), "/scripts/ajax/dojo/" + (LOGGER.isDebugEnabled() ? "dojo.js.uncompressed.js" : "dojo.js"), "/scripts/ajax/mootools.v1.11.js", "/scripts/ajax/common.js", "/scripts/ajax/ajax_helper.js", "/scripts/ajax/tiny_mce_wcm_extensions.js", "/scripts/ajax/xforms.js", "/scripts/ajax/file_picker_widget.js", "/scripts/upload_helper.js", "/scripts/ajax/dojo/src/date/serialize.js"};
    private static final String[] BUNDLE_KEYS = new String[]{"add_content", "cancel", "change", "click_to_edit", "eg", "go_up", "idle", "loading", "path", "select", "upload", "validation_provide_values_for_required_fields", "time_picker_title", "time_picker_button_title", "date_picker_title", "date_picker_button_title", "date_time_picker_title", "date_time_picker_button_title", "increase_week_label", "decrease_week_label", "increase_month_label", "decrease_month_label", "mandatory_parameter", "state_expanded", "state_not_expanded", "select_path_menu", "add_item_title", "move_up_title", "move_down_title", "remove_item_title", "item_title", "accessibility_validation_message", "accessibility_validation_message_with_error_count"};
    private static JSONObject widgetConfig = null;

    public XFormsProcessor() {
        if (widgetConfig == null) {
            widgetConfig = XFormsProcessor.loadConfig();
        }
    }

    @Override
    public FormProcessor.Session process(Document instanceDataDocument, String formInstanceDataName, Form form, Writer out) throws FormProcessor.ProcessingException {
        FacesContext fc = FacesContext.getCurrentInstance();
        XFormsBean xforms = (XFormsBean)FacesHelper.getManagedBean(fc, XFormsBean.BEAN_NAME);
        XFormsBean.XFormsSession result = xforms.createSession(instanceDataDocument, formInstanceDataName, form);
        this.process(result, out);
        return result;
    }

    @Override
    public void process(FormProcessor.Session session, Writer out) throws FormProcessor.ProcessingException {
        ConfigElement xformsScriptsConfig;
        String storeName;
        String[] jsNamespacesObjects;
        FacesContext fc = FacesContext.getCurrentInstance();
        XFormsBean xforms = (XFormsBean)FacesHelper.getManagedBean(fc, XFormsBean.BEAN_NAME);
        AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
        try {
            xforms.setXFormsSession((XFormsBean.XFormsSession)session);
        }
        catch (FormBuilderException fbe) {
            LOGGER.error((Object)fbe);
            throw new FormProcessor.ProcessingException(fbe);
        }
        catch (XFormsException xfe) {
            LOGGER.error((Object)xfe);
            throw new FormProcessor.ProcessingException((Exception)((Object)xfe));
        }
        String contextPath = fc.getExternalContext().getRequestContextPath();
        Document result = XMLUtil.newDocument();
        String xformsUIDivId = "alfresco-xforms-ui";
        Element div = result.createElement("div");
        div.setAttribute("id", "alfresco-xforms-ui");
        result.appendChild(div);
        Element e = result.createElement("link");
        e.setAttribute("rel", "stylesheet");
        e.setAttribute("type", "text/css");
        e.setAttribute("href", contextPath + "/css/xforms.css");
        div.appendChild(e);
        e = result.createElement("script");
        e.setAttribute("type", "text/javascript");
        StringBuilder js = new StringBuilder("\n");
        for (String jsNamespace : jsNamespacesObjects = new String[]{"alfresco", "alfresco.constants", "alfresco.xforms", "alfresco.xforms.constants"}) {
            js.append(jsNamespace).append(" = typeof ").append(jsNamespace).append(" == 'undefined' ? {} : ").append(jsNamespace).append(";\n");
        }
        js.append("alfresco.constants.DEBUG = ").append(LOGGER.isDebugEnabled()).append(";\n");
        js.append("alfresco.constants.WEBAPP_CONTEXT = '").append(JavaScriptUtils.javaScriptEscape((String)contextPath)).append("';\n");
        String avmWebApp = avmBrowseBean.getWebapp();
        js.append("alfresco.constants.AVM_WEBAPP_CONTEXT = '");
        if (avmWebApp != null) {
            js.append(JavaScriptUtils.javaScriptEscape((String)avmWebApp));
        }
        js.append("';\n");
        js.append("alfresco.constants.AVM_WEBAPP_URL = '");
        if (avmWebApp != null && (storeName = AVMUtil.getCorrespondingPreviewStoreName(avmBrowseBean.getSandbox())) != null) {
            js.append(JavaScriptUtils.javaScriptEscape((String)(fc.getExternalContext().getRequestContextPath() + "/wcs/api/path/content/avm/" + AVMUtil.buildStoreWebappPath(storeName, avmWebApp).replace(":", ""))));
        }
        js.append("';\n");
        js.append("alfresco.constants.AVM_WEBAPP_PREFIX = '");
        if (avmWebApp != null && (storeName = AVMUtil.getCorrespondingPreviewStoreName(avmBrowseBean.getSandbox())) != null) {
            js.append(JavaScriptUtils.javaScriptEscape((String)(fc.getExternalContext().getRequestContextPath() + "/wcs/api/path/content/avm/" + AVMUtil.buildSandboxRootPath(storeName).replace(":", ""))));
        }
        js.append("';\n");
        js.append("alfresco.constants.LANGUAGE = '");
        String lang = Application.getLanguage(FacesContext.getCurrentInstance()).toString();
        if (lang.length() > 4) {
            lang = lang.substring(0, lang.indexOf("_"));
        }
        js.append(lang);
        js.append("';\n");
        js.append("alfresco.xforms.constants.XFORMS_UI_DIV_ID = '").append("alfresco-xforms-ui").append("';\n");
        js.append("alfresco.xforms.constants.FORM_INSTANCE_DATA_NAME = '").append(JavaScriptUtils.javaScriptEscape((String)session.getFormInstanceDataName())).append("';\n");
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, Application.getLanguage(fc));
        js.append("alfresco.xforms.constants.DATE_FORMAT = '").append(sdf.toPattern()).append("';\n");
        sdf = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, Application.getLanguage(fc));
        js.append("alfresco.xforms.constants.TIME_FORMAT = '").append(sdf.toPattern()).append("';\n");
        sdf = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3, Application.getLanguage(fc));
        js.append("alfresco.xforms.constants.DATE_TIME_FORMAT = '").append(sdf.toPattern()).append("';\n");
        for (String[] ns : JS_NAMESPACES) {
            js.append("alfresco.xforms.constants.").append(ns[0].toUpperCase()).append("_NS = '").append(ns[1]).append("';\n");
            js.append("alfresco.xforms.constants.").append(ns[0].toUpperCase()).append("_PREFIX = '").append(ns[2]).append("';\n");
        }
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        js.append("alfresco.resources = {\n");
        for (String k : BUNDLE_KEYS) {
            js.append(k).append(": '").append(JavaScriptUtils.javaScriptEscape((String)bundle.getString(k))).append("'").append(k.equals(BUNDLE_KEYS[BUNDLE_KEYS.length - 1]) ? "\n};" : ",").append("\n");
        }
        try {
            js.append("alfresco.xforms.widgetConfig = \n").append((Object)(LOGGER.isDebugEnabled() ? widgetConfig.toString(0) : widgetConfig)).append("\n");
        }
        catch (JSONException jsone) {
            LOGGER.error((Object)jsone);
        }
        e.appendChild(result.createTextNode(js.toString()));
        div.appendChild(e);
        for (String script : JS_SCRIPTS) {
            if (script == null) continue;
            e = result.createElement("script");
            e.setAttribute("type", "text/javascript");
            e.setAttribute("src", contextPath + script);
            e.appendChild(result.createTextNode("\n"));
            div.appendChild(e);
        }
        ConfigElement config = Application.getConfigService(fc).getGlobalConfig().getConfigElement("wcm");
        if (config != null && (xformsScriptsConfig = config.getChild("xforms-scripts")) != null) {
            StringTokenizer t = new StringTokenizer(xformsScriptsConfig.getValue().trim(), ", ");
            while (t.hasMoreTokens()) {
                e = result.createElement("script");
                e.setAttribute("type", "text/javascript");
                e.setAttribute("src", contextPath + t.nextToken());
                e.appendChild(result.createTextNode("\n"));
                div.appendChild(e);
            }
        }
        XMLUtil.print((Node)result, (Writer)out);
    }

    private static JSONObject loadConfig() {
        ConfigService cfgService = Application.getConfigService(FacesContext.getCurrentInstance());
        ConfigElement xformsConfig = cfgService.getGlobalConfig().getConfigElement("wcm").getChild("xforms");
        List widgetConfig = xformsConfig.getChildren("widget");
        class WidgetConfigElement
        implements Comparable<WidgetConfigElement> {
            public final String xformsType;
            public final String xmlSchemaType;
            public final String appearance;
            public final String javascriptClassName;
            private final Map<String, String> params = new HashMap<String, String>();

            public WidgetConfigElement(String xformsType, String xmlSchemaType, String appearance, String javascriptClassName) {
                if (xformsType == null) {
                    throw new NullPointerException();
                }
                this.xformsType = xformsType;
                this.xmlSchemaType = xmlSchemaType;
                this.appearance = appearance;
                this.javascriptClassName = javascriptClassName;
            }

            public void addParam(String k, String v) {
                this.params.put(k, v);
            }

            public Map<String, String> getParams() {
                return this.params == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.params);
            }

            @Override
            public int compareTo(WidgetConfigElement other) {
                int result = this.xformsType.compareTo(other.xformsType);
                if (result != 0) {
                    return result;
                }
                result = this.compareAttribute(this.xmlSchemaType, other.xmlSchemaType);
                if (result != 0) {
                    return result;
                }
                result = this.compareAttribute(this.appearance, other.appearance);
                if (result != 0) {
                    return result;
                }
                throw new RuntimeException("widget definitions " + this + " and " + other + " collide");
            }

            public String toString() {
                return this.getClass().getName() + "{" + "xformsType: " + this.xformsType + ", xmlSchemaType: " + this.xmlSchemaType + ", appearance: " + this.appearance + ", javascriptClassName: " + this.javascriptClassName + ", numParams: " + this.getParams().size() + "}";
            }

            private int compareAttribute(String s1, String s2) {
                return s1 != null && s2 == null ? 1 : (s1 == null && s2 != null ? -1 : (s1 != null && s2 != null ? s1.compareTo(s2) : 0));
            }
        }
        TreeSet<WidgetConfigElement> widgetConfigs = new TreeSet<WidgetConfigElement>();
        for (ConfigElement ce : widgetConfig) {
            WidgetConfigElement wce = new WidgetConfigElement(ce.getAttribute("xforms-type"), ce.getAttribute("xml-schema-type"), ce.getAttribute("appearance"), ce.getAttribute("javascript-class-name"));
            List params = ce.getChildren("param");
            for (ConfigElement p : params) {
                wce.addParam(p.getAttribute("name"), p.getValue());
            }
            widgetConfigs.add(wce);
        }
        try {
            JSONObject result = new JSONObject();
            for (WidgetConfigElement wce : widgetConfigs) {
                String s;
                if (!result.has(wce.xformsType)) {
                    result.put(wce.xformsType, (Object)new JSONObject());
                }
                JSONObject xformsTypeObject = result.getJSONObject(wce.xformsType);
                String string = s = wce.xmlSchemaType == null ? "*" : wce.xmlSchemaType;
                if (!xformsTypeObject.has(s)) {
                    xformsTypeObject.put(s, (Object)new JSONObject());
                }
                JSONObject schemaTypeObject = xformsTypeObject.getJSONObject(s);
                s = wce.appearance == null ? "*" : wce.appearance;
                JSONObject o = new JSONObject();
                schemaTypeObject.put(s, (Object)o);
                o.put("className", (Object)wce.javascriptClassName);
                if (wce.getParams().size() == 0) continue;
                o.put("params", (Object)new JSONObject(wce.getParams()));
            }
            return result;
        }
        catch (JSONException jsone) {
            LOGGER.error((Object)jsone, (Throwable)jsone);
            return null;
        }
    }
}

