/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServlet;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.ExternalAccessServlet;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.IDataContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlFormRendererBase;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.webscripts.ui.common.StringUtils;
import org.springframework.web.jsf.FacesContextUtils;

public final class Utils
extends StringUtils {
    public static final String USER_AGENT_FIREFOX = "Firefox";
    public static final String USER_AGENT_MSIE = "MSIE";
    private static final String MSG_TIME_PATTERN = "time_pattern";
    private static final String MSG_DATE_PATTERN = "date_pattern";
    private static final String MSG_DATE_TIME_PATTERN = "date_time_pattern";
    private static final Log logger = LogFactory.getLog(Utils.class);

    private Utils() {
    }

    public static void outputAttribute(ResponseWriter out, Object attr, String mapping) throws IOException {
        if (attr != null) {
            out.write(32);
            out.write(mapping);
            out.write("=\"");
            out.write(attr.toString());
            out.write(34);
        }
    }

    public static String getActionHiddenFieldName(FacesContext context, UIComponent component) {
        return Utils.getParentForm(context, component).getClientId(context) + ':' + "act";
    }

    public static void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            component.encodeBegin(context);
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else if (component.getChildCount() != 0) {
                Iterator i = component.getChildren().iterator();
                while (i.hasNext()) {
                    Utils.encodeRecursive(context, (UIComponent)i.next());
                }
            }
            component.encodeEnd(context);
        }
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component, String fieldId, String fieldValue) {
        return Utils.generateFormSubmit(context, component, fieldId, fieldValue, false, null);
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component, String fieldId, String fieldValue, Map<String, String> params) {
        return Utils.generateFormSubmit(context, component, fieldId, fieldValue, false, params);
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component, String fieldId, String fieldValue, boolean valueIsParam, Map<String, String> params) {
        UIForm form = Utils.getParentForm(context, component);
        if (form == null) {
            throw new IllegalStateException("Must nest components inside UIForm to generate form submit!");
        }
        String formClientId = form.getClientId(context);
        StringBuilder buf = new StringBuilder(200);
        buf.append("document.forms['");
        buf.append(formClientId);
        buf.append("']['");
        buf.append(fieldId);
        buf.append("'].value=");
        if (!valueIsParam) {
            buf.append("'");
        }
        buf.append(Utils.encode((String)fieldValue));
        if (!valueIsParam) {
            buf.append("'");
        }
        buf.append(";");
        if (params != null) {
            for (String name : params.keySet()) {
                buf.append("document.forms['");
                buf.append(formClientId);
                buf.append("']['");
                buf.append(name);
                buf.append("'].value='");
                String val = params.get(name);
                if (val != null) {
                    val = Utils.encode((String)val);
                }
                val = Utils.replace((String)val, (String)"\\", (String)"\\\\");
                val = Utils.replace((String)val, (String)"'", (String)"\\'");
                buf.append(val);
                buf.append("';");
                HtmlFormRendererBase.addHiddenCommandParameter((FacesContext)context, (UIComponent)form, (String)name);
            }
        }
        buf.append("document.forms['");
        buf.append(formClientId);
        buf.append("'].submit();");
        if (!valueIsParam) {
            buf.append("return false;");
        }
        HtmlFormRendererBase.addHiddenCommandParameter((FacesContext)context, (UIComponent)form, (String)fieldId);
        return buf.toString();
    }

    public static String generateFormSubmit(FacesContext context, UIComponent component) {
        UIForm form = Utils.getParentForm(context, component);
        if (form == null) {
            throw new IllegalStateException("Must nest components inside UIForm to generate form submit!");
        }
        String formClientId = form.getClientId(context);
        StringBuilder buf = new StringBuilder(48);
        buf.append("document.forms['");
        buf.append(formClientId);
        buf.append("'].submit()");
        buf.append(";return false;");
        return buf.toString();
    }

    public static String generateURL(FacesContext context, Node node, String name, URLMode usage) {
        String url = null;
        switch (usage) {
            case WEBDAV: {
                FileFolderService fileFolderService = Repository.getServiceRegistry(context).getFileFolderService();
                try {
                    NodeRef rootNode = WebDAVServlet.getWebdavRootNode();
                    if (rootNode == null) break;
                    StringBuilder path = new StringBuilder("/").append("webdav");
                    if (!rootNode.equals((Object)node.getNodeRef())) {
                        List paths = fileFolderService.getNamePath(rootNode, node.getNodeRef());
                        for (int x = 0; x < paths.size(); ++x) {
                            path.append("/").append(WebDAVHelper.encodeURL((String)((FileInfo)paths.get(x)).getName(), (String)Utils.getUserAgent(context)));
                        }
                    }
                    url = path.toString();
                }
                catch (AccessDeniedException e) {
                }
                catch (FileNotFoundException nodeErr) {
                }
                catch (FileFolderServiceImpl.InvalidTypeException e) {}
                break;
            }
            case CIFS: {
                ServiceRegistry serviceRegistry = Repository.getServiceRegistry(context);
                NodeService nodeService = serviceRegistry.getNodeService();
                FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
                NavigationBean navBean = (NavigationBean)context.getExternalContext().getSessionMap().get("NavigationBean");
                ServerConfigurationAccessor serverConfiguration = (ServerConfigurationAccessor)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("fileServerConfiguration");
                if (nodeService == null || fileFolderService == null || navBean == null || serverConfiguration == null) break;
                FilesystemsConfigSection filesysConfig = (FilesystemsConfigSection)serverConfiguration.getConfigSection("Filesystems");
                DiskSharedDevice diskShare = null;
                SharedDeviceList shares = filesysConfig.getShares();
                Enumeration shareEnum = shares.enumerateShares();
                while (shareEnum.hasMoreElements() && diskShare == null) {
                    SharedDevice curShare = (SharedDevice)shareEnum.nextElement();
                    if (!(curShare.getContext() instanceof ContentContext)) continue;
                    ContentContext contentContext = (ContentContext)curShare.getContext();
                    NodeRef rootNode = contentContext.getRootNode();
                    if (node.getNodeRef().equals((Object)rootNode)) {
                        diskShare = (DiskSharedDevice)curShare;
                        break;
                    }
                    try {
                        fileFolderService.getNamePath(rootNode, node.getNodeRef());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" Node " + node.getName() + " HAS been found on " + contentContext.getDeviceName()));
                        }
                        diskShare = (DiskSharedDevice)curShare;
                        break;
                    }
                    catch (FileNotFoundException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)(" Node " + node.getName() + " HAS NOT been found on " + contentContext.getDeviceName()));
                    }
                    catch (FileFolderServiceImpl.InvalidTypeException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)(" Node " + node.getName() + " HAS NOT been found on " + contentContext.getDeviceName()));
                    }
                }
                if (diskShare == null) break;
                ContentContext contentCtx = (ContentContext)diskShare.getContext();
                NodeRef rootNode = contentCtx.getRootNode();
                try {
                    url = Repository.getNamePathEx(context, node.getNodePath(), rootNode, "\\", "file:///" + navBean.getCIFSServerPath(diskShare));
                }
                catch (AccessDeniedException e) {
                }
                catch (InvalidNodeRefException nodeErr) {}
                break;
            }
            case HTTP_DOWNLOAD: {
                url = DownloadContentServlet.generateDownloadURL(node.getNodeRef(), name);
                break;
            }
            case HTTP_INLINE: {
                url = DownloadContentServlet.generateBrowserURL(node.getNodeRef(), name);
                break;
            }
            case SHOW_DETAILS: {
                DictionaryService dd = Repository.getServiceRegistry(context).getDictionaryService();
                String outcome = "showDocDetails";
                if (dd.isSubClass(node.getType(), ContentModel.TYPE_FOLDER) || dd.isSubClass(node.getType(), ApplicationModel.TYPE_FOLDERLINK)) {
                    outcome = "showSpaceDetails";
                }
                url = ExternalAccessServlet.generateExternalURL(outcome, Repository.getStoreRef().getProtocol() + "/" + Repository.getStoreRef().getIdentifier() + "/" + node.getId());
                break;
            }
            case BROWSE: {
                url = ExternalAccessServlet.generateExternalURL("browse", Repository.getStoreRef().getProtocol() + "/" + Repository.getStoreRef().getIdentifier() + "/" + node.getId());
            }
        }
        return url;
    }

    public static String generateURL(FacesContext context, Node node, URLMode usage) {
        return Utils.generateURL(context, node, node.getName(), usage);
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt, String onclick) {
        return Utils.buildImageTag(context, image, width, height, alt, onclick, null);
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt, String onclick, String verticalAlign) {
        return Utils.buildImageTag(context, image, width, height, alt, onclick, verticalAlign, null);
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt, String onclick, String verticalAlign, String style) {
        StringBuilder styleBuf;
        StringBuilder buf = new StringBuilder(200);
        style = style != null ? "border-width:0px; " + style : "border-width:0px;";
        buf.append("<img src='").append(context.getExternalContext().getRequestContextPath()).append(image).append("' width='").append(width).append("' height='").append(height).append("'");
        if (alt != null) {
            alt = Utils.encode((String)alt);
            buf.append(" alt=\"").append(alt).append("\" title=\"").append(alt).append("\"");
        } else {
            buf.append(" alt=''");
        }
        if (verticalAlign != null) {
            styleBuf = new StringBuilder(40);
            styleBuf.append(style).append("vertical-align:").append(verticalAlign).append(";");
            style = styleBuf.toString();
        }
        if (onclick != null) {
            buf.append(" onclick=\"").append(onclick).append('\"');
            styleBuf = new StringBuilder(style.length() + 16);
            styleBuf.append(style).append("cursor:pointer;");
            style = styleBuf.toString();
        }
        buf.append(" style='").append(style).append("'/>");
        return buf.toString();
    }

    public static String buildImageTag(FacesContext context, String image, int width, int height, String alt) {
        return Utils.buildImageTag(context, image, width, height, alt, null);
    }

    public static String buildImageTag(FacesContext context, String image, String alt) {
        return Utils.buildImageTag(context, image, alt, null);
    }

    public static String buildImageTag(FacesContext context, String image, String alt, String verticalAlign) {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<img src='").append(context.getExternalContext().getRequestContextPath()).append(image).append("' ");
        String style = "border-width:0px;";
        if (alt != null) {
            alt = Utils.encode((String)alt);
            buf.append(" alt=\"").append(alt).append("\" title=\"").append(alt).append('\"');
        } else {
            buf.append(" alt=''");
        }
        if (verticalAlign != null) {
            StringBuilder styleBuf = new StringBuilder(40);
            styleBuf.append(style).append("vertical-align:").append(verticalAlign).append(";");
            style = styleBuf.toString();
        }
        buf.append(" style='").append(style).append("'/>");
        return buf.toString();
    }

    public static UIForm getParentForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    public static UIComponent getParentNamingContainer(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        return parent;
    }

    public static IDataContainer getParentDataContainer(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof IDataContainer); parent = parent.getParent()) {
        }
        return (IDataContainer)parent;
    }

    public static boolean isComponentDisabledOrReadOnly(UIComponent component) {
        Object readOnlyAttr;
        boolean disabled = false;
        boolean readOnly = false;
        Object disabledAttr = component.getAttributes().get("disabled");
        if (disabledAttr != null) {
            disabled = disabledAttr.equals(Boolean.TRUE);
        }
        if (!disabled && (readOnlyAttr = component.getAttributes().get("readonly")) != null) {
            readOnly = readOnlyAttr.equals(Boolean.TRUE);
        }
        return disabled || readOnly;
    }

    public static void processActionMethod(FacesContext context, MethodBinding method, ActionEvent event) {
        try {
            method.invoke(context, new Object[]{event});
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw e;
        }
    }

    public static void addErrorMessage(String msg) {
        Utils.addErrorMessage(msg, null);
    }

    public static void addErrorMessage(String msg, Throwable err) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        context.addMessage(null, facesMsg);
        if (err != null && (!(err instanceof InvalidNodeRefException) && !(err instanceof AccessDeniedException) && !(err instanceof NoTransformerException) || logger.isDebugEnabled())) {
            logger.error((Object)msg, err);
        }
    }

    public static void addStatusMessage(FacesMessage.Severity severity, String msg) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String time = Utils.getTimeFormat(fc).format(new Date(System.currentTimeMillis()));
        FacesMessage fm = new FacesMessage(severity, time, msg);
        fc.addMessage("status-message", fm);
    }

    public static DateFormat getTimeFormat(FacesContext fc) {
        return Utils.getDateFormatFromPattern(fc, Application.getMessage(fc, MSG_TIME_PATTERN));
    }

    public static DateFormat getDateFormat(FacesContext fc) {
        return Utils.getDateFormatFromPattern(fc, Application.getMessage(fc, MSG_DATE_PATTERN));
    }

    public static DateFormat getDateTimeFormat(FacesContext fc) {
        return Utils.getDateFormatFromPattern(fc, Application.getMessage(fc, MSG_DATE_TIME_PATTERN));
    }

    private static DateFormat getDateFormatFromPattern(FacesContext fc, String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("DateTime pattern is mandatory.");
        }
        try {
            return new SimpleDateFormat(pattern, Application.getLanguage(fc));
        }
        catch (IllegalArgumentException err) {
            throw new AlfrescoRuntimeException("Invalid DateTime pattern", (Throwable)err);
        }
    }

    public static Date parseXMLDateFormat(String isoDate) {
        Date parsed = null;
        try {
            int offset = 0;
            int year = Integer.parseInt(isoDate.substring(offset, offset += 4));
            if (isoDate.charAt(offset) != '-') {
                throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
            }
            int month = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != '-') {
                throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
            }
            int day = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != 'T') {
                throw new IndexOutOfBoundsException("Expected T character but found " + isoDate.charAt(offset));
            }
            int hour = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != ':') {
                throw new IndexOutOfBoundsException("Expected : character but found " + isoDate.charAt(offset));
            }
            int minutes = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != ':') {
                throw new IndexOutOfBoundsException("Expected : character but found " + isoDate.charAt(offset));
            }
            int seconds = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            parsed = calendar.getTime();
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NumberFormatException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return parsed;
    }

    public static String getDisplayLabel(FacesContext context, ConfigElement configElement) {
        String label = null;
        String msgId = configElement.getAttribute("display-label-id");
        if (msgId != null) {
            label = Application.getMessage(context, msgId);
        }
        if (label == null) {
            label = configElement.getAttribute("display-label");
        }
        return label;
    }

    public static String getDescription(FacesContext context, ConfigElement configElement) {
        String description = null;
        String msgId = configElement.getAttribute("description-id");
        if (msgId != null) {
            description = Application.getMessage(context, msgId);
        }
        if (description == null) {
            description = configElement.getAttribute("description");
        }
        return description;
    }

    public static String getUserAgent(FacesContext context) {
        Object userAgent = context.getExternalContext().getRequestHeaderMap().get("User-Agent");
        if (userAgent != null) {
            if (userAgent.toString().indexOf("Firefox/") != -1) {
                return USER_AGENT_FIREFOX;
            }
            if (userAgent.toString().indexOf(USER_AGENT_MSIE) != -1) {
                return USER_AGENT_MSIE;
            }
            return userAgent.toString();
        }
        return "";
    }

    public static List<Pair<QName, Boolean>> generatePersonSort() {
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
        sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
        sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
        sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        return sort;
    }

    public static List<Pair<QName, String>> generatePersonFilter(String term) {
        ArrayList<Pair<QName, String>> filter = new ArrayList<Pair<QName, String>>();
        filter.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)term));
        filter.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)term));
        filter.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)term));
        return filter;
    }

    public static int getPersonMaxResults() {
        return 1000;
    }

    public static void generatePersonSearch(StringBuilder query, String term) {
        StringTokenizer t = new StringTokenizer(term.trim(), " ");
        while (t.hasMoreTokens()) {
            String token = AbstractLuceneQueryParser.escape((String)t.nextToken());
            query.append("+TYPE:\"").append(ContentModel.TYPE_PERSON).append("\" ");
            query.append("+(@").append("cm").append("\\:firstName:\"*");
            query.append(token);
            query.append("*\" @").append("cm").append("\\:lastName:\"*");
            query.append(token);
            query.append("*\" @").append("cm").append("\\:userName:");
            query.append(token);
            query.append("*) ");
        }
    }

    public static enum URLMode {
        HTTP_DOWNLOAD,
        HTTP_INLINE,
        WEBDAV,
        CIFS,
        SHOW_DETAILS,
        BROWSE,
        FTP;

    }
}

