/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;

public class UIBreadcrumb
extends UICommand {
    private String separator = null;
    private Boolean showRoot = null;
    public static final String SEPARATOR = "/";

    public UIBreadcrumb() {
        this.setRendererType("org.alfresco.faces.BreadcrumbRenderer");
    }

    public String getFamily() {
        return "org.alfresco.faces.Controls";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.separator = (String)values[1];
        this.showRoot = (Boolean)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.separator, this.showRoot};
        return values;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof BreadcrumbEvent) {
            this.setSelectedPathIndex(((BreadcrumbEvent)event).SelectedIndex);
        }
        super.broadcast(event);
    }

    public void setSelectedPathIndex(int index) {
        List elements = (List)this.getValue();
        if (elements.size() >= index) {
            ArrayList path = new ArrayList(index + 1);
            path.addAll(elements.subList(0, index + 1));
            this.setValue(path);
            String outcome = ((IBreadcrumbHandler)path.get(index)).navigationOutcome(this);
            if (outcome != null) {
                String viewId = this.getFacesContext().getViewRoot().getViewId();
                this.getFacesContext().getApplication().getNavigationHandler().handleNavigation(this.getFacesContext(), viewId, outcome);
            }
        }
    }

    public Object getValue() {
        List<DefaultPathHandler> elements = null;
        Object value = super.getValue();
        if (value instanceof String) {
            elements = new ArrayList(8);
            StringTokenizer t = new StringTokenizer((String)value, SEPARATOR);
            while (t.hasMoreTokens()) {
                DefaultPathHandler handler = new DefaultPathHandler(t.nextToken());
                elements.add(handler);
            }
            this.setValue(elements);
        } else if (value instanceof List) {
            elements = (List)value;
        } else {
            if (value != null) {
                throw new IllegalArgumentException("UIBreadcrumb value must be a String path or List of IBreadcrumbHandler!");
            }
            elements = new ArrayList(8);
        }
        return elements;
    }

    public void appendHandler(IBreadcrumbHandler handler) {
        if (handler == null) {
            throw new NullPointerException("IBreadcrumbHandler instance cannot be null!");
        }
        List elements = (List)this.getValue();
        elements.add(handler);
    }

    public String getSeparator() {
        ValueBinding vb = this.getValueBinding("separator");
        if (vb != null) {
            this.separator = (String)vb.getValue(this.getFacesContext());
        }
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean getShowRoot() {
        ValueBinding vb = this.getValueBinding("showRoot");
        if (vb != null) {
            this.showRoot = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.showRoot != null) {
            return this.showRoot;
        }
        return true;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }

    private static class DefaultPathHandler
    implements IBreadcrumbHandler {
        private String label;

        public DefaultPathHandler(String label) {
            this.label = label;
        }

        @Override
        public String toString() {
            return this.label;
        }

        @Override
        public String navigationOutcome(UIBreadcrumb breadcrumb) {
            return null;
        }
    }

    public static class BreadcrumbEvent
    extends ActionEvent {
        public int SelectedIndex = 0;

        public BreadcrumbEvent(UIComponent component, int selectedIndex) {
            super(component);
            this.SelectedIndex = selectedIndex;
        }
    }
}

