/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;

public class UIPanel
extends UICommand {
    private String border = null;
    private String bgcolor = null;
    private String titleBorder = null;
    private String titleBgcolor = null;
    private String expandedTitleBorder = null;
    private Boolean progressive = null;
    private String label = null;
    private String facetsId = null;
    private MethodBinding expandedActionListener = null;
    private boolean hasAdornments = false;
    private boolean hasBorderedTitleArea = false;
    private Boolean expanded = Boolean.TRUE;

    public UIPanel() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.Controls";
    }

    public UIComponent getTitleComponent() {
        UIForm parent;
        UIComponent facetsComponent;
        UIComponent titleComponent = null;
        String facetsId = this.getFacetsId();
        if (facetsId != null && (facetsComponent = (parent = Utils.getParentForm(FacesContext.getCurrentInstance(), (UIComponent)this)).findComponent(facetsId)) != null) {
            titleComponent = facetsComponent.getFacet("title");
        }
        return titleComponent;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String bgcolor;
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        UIComponent titleComponent = this.getTitleComponent();
        String label = this.getLabel();
        if (label != null) {
            label = Utils.encode((String)label);
        }
        if (label != null || this.isProgressive() || titleComponent != null) {
            this.hasAdornments = true;
        }
        if ((bgcolor = this.getBgcolor()) == null) {
            bgcolor = "#FFFFFF";
        }
        if (this.getTitleBgcolor() != null && this.getTitleBorder() != null && this.getBorder() != null && this.hasAdornments) {
            this.hasBorderedTitleArea = true;
        }
        if (this.hasBorderedTitleArea) {
            PanelGenerator.generatePanelStart((Writer)out, context.getExternalContext().getRequestContextPath(), this.getTitleBorder(), this.getTitleBgcolor());
        } else if (this.getBorder() != null) {
            PanelGenerator.generatePanelStart((Writer)out, context.getExternalContext().getRequestContextPath(), this.getBorder(), bgcolor);
        }
        if (this.hasAdornments) {
            out.write("<table border='0' cellspacing='0' cellpadding='0' width='100%'><tr><td>");
        }
        if (this.isProgressive()) {
            out.write("<a href='#' onclick=\"");
            String value = this.getClientId(context) + ':' + Boolean.toString(!this.isExpanded());
            out.write(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(context), value));
            out.write("\">");
            if (this.isExpanded()) {
                out.write(Utils.buildImageTag(context, "/images/icons/expanded.gif", 11, 11, this.getLabel()));
            } else {
                out.write(Utils.buildImageTag(context, "/images/icons/collapsed.gif", 11, 11, this.getLabel()));
            }
            out.write("</a>&nbsp;&nbsp;");
        }
        if (label != null) {
            out.write("<span");
            Utils.outputAttribute(out, this.getAttributes().get("style"), "style");
            Utils.outputAttribute(out, this.getAttributes().get("styleClass"), "class");
            out.write(62);
            out.write(label);
            out.write("</span>");
        }
        if (this.hasAdornments) {
            out.write("</td>");
        }
        if (titleComponent != null) {
            out.write("<td align='right'>");
            Utils.encodeRecursive(context, titleComponent);
            out.write("</td>");
        }
        if (this.hasAdornments) {
            out.write("</tr></table>");
        }
        if (this.hasBorderedTitleArea && this.isExpanded()) {
            if (this.getExpandedTitleBorder() != null) {
                PanelGenerator.generateExpandedTitledPanelMiddle((Writer)out, context.getExternalContext().getRequestContextPath(), this.getTitleBorder(), this.getExpandedTitleBorder(), this.getBorder(), this.getBgcolor());
            } else {
                PanelGenerator.generateTitledPanelMiddle((Writer)out, context.getExternalContext().getRequestContextPath(), this.getTitleBorder(), this.getBorder(), this.getBgcolor());
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        if (this.hasBorderedTitleArea && !this.isExpanded()) {
            PanelGenerator.generatePanelEnd((Writer)out, context.getExternalContext().getRequestContextPath(), this.getTitleBorder());
        } else if (this.getBorder() != null) {
            PanelGenerator.generatePanelEnd((Writer)out, context.getExternalContext().getRequestContextPath(), this.getBorder());
        }
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName(context));
        if (value != null && value.startsWith(this.getClientId(context))) {
            value = value.substring(this.getClientId(context).length() + 1);
            ExpandedEvent event = new ExpandedEvent((UIComponent)this, Boolean.parseBoolean(value));
            this.queueEvent((FacesEvent)event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ExpandedEvent) {
            this.setExpanded(((ExpandedEvent)event).State);
            if (this.getExpandedActionListener() != null) {
                Utils.processActionMethod(this.getFacesContext(), this.getExpandedActionListener(), (ExpandedEvent)event);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.setExpanded((Boolean)values[1]);
        this.progressive = (Boolean)values[2];
        this.border = (String)values[3];
        this.bgcolor = (String)values[4];
        this.label = (String)values[5];
        this.titleBgcolor = (String)values[6];
        this.titleBorder = (String)values[7];
        this.expandedTitleBorder = (String)values[8];
        this.expandedActionListener = (MethodBinding)UIPanel.restoreAttachedState((FacesContext)context, (Object)values[9]);
        this.facetsId = (String)values[10];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.isExpanded() ? Boolean.TRUE : Boolean.FALSE, this.progressive, this.border, this.bgcolor, this.label, this.titleBgcolor, this.titleBorder, this.expandedTitleBorder, UIPanel.saveAttachedState((FacesContext)context, (Object)this.expandedActionListener), this.facetsId};
        return values;
    }

    public void setExpandedActionListener(MethodBinding binding) {
        this.expandedActionListener = binding;
    }

    public MethodBinding getExpandedActionListener() {
        return this.expandedActionListener;
    }

    public String getBgcolor() {
        ValueBinding vb = this.getValueBinding("bgcolor");
        if (vb != null) {
            this.bgcolor = (String)vb.getValue(this.getFacesContext());
        }
        return this.bgcolor;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public String getBorder() {
        ValueBinding vb = this.getValueBinding("border");
        if (vb != null) {
            this.border = (String)vb.getValue(this.getFacesContext());
        }
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public String getTitleBgcolor() {
        ValueBinding vb = this.getValueBinding("titleBgcolor");
        if (vb != null) {
            this.titleBgcolor = (String)vb.getValue(this.getFacesContext());
        }
        return this.titleBgcolor;
    }

    public void setTitleBgcolor(String titleBgcolor) {
        this.titleBgcolor = titleBgcolor;
    }

    public String getTitleBorder() {
        ValueBinding vb = this.getValueBinding("titleBorder");
        if (vb != null) {
            this.titleBorder = (String)vb.getValue(this.getFacesContext());
        }
        return this.titleBorder;
    }

    public void setTitleBorder(String titleBorder) {
        this.titleBorder = titleBorder;
    }

    public String getExpandedTitleBorder() {
        ValueBinding vb = this.getValueBinding("expandedTitleBorder");
        if (vb != null) {
            this.expandedTitleBorder = (String)vb.getValue(this.getFacesContext());
        }
        return this.expandedTitleBorder;
    }

    public void setExpandedTitleBorder(String expandedTitleBorder) {
        this.expandedTitleBorder = expandedTitleBorder;
    }

    public String getLabel() {
        ValueBinding vb = this.getValueBinding("label");
        if (vb != null) {
            this.label = (String)vb.getValue(this.getFacesContext());
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isProgressive() {
        ValueBinding vb = this.getValueBinding("progressive");
        if (vb != null) {
            this.progressive = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.progressive != null) {
            return this.progressive;
        }
        return false;
    }

    public void setProgressive(boolean progressive) {
        this.progressive = progressive;
    }

    public boolean isExpanded() {
        ValueBinding vb = this.getValueBinding("expanded");
        if (vb != null) {
            this.expanded = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.expanded != null) {
            return this.expanded;
        }
        return true;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getFacetsId() {
        ValueBinding vb = this.getValueBinding("facets");
        if (vb != null) {
            this.facetsId = (String)vb.getValue(this.getFacesContext());
        }
        return this.facetsId;
    }

    public void setFacetsId(String facets) {
        this.facetsId = facets;
    }

    private String getHiddenFieldName(FacesContext fc) {
        UIForm form = Utils.getParentForm(fc, (UIComponent)this);
        return form.getClientId(fc) + ':' + "panel";
    }

    public static class ExpandedEvent
    extends ActionEvent {
        public boolean State;

        public ExpandedEvent(UIComponent component, boolean state) {
            super(component);
            this.State = state;
        }
    }
}

