/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.data;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.app.Application;
import org.alfresco.web.data.IDataContainer;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIDataPager
extends UICommand {
    private static Log s_logger = LogFactory.getLog(IDataContainer.class);
    private static final String LAST_PAGE = "last_page";
    private static final String NEXT_PAGE = "next_page";
    private static final String PREVIOUS_PAGE = "prev_page";
    private static final String FIRST_PAGE = "first_page";
    private static final String MSG_PAGEINFO = "page_info";
    private static final int VISIBLE_PAGE_RANGE = 3;
    private static final int AMOUNT_FIRST_PAGES = 7;

    public UIDataPager() {
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        IDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            throw new IllegalStateException("Must nest UISortLink inside component implementing IDataContainer!");
        }
        if (!this.isRendered() || dataContainer.getPageSize() == -1) {
            return;
        }
        String formClientId = Utils.getParentForm(context, (UIComponent)this).getClientId(context);
        String pageInputId = this.getPageInputId();
        String hiddenFieldName = this.getHiddenFieldName();
        ResponseWriter out = context.getResponseWriter();
        ResourceBundle bundle = Application.getBundle(context);
        StringBuilder buf = new StringBuilder(512);
        int currentPage = dataContainer.getCurrentPage();
        int pageCount = dataContainer.getPageCount();
        Object displayInput = this.getAttributes().get("displayInput");
        String beginTag = "<span";
        String endTag = "</span>";
        String divStyle = "";
        String inputStyle = "height:13px;";
        String imageVericalAlign = null;
        String imageStyle = "margin-top:0px;";
        StringBuilder inputPageNumber = new StringBuilder(128);
        if (displayInput != null && !((Boolean)displayInput).booleanValue()) {
            imageStyle = null;
            inputPageNumber.append(currentPage + 1);
        } else {
            boolean isIE = "MSIE".equals(Utils.getUserAgent(context));
            if (isIE) {
                beginTag = "<div";
                endTag = "</div>";
                divStyle = "padding:1px;";
                inputStyle = "height:13px; vertical-align:middle;";
                imageVericalAlign = "middle";
                imageStyle = "margin-top:0px;";
                inputPageNumber.append("<input type=\"text\" maxlength=\"3\" value=\"").append(currentPage + 1).append("\" style=\"width: 24px; margin-left: 4px;").append(inputStyle).append("\" ");
                inputPageNumber.append("onkeydown=\"").append(this.generateIE6InputOnkeydownScript(pageInputId, formClientId, hiddenFieldName)).append("\" ");
                inputPageNumber.append("id=\"").append(pageInputId).append("\" />");
            } else {
                inputPageNumber.append("<input type=\"text\" maxlength=\"3\" value=\"").append(currentPage + 1).append("\" style=\"width: 24px; margin-left: 4px;").append(inputStyle).append("\" ");
                inputPageNumber.append("onkeypress=\"").append(this.generateInputOnkeyPressScript(pageInputId, formClientId, hiddenFieldName)).append("\" ");
                inputPageNumber.append("onkeydown=\"").append(this.generateInputOnkeydownScript()).append("\" ");
                inputPageNumber.append("id=\"").append(pageInputId).append("\" />");
            }
        }
        buf.append(beginTag);
        if (this.getAttributes().get("style") != null) {
            buf.append(" style=\"").append(this.getAttributes().get("style")).append(divStyle).append('\"');
        }
        if (this.getAttributes().get("styleClass") != null) {
            buf.append(" class=").append(this.getAttributes().get("styleClass"));
        }
        buf.append('>');
        buf.append(MessageFormat.format(bundle.getString(MSG_PAGEINFO), inputPageNumber.toString(), Integer.toString(pageCount)));
        buf.append("&nbsp;&nbsp;");
        if (currentPage != 0) {
            buf.append("<a href='#' onclick=\"");
            buf.append(this.generateEventScript(0, hiddenFieldName));
            buf.append("\">");
            buf.append(Utils.buildImageTag(context, "/images/icons/FirstPage.gif", 16, 16, bundle.getString(FIRST_PAGE), null, imageVericalAlign, imageStyle));
            buf.append("</a>");
        } else {
            buf.append(Utils.buildImageTag(context, "/images/icons/FirstPage_unavailable.gif", 16, 16, null, null, imageVericalAlign, imageStyle));
        }
        buf.append("&nbsp;");
        if (currentPage != 0) {
            buf.append("<a href='#' onclick=\"");
            buf.append(this.generateEventScript(currentPage - 1, hiddenFieldName));
            buf.append("\">");
            buf.append(Utils.buildImageTag(context, "/images/icons/PreviousPage.gif", 16, 16, bundle.getString(PREVIOUS_PAGE), null, imageVericalAlign, imageStyle));
            buf.append("</a>");
        } else {
            buf.append(Utils.buildImageTag(context, "/images/icons/PreviousPage_unavailable.gif", 16, 16, null, null, imageVericalAlign, imageStyle));
        }
        buf.append("&nbsp;");
        Object objType = this.getAttributes().get("dataPagerType");
        PagerType type = PagerType.TRACKPAGE;
        if (objType instanceof String) {
            try {
                type = PagerType.valueOf((String)objType);
            }
            catch (Throwable ex) {
                s_logger.warn((Object)("DataPager id:" + this.getId() + " with incorrect 'numberPageType' attribute"));
            }
        }
        switch (type) {
            case STANDARD: {
                this.encodeType0(buf, currentPage, pageCount);
                break;
            }
            case DECADES: {
                this.encodeType1(buf, currentPage, pageCount);
                break;
            }
            case TRACKPAGE: {
                this.encodeType2(buf, currentPage, pageCount);
                break;
            }
            default: {
                this.encodeType2(buf, currentPage, pageCount);
            }
        }
        if (dataContainer.getCurrentPage() < dataContainer.getPageCount() - 1) {
            buf.append("<a href='#' onclick=\"");
            buf.append(this.generateEventScript(currentPage + 1, hiddenFieldName));
            buf.append("\">");
            buf.append(Utils.buildImageTag(context, "/images/icons/NextPage.gif", 16, 16, bundle.getString(NEXT_PAGE), null, imageVericalAlign, imageStyle));
            buf.append("</a>");
        } else {
            buf.append(Utils.buildImageTag(context, "/images/icons/NextPage_unavailable.gif", 16, 16, null, null, imageVericalAlign, imageStyle));
        }
        buf.append("&nbsp;");
        if (dataContainer.getCurrentPage() < dataContainer.getPageCount() - 1) {
            buf.append("<a href='#' onclick=\"");
            buf.append(this.generateEventScript(dataContainer.getPageCount() - 1, hiddenFieldName));
            buf.append("\">");
            buf.append(Utils.buildImageTag(context, "/images/icons/LastPage.gif", 16, 16, bundle.getString(LAST_PAGE), null, imageVericalAlign, imageStyle));
            buf.append("</a>");
        } else {
            buf.append(Utils.buildImageTag(context, "/images/icons/LastPage_unavailable.gif", 16, 16, null, null, imageVericalAlign, imageStyle));
        }
        buf.append(endTag);
        out.write(buf.toString());
    }

    private void createClicableDigitForPage(int num, StringBuilder buf) {
        buf.append("<a href='#' onclick=\"").append(this.generateEventScript(num, this.getHiddenFieldName())).append("\">").append(num + 1).append("</a>&nbsp;");
    }

    private void createDigitForPage(int num, StringBuilder buf) {
        buf.append("<b>").append(num + 1).append("</b>&nbsp;");
    }

    private void encodeType0(StringBuilder buf, int currentPage, int pageCount) {
        int i;
        int totalIndex = pageCount < 10 ? pageCount : 10;
        for (i = 0; i < totalIndex; ++i) {
            if (i != currentPage) {
                this.createClicableDigitForPage(i, buf);
                continue;
            }
            this.createDigitForPage(i, buf);
        }
        if (pageCount >= 20) {
            buf.append("...&nbsp;");
            totalIndex = pageCount / 10 * 10;
            totalIndex = totalIndex < 100 ? totalIndex : 100;
            for (i = 19; i < totalIndex; i += 10) {
                if (i != currentPage) {
                    this.createClicableDigitForPage(i, buf);
                    continue;
                }
                this.createDigitForPage(i, buf);
            }
        }
        if (pageCount > 10 && pageCount % 10 != 0) {
            if (pageCount - 1 != currentPage) {
                if (pageCount < 20) {
                    buf.append("...&nbsp;");
                }
                this.createClicableDigitForPage(pageCount - 1, buf);
            } else {
                if (pageCount < 20) {
                    buf.append("...&nbsp;");
                }
                this.createDigitForPage(pageCount - 1, buf);
            }
        }
    }

    private void encodeType1(StringBuilder buf, int currentPage, int pageCount) {
        int number;
        int totalIndex;
        block16: {
            totalIndex = pageCount < 10 ? pageCount : 10;
            number = -1;
            if (currentPage == 0) {
                number = this.generateClickableDigitForPageCurrent(currentPage, pageCount, buf, false, currentPage + 3 + 1 < pageCount);
            }
            if (currentPage > 4) {
                this.createClicableDigitForPage(0, buf);
            }
            if (currentPage <= 9 && currentPage != 0) {
                number = this.generateClickableDigitForPageCurrent(currentPage, pageCount, buf, currentPage > 4, currentPage + 3 + 1 < pageCount);
            }
            if (number <= 9 && currentPage < 100 && pageCount > 9) {
                this.createClicableDigitForPage(9, buf);
            }
            if (pageCount < 10) break block16;
            int i = 19;
            totalIndex = pageCount / 10 * 10;
            totalIndex = totalIndex < 100 ? totalIndex : 100;
            int stepIndex = (currentPage + 1) / 100;
            if (stepIndex > 0) {
                i = 100 * stepIndex;
                totalIndex = i + 100;
                --i;
                if (pageCount < totalIndex) {
                    totalIndex = pageCount;
                }
            }
            while (i < totalIndex) {
                block18: {
                    block19: {
                        block17: {
                            if (i > currentPage || currentPage > i + 3) break block17;
                            this.generateClickableDigitForPageCurrent(currentPage, pageCount, buf, true, currentPage + 1 + 3 < totalIndex);
                            break block18;
                        }
                        if (currentPage >= i || currentPage <= i - 10 + 3) break block19;
                        number = this.generateClickableDigitForPageCurrent(currentPage, pageCount, buf, true, currentPage + 3 + 2 < totalIndex);
                        if (number + 1 < pageCount) {
                            buf.append("...&nbsp;");
                        }
                        if (currentPage + 3 >= i) break block18;
                    }
                    if (i != currentPage) {
                        this.createClicableDigitForPage(i, buf);
                    } else {
                        this.createDigitForPage(i, buf);
                    }
                }
                i += 10;
            }
        }
        if (number != pageCount && totalIndex < pageCount) {
            if (pageCount > number) {
                this.createClicableDigitForPage(pageCount - 1, buf);
            } else {
                this.createDigitForPage(pageCount - 1, buf);
            }
        }
    }

    private void encodeType2(StringBuilder buf, int currentPage, int pageCount) {
        int number = 7;
        if (currentPage + 3 < 7) {
            int totalIndex = 7 < pageCount ? 7 : pageCount;
            for (int i = 0; i < totalIndex; ++i) {
                if (i != currentPage) {
                    this.createClicableDigitForPage(i, buf);
                    continue;
                }
                this.createDigitForPage(i, buf);
            }
            if (currentPage + 3 + 1 < pageCount) {
                buf.append("...&nbsp;");
            }
        } else {
            this.createClicableDigitForPage(0, buf);
            number = this.generateClickableDigitForPageCurrent(currentPage, pageCount, buf, currentPage > 4, currentPage + 1 + 3 < pageCount);
        }
        if (number < pageCount) {
            if (pageCount > number) {
                this.createClicableDigitForPage(pageCount - 1, buf);
            } else {
                this.createDigitForPage(pageCount - 1, buf);
            }
        }
    }

    private int generateClickableDigitForPageCurrent(int currentPage, int pageCount, StringBuilder buf, boolean startDivider, boolean finishDivider) {
        int i;
        int startPage = currentPage - 3;
        if (startPage < 0) {
            startPage = 0;
        }
        if (startDivider) {
            buf.append("...&nbsp;");
        }
        for (i = startPage; i < currentPage; ++i) {
            this.createClicableDigitForPage(i, buf);
        }
        buf.append("<b>").append(currentPage + 1).append("</b>&nbsp;");
        i = currentPage + 1;
        int finishPage = currentPage + 3;
        if (finishPage >= pageCount) {
            finishPage = pageCount - 1;
        }
        while (i <= finishPage) {
            this.createClicableDigitForPage(i, buf);
            ++i;
        }
        if (finishDivider) {
            buf.append("...&nbsp;");
        }
        return i;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName());
        if (value != null && value.length() != 0) {
            PageEvent actionEvent = new PageEvent((UIComponent)this, Integer.valueOf(value));
            this.queueEvent((FacesEvent)actionEvent);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof PageEvent)) {
            super.broadcast(event);
        } else {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Handling paging event to index: " + ((PageEvent)event).Page));
            }
            this.getDataContainer().setCurrentPage(((PageEvent)event).Page);
        }
    }

    private IDataContainer getDataContainer() {
        return Utils.getParentDataContainer(this.getFacesContext(), (UIComponent)this);
    }

    private String generateEventScript(int page, String hiddenFieldName) {
        return Utils.generateFormSubmit(this.getFacesContext(), (UIComponent)this, hiddenFieldName, Integer.toString(page));
    }

    private String getHiddenFieldName() {
        UIComponent dataContainer = (UIComponent)Utils.getParentDataContainer(this.getFacesContext(), (UIComponent)this);
        return dataContainer.getClientId(this.getFacesContext()) + ':' + "pager";
    }

    private String generateInputOnkeyPressScript(String pageInputId, String formClientId, String hiddenFieldName) {
        StringBuilder script = new StringBuilder(128);
        script.append("return validateAndSubmit(event,'").append(this.getPageInputId()).append("','").append(formClientId).append("','").append(hiddenFieldName).append("');");
        return script.toString();
    }

    private String generateInputOnkeydownScript() {
        return "return onlyDigits(event);";
    }

    private String generateIE6InputOnkeydownScript(String pageInputId, String formClientId, String hiddenFieldName) {
        StringBuilder script = new StringBuilder(128);
        script.append("return onlyDigitsIE6(event,'").append(this.getPageInputId()).append("','").append(formClientId).append("','").append(hiddenFieldName).append("');");
        return script.toString();
    }

    private String getPageInputId() {
        return this.getHiddenFieldName() + ':' + "pageNamber";
    }

    private static enum PagerType {
        STANDARD,
        DECADES,
        TRACKPAGE;

    }

    private static class PageEvent
    extends ActionEvent {
        private static final long serialVersionUID = -5338654505243607790L;
        public int Page = 0;

        public PageEvent(UIComponent component, int page) {
            super(component);
            this.Page = page;
        }
    }
}

