/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.debug;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.app.Application;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public abstract class BaseDebugComponent
extends SelfRenderingComponent {
    private String title;
    private static String COMPONENT_PROPERTY = "component_property";
    private static String COMPONENT_VALUE = "component_value";

    public abstract Map getDebugData();

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("<table cellpadding='2' cellspacing='2' border='0' style='border: 1px solid #aaaaaa;border-collapse: collapse;border-spacing: 0px;'>");
        if (this.getTitle() != null) {
            out.write("<tr><td colspan='2'>");
            out.write(this.getTitle());
            out.write("</td></tr>");
        }
        out.write("<tr style='border: 1px solid #dddddd;'><th align='left'>");
        out.write(Application.getMessage(context, COMPONENT_PROPERTY));
        out.write("</th><th align='left'>");
        out.write(Application.getMessage(context, COMPONENT_VALUE));
        out.write("</th></tr>");
        Map session = this.getDebugData();
        for (Object key : session.keySet()) {
            out.write("<tr style='border: 1px solid #dddddd;'><td>");
            out.write(key.toString());
            out.write("</td><td>");
            Object obj = session.get(key);
            if (obj == null) {
                out.write("null");
            } else {
                String value = obj.toString();
                if (value.length() == 0) {
                    out.write("&nbsp;");
                } else {
                    value = value.replaceAll(";", "; ");
                    out.write(value);
                }
            }
            out.write("</td></tr>");
        }
        out.write("</table>");
        super.encodeBegin(context);
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.title = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.title};
        return values;
    }

    public String getTitle() {
        ValueBinding vb = this.getValueBinding("title");
        if (vb != null) {
            this.title = (String)vb.getValue(this.getFacesContext());
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

