/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.debug;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.alfresco.web.ui.common.component.debug.BaseDebugComponent;

public class UISystemProperties
extends BaseDebugComponent {
    public String getFamily() {
        return "org.alfresco.faces.debug.SystemProperties";
    }

    @Override
    public Map getDebugData() {
        TreeMap<Object, Object> properties = new TreeMap<Object, Object>();
        Properties systemProperties = System.getProperties();
        properties.putAll(systemProperties);
        properties.put("heap.size", UISystemProperties.formatBytes(Runtime.getRuntime().totalMemory()));
        properties.put("heap.maxsize", UISystemProperties.formatBytes(Runtime.getRuntime().maxMemory()));
        properties.put("heap.free", UISystemProperties.formatBytes(Runtime.getRuntime().freeMemory()));
        return properties;
    }

    private static String formatBytes(long bytes) {
        float f = bytes / 1024L;
        return String.format("%.3fMB (%d bytes)", Float.valueOf(f /= 1024.0f), bytes);
    }
}

