/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.converter;

import java.text.DecimalFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.alfresco.web.app.Application;

public class ByteSizeConverter
implements Converter {
    public static final String CONVERTER_ID = "org.alfresco.faces.ByteSizeConverter";
    private static final String MSG_POSTFIX_KB = "kilobyte";
    private static final String MSG_POSTFIX_MB = "megabyte";
    private static final String MSG_POSTFIX_GB = "gigabyte";
    private static final String NUMBER_PATTERN = "###,###.##";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        return Long.parseLong(value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        long size;
        if (value instanceof Long) {
            size = (Long)value;
        } else if (value instanceof String) {
            try {
                size = Long.parseLong((String)value);
            }
            catch (NumberFormatException ne) {
                return (String)value;
            }
        } else {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat(NUMBER_PATTERN);
        StringBuilder buf = new StringBuilder();
        if (size < 999999L) {
            double val = (double)size / 1024.0;
            buf.append(formatter.format(val)).append(' ').append(Application.getMessage(context, MSG_POSTFIX_KB));
        } else if (size < 999999999L) {
            double val = (double)size / 1048576.0;
            buf.append(formatter.format(val)).append(' ').append(Application.getMessage(context, MSG_POSTFIX_MB));
        } else {
            double val = (double)size / 1.073741824E9;
            buf.append(formatter.format(val)).append(' ').append(Application.getMessage(context, MSG_POSTFIX_GB));
        }
        return buf.toString();
    }
}

