/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIMenu;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.alfresco.web.ui.repo.component.UIActions;

public class ActionLinkRenderer
extends BaseRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = Utils.getActionHiddenFieldName(context, component));
        if (value != null && value.equals(component.getClientId(context))) {
            UIActionLink link = (UIActionLink)component;
            Map<String, String> destParams = link.getParameterMap();
            Map<String, String> actionParams = ActionLinkRenderer.getParameterComponents((UIComponent)link);
            if (actionParams != null) {
                for (String name : actionParams.keySet()) {
                    String paramValue = (String)requestMap.get(name);
                    destParams.put(name, paramValue);
                }
            }
            ActionEvent event = new ActionEvent(component);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        UIActionLink link = (UIActionLink)component;
        if (link.getValue() != null) {
            ResponseWriter out = context.getResponseWriter();
            UIComponent verticalContiner = ActionLinkRenderer.getVerticalContainer(link);
            if (verticalContiner != null) {
                int padding = link.getPadding();
                if (verticalContiner instanceof UIActions) {
                    padding = ((UIActions)verticalContiner).getVerticalSpacing();
                }
                this.renderMenuAction(context, (Writer)out, link, padding);
            } else {
                this.renderActionLink(context, (Writer)out, link);
            }
        }
    }

    private void renderActionLink(FacesContext context, Writer out, UIActionLink link) throws IOException {
        String image = link.getImage();
        if (image != null) {
            int padding = link.getPadding();
            if (padding != 0) {
                out.write("<table cellspacing='0' cellpadding='0'><tr><td style='width:16px;'>");
            }
            if (!link.getShowLink()) {
                this.renderActionLinkAnchor(context, out, link);
            }
            String verticalAlign = link.getVerticalAlign();
            out.write(Utils.buildImageTag(context, image, null != link.getTooltip() ? link.getTooltip() : (String)link.getValue(), verticalAlign == null ? "-4px" : verticalAlign));
            if (!link.getShowLink()) {
                out.write("</a>");
            } else {
                if (padding != 0) {
                    out.write("</td><td style='padding:");
                    out.write(Integer.toString(padding));
                    out.write("px;'>");
                }
                this.renderActionLinkAnchor(context, out, link);
                out.write(Utils.encode((String)link.getValue().toString()));
                out.write("</a>");
            }
            if (padding != 0) {
                out.write("</td></tr></table>");
            }
        } else {
            this.renderActionLinkAnchor(context, out, link);
            out.write(Utils.encode((String)link.getValue().toString()));
            out.write("</a>");
        }
    }

    private void renderActionLinkAnchor(FacesContext context, Writer out, UIActionLink link) throws IOException {
        Map attrs = link.getAttributes();
        if (link.getHref() == null) {
            out.write("<a href='#' onclick=\"");
            if (link.getOnclick() != null) {
                out.write(link.getOnclick());
            } else {
                out.write(Utils.generateFormSubmit(context, (UIComponent)link, Utils.getActionHiddenFieldName(context, (UIComponent)link), link.getClientId(context), ActionLinkRenderer.getParameterComponents((UIComponent)link)));
            }
            out.write(34);
        } else {
            String href = link.getHref();
            out.write("<a href=\"");
            if (href.startsWith("/")) {
                out.write(context.getExternalContext().getRequestContextPath());
            }
            out.write(href);
            this.renderHrefParams(link, out, href);
            out.write(34);
            if (link.getTarget() != null) {
                out.write(" target='");
                out.write(link.getTarget());
                out.write("'");
            }
        }
        if (attrs.get("id") != null) {
            out.write(" id='");
            out.write((String)attrs.get("id"));
            out.write("'");
        }
        boolean appliedStyle = false;
        if (attrs.get("style") != null) {
            out.write(" style='");
            out.write((String)attrs.get("style"));
            out.write("'");
            appliedStyle = true;
        }
        if (attrs.get("styleClass") != null) {
            out.write(" class='");
            out.write((String)attrs.get("styleClass"));
            out.write("'");
            appliedStyle = true;
        }
        if (!appliedStyle && link.getShowLink() && link.getImage() != null && link.getPadding() == 0) {
            out.write(" style='padding-left:2px;vertical-align:0%'");
        }
        if (link.getTooltip() != null) {
            out.write(" title=\"");
            out.write(Utils.encode((String)link.getTooltip()));
            out.write(34);
        }
        out.write(62);
    }

    private void renderHrefParams(UIActionLink link, Writer out, String href) throws IOException {
        Map<String, String> actionParams = ActionLinkRenderer.getParameterComponents((UIComponent)link);
        if (actionParams != null) {
            boolean first = href.indexOf(63) == -1;
            for (String name : actionParams.keySet()) {
                String paramValue = actionParams.get(name);
                if (first) {
                    out.write(63);
                    first = false;
                } else {
                    out.write(38);
                }
                try {
                    out.write(name);
                    out.write("=");
                    out.write(URLEncoder.encode(paramValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException err) {}
            }
        }
    }

    private void renderMenuAction(FacesContext context, Writer out, UIActionLink link, int padding) throws IOException {
        out.write("<tr><td>");
        if (link.getImage() != null) {
            out.write(Utils.buildImageTag(context, link.getImage(), (String)link.getValue()));
        }
        out.write("</td><td");
        if (padding != 0) {
            out.write(" style=\"padding:");
            out.write(Integer.toString(padding));
            out.write("px\">");
        } else {
            out.write(">");
        }
        if (link.getHref() == null) {
            out.write("<a href='#' onclick=\"");
            if (link.getOnclick() != null) {
                out.write(link.getOnclick());
            } else {
                out.write(Utils.generateFormSubmit(context, (UIComponent)link, Utils.getActionHiddenFieldName(context, (UIComponent)link), link.getClientId(context), ActionLinkRenderer.getParameterComponents((UIComponent)link)));
            }
            out.write(34);
        } else {
            String href = link.getHref();
            if (!href.startsWith("http")) {
                href = context.getExternalContext().getRequestContextPath() + href;
            }
            out.write("<a href=\"");
            out.write(href);
            this.renderHrefParams(link, out, href);
            out.write(34);
            if (link.getTarget() != null) {
                out.write(" target=\"");
                out.write(link.getTarget());
                out.write("\"");
            }
        }
        Map attrs = link.getAttributes();
        if (attrs.get("style") != null) {
            out.write(" style=\"");
            out.write((String)attrs.get("style"));
            out.write(34);
        }
        if (attrs.get("styleClass") != null) {
            out.write(" class=\"");
            out.write((String)attrs.get("styleClass"));
            out.write(34);
        }
        out.write(62);
        out.write(Utils.encode((String)link.getValue().toString()));
        out.write("</a>");
        out.write("</td></tr>");
    }

    private static UIComponent getVerticalContainer(UIActionLink link) {
        UIComponent parent;
        for (parent = link.getParent(); !(parent == null || parent instanceof UIMenu || parent instanceof UIActions && ((UIActions)parent).getVerticalSpacing() != 0); parent = parent.getParent()) {
        }
        return parent;
    }
}

