/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.UIBreadcrumb;
import org.alfresco.web.ui.common.renderer.BaseRenderer;

public class BreadcrumbRenderer
extends BaseRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = BreadcrumbRenderer.getHiddenFieldName(context, component));
        if (value != null && value.length() != 0) {
            int selectedIndex = Integer.parseInt(value);
            UIBreadcrumb.BreadcrumbEvent event = new UIBreadcrumb.BreadcrumbEvent(component, selectedIndex);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            ResponseWriter out = context.getResponseWriter();
            UIBreadcrumb breadcrumb = (UIBreadcrumb)component;
            List elements = (List)breadcrumb.getValue();
            boolean first = true;
            for (int index = 0; index < elements.size(); ++index) {
                IBreadcrumbHandler element = (IBreadcrumbHandler)elements.get(index);
                if (index == 0 && !breadcrumb.getShowRoot()) continue;
                out.write(this.renderBreadcrumb(context, breadcrumb, element.toString(), index, first));
                first = false;
            }
        }
    }

    private String renderBreadcrumb(FacesContext context, UIBreadcrumb bc, String element, int index, boolean first) {
        StringBuilder buf = new StringBuilder(200);
        if (!first) {
            buf.append(' ').append(Utils.encode((String)bc.getSeparator())).append(' ');
        }
        buf.append("<a href='#' onclick=\"");
        buf.append(Utils.generateFormSubmit(context, (UIComponent)bc, BreadcrumbRenderer.getHiddenFieldName(context, (UIComponent)bc), Integer.toString(index)));
        buf.append('\"');
        if (bc.getAttributes().get("style") != null) {
            buf.append(" style=\"").append(bc.getAttributes().get("style")).append('\"');
        }
        if (bc.getAttributes().get("styleClass") != null) {
            buf.append(" class=\"").append(bc.getAttributes().get("styleClass")).append('\"');
        }
        if (bc.getAttributes().get("tooltip") != null) {
            buf.append(" title=\"").append(bc.getAttributes().get("tooltip")).append('\"');
        }
        buf.append('>');
        buf.append(Utils.encode((String)element));
        buf.append("</a>");
        return buf.toString();
    }

    private static String getHiddenFieldName(FacesContext context, UIComponent component) {
        return component.getClientId(context);
    }
}

