/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.app.Application;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.renderer.BaseRenderer;

public class ErrorsRenderer
extends BaseRenderer {
    private static final String DEFAULT_MESSAGE = "wizard_errors";
    private static final String ERROR_HINT = "error";
    private static final String DEFAULT_CSS_INFO = "statusInfoText";
    private static final String DEFAULT_CSS_ERROR = "statusErrorText";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        Iterator messages = context.getMessages();
        if (messages.hasNext()) {
            FacesMessage fm;
            String infoClass;
            ResponseWriter out = context.getResponseWriter();
            String contextPath = context.getExternalContext().getRequestContextPath();
            String styleClass = (String)component.getAttributes().get("styleClass");
            String errorClass = (String)component.getAttributes().get("errorClass");
            if (errorClass == null) {
                errorClass = DEFAULT_CSS_ERROR;
            }
            if ((infoClass = (String)component.getAttributes().get("infoClass")) == null) {
                infoClass = DEFAULT_CSS_INFO;
            }
            String message = (String)component.getAttributes().get("message");
            String errorHint = Application.getMessage(context, ERROR_HINT);
            if (message == null) {
                ValueBinding vb = component.getValueBinding("message");
                if (vb != null) {
                    message = (String)vb.getValue(context);
                }
                if (message == null) {
                    message = Application.getMessage(context, DEFAULT_MESSAGE);
                }
            }
            PanelGenerator.generatePanelStart((Writer)out, contextPath, "yellowInner", "#ffffcc");
            out.write("\n<div");
            if (styleClass != null) {
                ErrorsRenderer.outputAttribute(out, styleClass, "class");
            }
            out.write(">");
            if (message.length() > 0 && context.getMaximumSeverity().compareTo((Object)FacesMessage.SEVERITY_WARN) > 0) {
                out.write("<img src='");
                out.write(contextPath);
                out.write("/images/icons/info_icon.gif' alt='");
                out.write(Utils.encode((String)errorHint));
                out.write("' align='absmiddle'/>&nbsp;&nbsp;");
                out.write(Utils.encode((String)message));
                out.write("\n<ul style='margin:2px;'>");
                while (messages.hasNext()) {
                    fm = (FacesMessage)messages.next();
                    out.write("<li");
                    this.renderMessageAttrs(fm, out, errorClass, infoClass);
                    out.write(">");
                    out.write(Utils.encode((String)fm.getDetail()));
                    out.write("</li>\n");
                }
                out.write("</ul>");
            } else {
                out.write("<table border='0' cellpadding='3' cellspacing='0'><tr><td valign='top'><img src='");
                out.write(contextPath);
                out.write("/images/icons/info_icon.gif' alt='");
                out.write(Utils.encode((String)errorHint));
                out.write("'/>");
                out.write("</td><td>");
                while (messages.hasNext()) {
                    fm = (FacesMessage)messages.next();
                    out.write("<div style='margin-bottom: 3px;'");
                    this.renderMessageAttrs(fm, out, errorClass, infoClass);
                    out.write(">");
                    out.write(Utils.encode((String)fm.getDetail()));
                    out.write("</div>\n");
                }
                out.write("</td></tr></table>");
            }
            out.write("</div>\n");
            PanelGenerator.generatePanelEnd((Writer)out, contextPath, "yellowInner");
            out.write("<div style='padding:2px;'></div>");
        }
    }

    public boolean getRendersChildren() {
        return false;
    }

    private void renderMessageAttrs(FacesMessage fm, ResponseWriter out, String errorClass, String infoClass) throws IOException {
        if (errorClass != null && (fm.getSeverity() == FacesMessage.SEVERITY_ERROR || fm.getSeverity() == FacesMessage.SEVERITY_FATAL)) {
            out.write(" class='");
            out.write(errorClass);
            out.write("'");
        }
        if (infoClass != null && (fm.getSeverity() == FacesMessage.SEVERITY_INFO || fm.getSeverity() == FacesMessage.SEVERITY_WARN)) {
            out.write(" class='");
            out.write(infoClass);
            out.write("'");
        }
    }
}

