/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.PropertyNotFoundException;
import org.alfresco.web.app.Application;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIImagePicker;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIListItems;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public class ImagePickerRadioRenderer
extends BaseRenderer {
    private static Log logger = LogFactory.getLog(ImagePickerRadioRenderer.class);
    private int columns;
    private int position;
    private boolean open;
    private boolean imageSelected = false;

    public void decode(FacesContext context, UIComponent component) {
        if (Utils.isComponentDisabledOrReadOnly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramsMap = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)paramsMap.get(clientId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Submitted value = " + submittedValue));
        }
        ((UIInput)component).setSubmittedValue((Object)submittedValue);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        this.columns = 1;
        this.position = 0;
        this.open = false;
        this.imageSelected = false;
        ResponseWriter out = context.getResponseWriter();
        UIImagePicker imagePicker = (UIImagePicker)component;
        Map attrs = imagePicker.getAttributes();
        out.write("<table cellpadding='0'");
        ImagePickerRadioRenderer.outputAttribute(out, attrs.get("spacing"), "cellspacing");
        ImagePickerRadioRenderer.outputAttribute(out, attrs.get("styleClass"), "class");
        ImagePickerRadioRenderer.outputAttribute(out, attrs.get("style"), "style");
        out.write(">\n");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        UIImagePicker imagePicker = (UIImagePicker)component;
        Map attrs = imagePicker.getAttributes();
        Integer cols = (Integer)attrs.get("columns");
        if (cols != null && cols instanceof Integer) {
            this.columns = cols;
        }
        String onclick = (String)attrs.get("onclick");
        ResponseWriter out = context.getResponseWriter();
        String configSection = (String)attrs.get("configSection");
        if (configSection != null && configSection.length() > 0) {
            ConfigElement iconsCfg;
            ConfigService cfgService = Application.getConfigService(context);
            Config cfg = cfgService.getConfig((Object)configSection);
            if (cfg != null && (iconsCfg = cfg.getConfigElement("icons")) != null) {
                for (ConfigElement icon : iconsCfg.getChildren()) {
                    String iconName = icon.getAttribute("name");
                    String iconPath = icon.getAttribute("path");
                    if (iconName == null || iconPath == null) continue;
                    UIListItem item = new UIListItem();
                    item.setValue(iconName);
                    item.setImage(iconPath);
                    this.renderItem(context, out, imagePicker, item, onclick);
                }
            }
        } else {
            try {
                for (UIComponent child : imagePicker.getChildren()) {
                    if (child instanceof UIListItems) {
                        Object listItems = ((UIListItems)child).getValue();
                        if (!(listItems instanceof Collection)) continue;
                        for (UIListItem item : (Collection)listItems) {
                            if (!item.isRendered()) continue;
                            this.renderItem(context, out, imagePicker, item, onclick);
                        }
                        continue;
                    }
                    if (!(child instanceof UIListItem) || !child.isRendered()) continue;
                    UIListItem item = (UIListItem)child;
                    this.renderItem(context, out, imagePicker, item, onclick);
                }
            }
            catch (PropertyNotFoundException pnfe) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to retrieve icons: " + pnfe.toString()));
                }
                out.write(Application.getMessage(context, "no_icons_found"));
            }
        }
        if (this.open) {
            out.write("</tr>\n");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.write("</table>");
        if (!this.imageSelected) {
            out.write("\n<script type='text/javascript'>document.getElementById('");
            out.write(component.getClientId(context));
            out.write("').checked = true;</script>\n");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void renderItem(FacesContext context, ResponseWriter out, UIImagePicker imagePicker, UIListItem item, String onclick) throws IOException {
        Object itemValue;
        String tooltip = (String)item.getAttributes().get("tooltip");
        if (this.position % this.columns == 0) {
            if (this.open) {
                out.write("</tr>\n");
                this.open = false;
            }
            out.write("<tr>");
            this.open = true;
        }
        out.write("<td>");
        out.write("<input type='radio' name='");
        out.write(imagePicker.getClientId(context));
        out.write("' id='");
        out.write(imagePicker.getClientId(context));
        out.write("' value='");
        out.write(item.getValue().toString());
        out.write("'");
        Object currentValue = imagePicker.getSubmittedValue();
        if (currentValue == null) {
            currentValue = imagePicker.getValue();
        }
        if ((itemValue = item.getValue()) != null && itemValue.equals(currentValue)) {
            out.write(" checked='true'");
            this.imageSelected = true;
        }
        if (tooltip != null) {
            out.write(" title=\"");
            out.write(Utils.encode((String)tooltip));
            out.write(34);
        }
        if (onclick != null) {
            out.write(" onclick='");
            out.write(onclick);
            out.write("'");
        }
        out.write(">");
        out.write("</td><td align='center'>");
        String image = item.getImage();
        if (image == null) {
            throw new IllegalStateException("All child items must specify an image");
        }
        out.write(Utils.buildImageTag(context, image, tooltip));
        String label = (String)item.getAttributes().get("label");
        if (label != null && label.length() > 0) {
            out.write("<br/>");
            out.write(Utils.encode((String)label));
        }
        out.write("</td>");
        ++this.position;
    }
}

