/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIListItems;
import org.alfresco.web.ui.common.component.UIMenu;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.renderer.BaseRenderer;

public class ModeListRenderer
extends BaseRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = ModeListRenderer.getHiddenFieldName(context, component));
        if (value != null && value.startsWith(component.getClientId(context) + ':')) {
            String selectedValue = value.substring(component.getClientId(context).length() + 1);
            UIModeList.ModeListItemSelectedEvent event = new UIModeList.ModeListItemSelectedEvent(component, selectedValue);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        UIModeList list = (UIModeList)component;
        ResponseWriter out = context.getResponseWriter();
        Map attrs = list.getAttributes();
        if (!list.isMenu()) {
            out.write("<table cellspacing='1' cellpadding='0'");
            ModeListRenderer.outputAttribute(out, attrs.get("styleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("style"), "style");
            ModeListRenderer.outputAttribute(out, attrs.get("width"), "width");
            out.write(62);
            if (list.isHorizontal()) {
                out.write("<tr>");
            }
            if (list.getLabel() != null) {
                if (!list.isHorizontal()) {
                    out.write("<tr>");
                }
                out.write("<td><table cellpadding='0' style='width:100%;'");
                ModeListRenderer.outputAttribute(out, attrs.get("itemSpacing"), "cellspacing");
                out.write("><tr>");
                if (list.getIconColumnWidth() != 0) {
                    out.write("<td style='width:");
                    out.write(String.valueOf(list.getIconColumnWidth()));
                    out.write("px'></td>");
                }
                out.write("<td><span");
                ModeListRenderer.outputAttribute(out, attrs.get("labelStyle"), "style");
                ModeListRenderer.outputAttribute(out, attrs.get("labelStyleClass"), "class");
                out.write(62);
                out.write(Utils.encode((String)list.getLabel()));
                out.write("</span></td></tr></table></td>");
                if (!list.isHorizontal()) {
                    out.write("</tr>");
                }
            }
        } else {
            out.write("<table cellspacing='0' cellpadding='0' style='white-space:nowrap'><tr>");
            String selectedImage = (String)attrs.get("selectedImage");
            if (selectedImage != null) {
                out.write("<td style='padding-right:4px'>");
                out.write(Utils.buildImageTag(context, selectedImage, null, "middle"));
                out.write("</td>");
            }
            String menuId = UIMenu.getNextMenuId((UIComponent)list, context);
            out.write("<td style='white-space: nowrap;'><a href='#' onclick=\"javascript:_toggleMenu(event, '");
            out.write(menuId);
            out.write("');return false;\">");
            String label = list.getLabel();
            if (label == null || label.length() == 0) {
                block0: for (UIComponent child : list.getChildren()) {
                    UIListItem item;
                    if (child instanceof UIListItems) {
                        Object listItems = ((UIListItems)child).getValue();
                        if (!(listItems instanceof Collection)) continue;
                        for (UIListItem item2 : (Collection)listItems) {
                            if (!item2.getValue().equals(list.getValue())) continue;
                            label = item2.getLabel();
                            continue block0;
                        }
                        continue;
                    }
                    if (!(child instanceof UIListItem) || !child.isRendered() || !(item = (UIListItem)child).getValue().equals(list.getValue())) continue;
                    label = item.getLabel();
                    break;
                }
            }
            if (label != null && label.length() != 0) {
                out.write("<span");
                ModeListRenderer.outputAttribute(out, attrs.get("labelStyle"), "style");
                ModeListRenderer.outputAttribute(out, attrs.get("labelStyleClass"), "class");
                out.write(62);
                out.write(Utils.encode((String)label));
                out.write("</span>&nbsp;");
            }
            if (list.getMenuImage() != null) {
                out.write(Utils.buildImageTag(context, list.getMenuImage(), null, "-4px"));
            }
            out.write("</a></td></tr></table>");
            out.write("<div id='");
            out.write(menuId);
            out.write("' style='position:absolute;display:none;padding-left:2px;'>");
            out.write("<table cellspacing='1' cellpadding='0'");
            ModeListRenderer.outputAttribute(out, attrs.get("styleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("style"), "style");
            ModeListRenderer.outputAttribute(out, attrs.get("width"), "width");
            out.write(62);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        UIModeList list = (UIModeList)component;
        ResponseWriter out = context.getResponseWriter();
        for (UIComponent child : list.getChildren()) {
            if (child instanceof UIListItems) {
                Object listItems = ((UIListItems)child).getValue();
                if (!(listItems instanceof Collection)) continue;
                for (UIListItem item : (Collection)listItems) {
                    if (!item.isRendered()) continue;
                    this.renderItem(context, out, list, item);
                }
                continue;
            }
            if (!(child instanceof UIListItem) || !child.isRendered()) continue;
            this.renderItem(context, out, list, (UIListItem)child);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        UIModeList list = (UIModeList)component;
        if (list.isHorizontal()) {
            out.write("</tr>");
        }
        out.write("</table>");
        if (list.isMenu()) {
            out.write("</div>");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderItem(FacesContext context, ResponseWriter out, UIModeList list, UIListItem item) throws IOException {
        Map attrs = list.getAttributes();
        String selectedImage = (String)attrs.get("selectedImage");
        if (!list.isHorizontal()) {
            out.write("<tr>");
        }
        out.write("<td><table cellpadding='0' style='width:100%;'");
        ModeListRenderer.outputAttribute(out, attrs.get("itemSpacing"), "cellspacing");
        boolean selected = item.getValue().equals(list.getValue());
        if (selected) {
            ModeListRenderer.outputAttribute(out, attrs.get("selectedStyleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("selectedStyle"), "style");
        } else {
            ModeListRenderer.outputAttribute(out, attrs.get("itemStyleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("itemStyle"), "style");
        }
        out.write("><tr>");
        if (list.getIconColumnWidth() != 0) {
            out.write("<td style='width:");
            out.write(String.valueOf(list.getIconColumnWidth()));
            out.write("px'>");
            if (selected && selectedImage != null) {
                out.write(Utils.buildImageTag(context, selectedImage, item.getTooltip()));
            } else {
                String image = item.getImage();
                if (image != null) {
                    out.write(Utils.buildImageTag(context, image, item.getTooltip()));
                }
            }
            out.write("</td>");
        }
        out.write("<td style='white-space: nowrap;'>");
        if (!list.isDisabled() && !item.isDisabled()) {
            out.write("<a href='#' onclick=\"");
            String value = list.getClientId(context) + ':' + (String)item.getAttributes().get("value");
            out.write(Utils.generateFormSubmit(context, (UIComponent)list, ModeListRenderer.getHiddenFieldName(context, (UIComponent)list), value));
            out.write(34);
        } else {
            out.write("<span");
            ModeListRenderer.outputAttribute(out, attrs.get("disabledStyleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("disabledStyle"), "style");
        }
        if (item.getValue().equals(list.getValue())) {
            ModeListRenderer.outputAttribute(out, attrs.get("selectedLinkStyleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("selectedLinkStyle"), "style");
        } else {
            ModeListRenderer.outputAttribute(out, attrs.get("itemLinkStyleClass"), "class");
            ModeListRenderer.outputAttribute(out, attrs.get("itemLinkStyle"), "style");
        }
        ModeListRenderer.outputAttribute(out, item.getAttributes().get("tooltip"), "title");
        out.write(62);
        out.write(Utils.encode((String)item.getLabel()));
        if (!list.isDisabled() && !item.isDisabled()) {
            out.write("</a>");
        } else {
            out.write("</span>");
        }
        out.write("</td></tr></table></td>");
        if (!list.isHorizontal()) {
            out.write("</tr>");
        }
    }

    private static String getHiddenFieldName(FacesContext context, UIComponent component) {
        UIForm form = Utils.getParentForm(context, component);
        return form.getClientId(context) + ':' + "modelist";
    }
}

