/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.data.UIColumn;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.alfresco.web.ui.common.renderer.data.IRichListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RichListRenderer
extends BaseRenderer {
    private static Log logger = LogFactory.getLog(RichListRenderer.class);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            ResponseWriter out = context.getResponseWriter();
            Map attrs = component.getAttributes();
            out.write("<table cellspacing=0 cellpadding=0");
            RichListRenderer.outputAttribute(out, attrs.get("styleClass"), "class");
            RichListRenderer.outputAttribute(out, attrs.get("style"), "style");
            RichListRenderer.outputAttribute(out, attrs.get("width"), "width");
            out.write(">");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            UIRichList richList = (UIRichList)component;
            richList.bind();
            ArrayList<UIColumn> columnList = new ArrayList<UIColumn>(8);
            for (UIComponent child : richList.getChildren()) {
                if (!(child instanceof UIColumn)) continue;
                columnList.add((UIColumn)child);
            }
            UIColumn[] columns = new UIColumn[columnList.size()];
            columnList.toArray(columns);
            IRichListRenderer renderer = richList.getViewRenderer();
            if (renderer == null) {
                throw new IllegalStateException("IRichListRenderer must be available in UIRichList!");
            }
            ResponseWriter out = context.getResponseWriter();
            out.write("<thead>");
            renderer.renderListBefore(context, richList, columns);
            out.write("</thead>");
            out.write("<tbody>");
            if (richList.isDataAvailable()) {
                while (richList.isDataAvailable()) {
                    renderer.renderListRow(context, richList, columns, richList.nextRow());
                }
            } else {
                UIComponent emptyComponent = richList.getEmptyMessage();
                if (emptyComponent != null) {
                    emptyComponent.encodeBegin(context);
                    emptyComponent.encodeChildren(context);
                    emptyComponent.encodeEnd(context);
                }
            }
            renderer.renderListAfter(context, richList, columns);
            out.write("</tbody>");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            ResponseWriter out = context.getResponseWriter();
            out.write("</table>");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static class IconViewRenderer
    implements IRichListRenderer {
        private static final long serialVersionUID = -1961880941305536121L;
        private static final int COLUMNS = 3;
        private static final String COLUMN_PERCENT = Integer.toString(33) + "%";
        private static final int MAX_DISPLAYABLE_LINES = 3;
        private static final String END_ROW_SEPARATOR = "</tr><tr><td colspan=10><div style='padding:3px'></div></td></tr>";
        public static final String VIEWMODEID = "icons";
        private int rowIndex = 0;

        @Override
        public String getViewModeID() {
            return VIEWMODEID;
        }

        @Override
        public void renderListBefore(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            this.rowIndex = 0;
        }

        @Override
        public void renderListRow(FacesContext context, UIRichList richList, UIColumn[] columns, Object row) throws IOException {
            UIColumn column;
            int i;
            ResponseWriter out = context.getResponseWriter();
            if (this.rowIndex % 3 == 0) {
                out.write("<tr");
                RichListRenderer.outputAttribute(out, richList.getAttributes().get("rowStyleClass"), "class");
                out.write(62);
            }
            UIColumn primaryColumn = null;
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i].isRendered() || !columns[i].getPrimary()) continue;
                primaryColumn = columns[i];
                break;
            }
            if (primaryColumn == null) {
                logger.warn((Object)("No primary column found for RichList definition: " + richList.getId()));
            }
            out.write("<td width=");
            out.write(COLUMN_PERCENT);
            out.write("><table cellspacing=0 cellpadding=2 border=0>");
            if (primaryColumn != null && (column = primaryColumn).isRendered()) {
                int rowspan = 0;
                for (UIColumn col : columns) {
                    if (!col.isRendered()) continue;
                    ++rowspan;
                }
                out.write("<tr><td rowspan=" + rowspan);
                RichListRenderer.outputAttribute(out, column.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("styleClass"), "class");
                out.write(62);
                UIComponent largeIcon = column.getLargeIcon();
                if (largeIcon != null) {
                    largeIcon.encodeBegin(context);
                    if (largeIcon.getRendersChildren()) {
                        largeIcon.encodeChildren(context);
                    }
                    largeIcon.encodeEnd(context);
                }
                out.write("</td>");
                out.write("<td");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("styleClass"), "class");
                out.write(62);
                if (column.getChildCount() != 0) {
                    Utils.encodeRecursive(context, (UIComponent)column);
                }
                out.write("</td></tr>");
            }
            for (i = 0; i < columns.length; ++i) {
                UIColumn column2 = columns[i];
                int count = 1;
                if (!column2.isRendered() || column2.getPrimary() || count >= 3 && !column2.getActions()) continue;
                out.write("<tr><td");
                RichListRenderer.outputAttribute(out, column2.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column2.getAttributes().get("styleClass"), "class");
                out.write(62);
                if (column2.getChildCount() != 0) {
                    Utils.encodeRecursive(context, (UIComponent)column2);
                }
                out.write("</td></tr>");
                ++count;
            }
            out.write("</table></td>");
            if (this.rowIndex % 3 == 2) {
                out.write(END_ROW_SEPARATOR);
            }
            ++this.rowIndex;
        }

        @Override
        public void renderListAfter(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            if ((this.rowIndex - 1) % 3 != 2) {
                out.write(END_ROW_SEPARATOR);
            }
            out.write("<tr><td colspan=99 align=center>");
            for (UIComponent child : richList.getChildren()) {
                if (child instanceof UIColumn) continue;
                Utils.encodeRecursive(context, child);
            }
            out.write("</td></tr>");
        }
    }

    public static class ListViewRenderer
    implements IRichListRenderer {
        private static final long serialVersionUID = -6468162313606829713L;
        private static final int MAX_DISPLAYABLE_LINES = 3;
        private static final String END_ROW_SEPARATOR = "</tr><tr><td colspan=10><div style='padding:3px'></div></td></tr>";
        private static final String COLUMN_SPACER = "<td><div style='padding-left:8px'></div></td>";
        public static final String VIEWMODEID = "list";
        private int rowIndex = 0;

        @Override
        public String getViewModeID() {
            return VIEWMODEID;
        }

        @Override
        public void renderListBefore(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            this.rowIndex = 0;
        }

        @Override
        public void renderListRow(FacesContext context, UIRichList richList, UIColumn[] columns, Object row) throws IOException {
            UIColumn column;
            int i;
            ResponseWriter out = context.getResponseWriter();
            String rowStyle = (String)richList.getAttributes().get("rowStyleClass");
            if ((this.rowIndex & 1) == 0) {
                out.write("<tr");
                RichListRenderer.outputAttribute(out, rowStyle, "class");
                out.write(62);
            }
            UIColumn primaryColumn = null;
            UIColumn actionsColumn = null;
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i].isRendered()) continue;
                if (columns[i].getPrimary()) {
                    primaryColumn = columns[i];
                    continue;
                }
                if (!columns[i].getActions()) continue;
                actionsColumn = columns[i];
            }
            if (primaryColumn == null) {
                logger.warn((Object)("No primary column found for RichList definition: " + richList.getId()));
            }
            out.write("<td width=50%><table cellspacing=0 cellpadding=2 border=0>");
            if (primaryColumn != null && (column = primaryColumn).isRendered()) {
                out.write("<tr><td rowspan=10");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("styleClass"), "class");
                out.write(62);
                UIComponent icon = column.getLargeIcon();
                if (icon != null) {
                    icon.encodeBegin(context);
                    if (icon.getRendersChildren()) {
                        icon.encodeChildren(context);
                    }
                    icon.encodeEnd(context);
                }
                out.write("</td>");
                out.write("<td width=100%");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("styleClass"), "class");
                out.write(62);
                if (column.getChildCount() != 0) {
                    Utils.encodeRecursive(context, (UIComponent)column);
                }
                out.write("</td>");
                if (actionsColumn != null) {
                    out.write("<td");
                    RichListRenderer.outputAttribute(out, actionsColumn.getAttributes().get("style"), "style");
                    RichListRenderer.outputAttribute(out, actionsColumn.getAttributes().get("styleClass"), "class");
                    out.write("><nobr>");
                    if (actionsColumn.getChildCount() != 0) {
                        Utils.encodeRecursive(context, (UIComponent)actionsColumn);
                    }
                    out.write("</nobr></td>");
                }
                out.write("</tr>");
            }
            for (i = 0; i < columns.length; ++i) {
                UIColumn column2 = columns[i];
                int count = 1;
                if (!column2.isRendered() || count >= 3 || column2.getActions() || column2.getPrimary()) continue;
                out.write("<tr valign=top");
                RichListRenderer.outputAttribute(out, rowStyle, "class");
                out.write("><td colspan=2");
                RichListRenderer.outputAttribute(out, column2.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column2.getAttributes().get("styleClass"), "class");
                out.write(62);
                if (column2.getChildCount() != 0) {
                    Utils.encodeRecursive(context, (UIComponent)column2);
                }
                out.write("</td></tr>");
                ++count;
            }
            out.write("</table></td>");
            if ((this.rowIndex & 1) == 1) {
                out.write(END_ROW_SEPARATOR);
            } else {
                out.write(COLUMN_SPACER);
            }
            ++this.rowIndex;
        }

        @Override
        public void renderListAfter(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            if ((this.rowIndex - 1 & 1) != 1) {
                out.write(END_ROW_SEPARATOR);
            }
            out.write("<tr><td colspan=99 align=center>");
            for (UIComponent child : richList.getChildren()) {
                if (child instanceof UIColumn) continue;
                Utils.encodeRecursive(context, child);
            }
            out.write("</td></tr>");
        }
    }

    public static class DetailsViewRenderer
    implements IRichListRenderer {
        private static final long serialVersionUID = -2753231623981676639L;
        public static final String VIEWMODEID = "details";
        public static final String STALE_CSS = "conflictItemsList";
        protected int rowIndex = 0;

        @Override
        public String getViewModeID() {
            return VIEWMODEID;
        }

        public String getRowStyle(FacesContext context, UIRichList richList, Object row) {
            String rowStyle = (String)richList.getAttributes().get("rowStyleClass");
            String altStyle = (String)richList.getAttributes().get("altRowStyleClass");
            if (altStyle != null && (this.rowIndex++ & 1) == 1) {
                rowStyle = altStyle;
            }
            return rowStyle;
        }

        @Override
        public void renderListBefore(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            out.write("<tr>");
            String headerClass = (String)richList.getAttributes().get("headerStyleClass");
            for (int i = 0; i < columns.length; ++i) {
                UIColumn column = columns[i];
                if (!column.isRendered()) continue;
                out.write("<th");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("width"), "width");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("style"), "style");
                String columnClass = (String)column.getAttributes().get("styleClass");
                RichListRenderer.outputAttribute(out, columnClass != null ? columnClass : headerClass, "class");
                out.write(62);
                UIComponent header = column.getHeader();
                if (header != null) {
                    header.encodeBegin(context);
                    if (header.getRendersChildren()) {
                        header.encodeChildren(context);
                    }
                    header.encodeEnd(context);
                }
                out.write("</th>");
            }
            out.write("</tr>");
            this.rowIndex = 0;
        }

        @Override
        public void renderListRow(FacesContext context, UIRichList richList, UIColumn[] columns, Object row) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            out.write("<tr");
            RichListRenderer.outputAttribute(out, this.getRowStyle(context, richList, row), "class");
            out.write(62);
            UIColumn actionsColumn = null;
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].isRendered() || !columns[i].getActions()) continue;
                actionsColumn = columns[i];
                break;
            }
            boolean renderedFirst = false;
            for (int i = 0; i < columns.length; ++i) {
                UIColumn column = columns[i];
                if (!column.isRendered()) continue;
                out.write("<td");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("style"), "style");
                RichListRenderer.outputAttribute(out, column.getAttributes().get("styleClass"), "class");
                out.write(62);
                if (!renderedFirst) {
                    UIComponent smallIcon = column.getSmallIcon();
                    if (smallIcon != null) {
                        smallIcon.encodeBegin(context);
                        if (smallIcon.getRendersChildren()) {
                            smallIcon.encodeChildren(context);
                        }
                        smallIcon.encodeEnd(context);
                        out.write("&nbsp;");
                    }
                    renderedFirst = true;
                }
                if (column.getChildCount() != 0) {
                    if (column == actionsColumn) {
                        out.write("<nobr>");
                    }
                    Utils.encodeRecursive(context, (UIComponent)column);
                    if (column == actionsColumn) {
                        out.write("</nobr>");
                    }
                }
                out.write("</td>");
            }
            out.write("</tr>");
        }

        @Override
        public void renderListAfter(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            out.write("<tr><td colspan=99 align=center>");
            for (UIComponent child : richList.getChildren()) {
                if (child instanceof UIColumn) continue;
                Utils.encodeRecursive(context, child);
            }
            out.write("</td></tr>");
        }
    }
}

