/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.webscripts.json.JSONWriter;
import org.springframework.web.jsf.FacesContextUtils;

public abstract class BaseAjaxItemPicker
extends UIInput {
    protected static final String MSG_GO_UP = "go_up";
    protected static final String MSG_OK = "ok";
    protected static final String MSG_CANCEL = "cancel";
    protected static final String ID_ID = "id";
    protected static final String ID_NAME = "name";
    protected static final String ID_ICON = "icon";
    protected static final String EMPTY = "empty";
    protected static final String FOLDER_IMAGE_PREFIX = "/images/icons/";
    protected String label = null;
    protected String initialSelectionId = null;
    protected Boolean disabled;
    protected Boolean singleSelect;
    protected String height = null;
    protected static int ACTION_DONE = 0;
    protected static int ACTION_CANCEL = 1;

    public BaseAjaxItemPicker() {
        this.setRendererType(null);
    }

    public abstract String getFamily();

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.label = (String)values[1];
        this.singleSelect = (Boolean)values[2];
        this.initialSelectionId = (String)values[3];
        this.disabled = (Boolean)values[4];
        this.height = (String)values[5];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.label, this.singleSelect, this.initialSelectionId, this.disabled, this.height};
        return values;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName());
        if (value != null) {
            if (value.equals(EMPTY)) {
                this.setSubmittedValue(new String(EMPTY));
            } else if (value.length() != 0) {
                if (this.getSingleSelect().booleanValue()) {
                    NodeRef ref = new NodeRef(value);
                    this.setSubmittedValue(ref);
                } else {
                    ArrayList<NodeRef> refs = new ArrayList<NodeRef>(5);
                    StringTokenizer t = new StringTokenizer(value, ",");
                    while (t.hasMoreTokens()) {
                        refs.add(new NodeRef(t.nextToken()));
                    }
                    this.setSubmittedValue(refs);
                }
            }
        }
    }

    public void encodeBegin(FacesContext fc) throws IOException {
        String requestProps;
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = fc.getResponseWriter();
        String formClientId = Utils.getParentForm(fc, (UIComponent)this).getClientId(fc);
        Map attrs = this.getAttributes();
        ResourceBundle msg = Application.getBundle(fc);
        String selectedValues = null;
        String selectedNames = null;
        String selectedItems = null;
        ArrayList<NodeRef> submitted = null;
        if (this.getSingleSelect().booleanValue()) {
            NodeRef ref = (NodeRef)this.getSubmittedValue();
            if (ref == null) {
                Object objRef = this.getValue();
                if (objRef instanceof String) {
                    ref = new NodeRef((String)objRef);
                } else if (objRef instanceof NodeRef) {
                    ref = (NodeRef)objRef;
                }
            }
            if (ref != null) {
                submitted = new ArrayList<NodeRef>(1);
                submitted.add(ref);
            }
        } else {
            Object value = this.getSubmittedValue();
            if (value == null) {
                value = this.getValue();
            }
            if (value instanceof List) {
                submitted = (ArrayList<NodeRef>)value;
            } else if (value instanceof String && !value.equals(EMPTY)) {
                submitted = new ArrayList(1);
                submitted.add(new NodeRef(value.toString()));
            }
        }
        if (submitted != null) {
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(fc, true);
                tx.begin();
                StringBuilder nameBuf = new StringBuilder(128);
                StringBuilder valueBuf = new StringBuilder(128);
                StringBuilder itemBuf = new StringBuilder(256);
                NodeService nodeService = (NodeService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc).getBean("nodeService");
                for (NodeRef value : submitted) {
                    String name = (String)((Object)nodeService.getProperty(value, ContentModel.PROP_NAME));
                    String icon = (String)((Object)nodeService.getProperty(value, ApplicationModel.PROP_ICON));
                    if (nameBuf.length() != 0) {
                        nameBuf.append(", ");
                        valueBuf.append(",");
                        itemBuf.append(",");
                    }
                    nameBuf.append(name);
                    valueBuf.append(value.toString());
                    itemBuf.append(this.getItemJson(value.toString(), name, icon));
                }
                selectedNames = nameBuf.toString();
                selectedValues = valueBuf.toString();
                selectedItems = "[" + itemBuf.toString() + "]";
                tx.commit();
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
        String divId = this.getId();
        String objId = divId + "Obj";
        String contextPath = fc.getExternalContext().getRequestContextPath();
        out.write("<script type='text/javascript'>");
        out.write("function init" + divId + "() {");
        out.write(" window." + objId + " = new AlfPicker('" + divId + "','" + objId + "','" + this.getServiceCall() + "','" + formClientId + "'," + this.getSingleSelect() + ");");
        if (this.getInitialSelection() != null) {
            out.write(" window." + objId + ".setStartId('" + this.getInitialSelection() + "');");
        }
        if (this.getDefaultIcon() != null) {
            out.write(" window." + objId + ".setDefaultIcon('" + this.getDefaultIcon() + "');");
        }
        if (!this.getSingleSelect().booleanValue() && selectedItems != null) {
            out.write(" window." + objId + ".setSelectedItems('" + selectedItems + "');");
        }
        if ((requestProps = this.getRequestAttributes()) != null) {
            out.write(" window." + objId + ".setRequestAttributes('" + requestProps + "');");
        }
        out.write("}");
        out.write("window.addEvent('domready', init" + divId + ");");
        out.write("</script>");
        out.write("<div id='" + divId + "' class='picker'>");
        out.write(" <input id='" + this.getHiddenFieldName() + "' name='" + this.getHiddenFieldName() + "' type='hidden' value='");
        if (selectedValues != null) {
            out.write(selectedValues);
        }
        out.write("'>");
        out.write(" <div id='" + divId + "-noitems'");
        if (attrs.get("style") != null) {
            out.write(" style=\"");
            out.write((String)attrs.get("style"));
            out.write(34);
        }
        if (attrs.get("styleClass") != null) {
            out.write(" class=");
            out.write((String)attrs.get("styleClass"));
        }
        out.write(">");
        out.write("  <span class='pickerActionButton'><a href='javascript:" + objId + ".showSelector();'>");
        if (selectedNames == null) {
            out.write(this.getLabel());
        } else {
            out.write(selectedNames);
        }
        out.write("</a></span>");
        out.write(" </div>");
        out.write(" <div id='" + divId + "-selector' class='pickerSelector'>");
        out.write("  <div class='pickerResults'>");
        out.write("   <div class='pickerResultsHeader'>");
        out.write("    <div class='pickerNavControls'>");
        out.write("     <span class='pickerNavUp'>");
        out.write("      <a id='" + divId + "-nav-up' href='#'><img src='");
        out.write(contextPath);
        out.write("/images/icons/arrow_up.gif' border='0' alt='");
        out.write(msg.getString(MSG_GO_UP));
        out.write("' title='");
        out.write(msg.getString(MSG_GO_UP));
        out.write("'></a>");
        out.write("     </span>");
        out.write("     <span class='pickerNavBreadcrumb'>");
        out.write("      <div id='" + divId + "-nav-bread' class='pickerNavBreadcrumbPanel'></div>");
        out.write("      <a href='javascript:" + objId + ".breadcrumbToggle();'><span id='" + divId + "-nav-txt'></span><img border='0' src='");
        out.write(contextPath);
        out.write("/images/icons/arrow_open.gif'></a>");
        out.write("     </span>");
        out.write("     <span id='" + divId + "-nav-add'></span>");
        out.write("    </div>");
        out.write("   </div>");
        out.write("   <div>");
        out.write("    <div id='" + divId + "-ajax-wait' class='pickerAjaxWait'");
        String height = this.getHeight();
        if (height != null) {
            out.write(" style='height:" + height + "'");
        }
        out.write("></div>");
        out.write("    <div id='" + divId + "-results-list' class='pickerResultsList'");
        if (height != null) {
            out.write(" style='height:" + height + "'");
        }
        out.write("></div>");
        out.write("   </div>");
        out.write("  </div>");
        out.write("  <div class='pickerFinishControls'>");
        out.write("   <div id='" + divId + "-finish' style='float:left' class='pickerButtons'><a href='javascript:" + objId + ".doneClicked();'>");
        out.write(msg.getString(MSG_OK));
        out.write("</a></div>");
        out.write("   <div style='float:right' class='pickerButtons'><a href='javascript:" + objId + ".cancelClicked();'>");
        out.write(msg.getString(MSG_CANCEL));
        out.write("</a></div>");
        out.write("  </div>");
        out.write(" </div>");
        out.write(" <div id='" + divId + "-selected' class='pickerSelectedItems'></div>");
        out.write("</div>");
    }

    protected abstract String getServiceCall();

    protected abstract String getDefaultIcon();

    protected String getRequestAttributes() {
        return null;
    }

    public String getLabel() {
        ValueBinding vb = this.getValueBinding("label");
        this.label = vb != null ? (String)vb.getValue(this.getFacesContext()) : "";
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getInitialSelection() {
        ValueBinding vb = this.getValueBinding("initialSelection");
        if (vb != null) {
            Object objSelection = vb.getValue(this.getFacesContext());
            this.initialSelectionId = objSelection instanceof NodeRef ? ((NodeRef)objSelection).toString() : (String)objSelection;
        }
        return this.initialSelectionId;
    }

    public void setInitialSelection(String initialSelection) {
        this.initialSelectionId = initialSelection;
    }

    public boolean isDisabled() {
        ValueBinding vb;
        if (this.disabled == null && (vb = this.getValueBinding("disabled")) != null) {
            this.disabled = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.disabled == null ? Boolean.FALSE : this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Boolean getSingleSelect() {
        ValueBinding vb;
        if (this.singleSelect == null && (vb = this.getValueBinding("singleSelect")) != null) {
            this.singleSelect = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.singleSelect == null ? Boolean.TRUE : this.singleSelect;
    }

    public void setSingleSelect(Boolean singleSelect) {
        this.singleSelect = singleSelect;
    }

    public String getHeight() {
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null) {
            this.height = (String)vb.getValue(this.getFacesContext());
        }
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    protected String getHiddenFieldName() {
        return this.getId() + "-value";
    }

    protected String getItemJson(String id, String name, String icon) {
        String itemJson = "";
        StringWriter item = new StringWriter(128);
        JSONWriter json = new JSONWriter((Writer)item);
        try {
            json.startObject();
            json.writeValue(ID_ID, id);
            json.writeValue(ID_NAME, name);
            json.writeValue(ID_ICON, icon != null ? FOLDER_IMAGE_PREFIX + icon + "-16.gif" : this.getDefaultIcon());
            json.endObject();
        }
        catch (Throwable err) {
            // empty catch block
        }
        itemJson = item.toString();
        return itemJson;
    }
}

