/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class UICharsetSelector
extends UISelectOne {
    public static final String COMPONENT_TYPE = "org.alfresco.faces.CharsetSelector";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectOne";
    private static List<SelectItem> charsetEncodings = null;

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getChildren().size() == 0) {
            UISelectItems items = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
            items.setId(this.getId() + "_items");
            items.setValue(this.createList());
            this.getChildren().add(items);
        }
        super.encodeBegin(context);
    }

    protected List<SelectItem> createList() {
        return UICharsetSelector.getCharsetEncodingList();
    }

    public static List<SelectItem> getCharsetEncodingList() {
        if (charsetEncodings == null) {
            SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
            ArrayList<SelectItem> items = new ArrayList<SelectItem>(availableCharsets.size());
            for (Charset charset : availableCharsets.values()) {
                SelectItem item = new SelectItem((Object)charset.name(), charset.displayName());
                items.add(item);
            }
            charsetEncodings = items;
        }
        return charsetEncodings;
    }
}

