/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.QuickSort;

public class UIMimeTypeSelector
extends UISelectOne {
    public static final String COMPONENT_TYPE = "org.alfresco.faces.MimeTypeSelector";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectOne";

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getChildren().size() == 0) {
            UISelectItems items = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
            items.setId(this.getId() + "_items");
            items.setValue(this.createList());
            this.getChildren().add(items);
        }
        super.encodeBegin(context);
    }

    protected List<SelectItem> createList() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(80);
        ServiceRegistry registry = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
        MimetypeService mimetypeService = registry.getMimetypeService();
        Map mimeTypes = mimetypeService.getDisplaysByMimetype();
        for (String mimeType : mimeTypes.keySet()) {
            items.add(new SelectItem((Object)mimeType, (String)mimeTypes.get(mimeType)));
        }
        QuickSort sorter = new QuickSort(items, "label", true, "case-insensitive");
        sorter.sort();
        return items;
    }
}

