/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.transaction.UserTransaction;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.ajax.NavigatorPluginBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UITree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UINavigator
extends SelfRenderingComponent {
    public static final String COMPONENT_TYPE = "org.alfresco.faces.Navigator";
    protected String activeArea;
    private static final Log logger = LogFactory.getLog(UINavigator.class);
    private static final String AJAX_URL_START = "/ajax/invoke/NavigatorPluginBean";
    private static final String PANEL_ACTION = "panel:";
    private static final int PANEL_SELECTED = 1;
    private static final int NODE_SELECTED = 2;

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.activeArea = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.activeArea};
        return values;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getClientId(context));
        if (value != null && value.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received post back: " + value));
            }
            int mode = 2;
            String item = value;
            if (value.startsWith(PANEL_ACTION)) {
                mode = 1;
                item = value.substring(PANEL_ACTION.length());
            }
            NavigatorEvent event = new NavigatorEvent((UIComponent)this, mode, item);
            this.queueEvent((FacesEvent)event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof NavigatorEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            NavigatorEvent navEvent = (NavigatorEvent)event;
            switch (navEvent.getMode()) {
                case 1: {
                    String panelSelected = navEvent.getItem();
                    NavigationBean nb = (NavigationBean)FacesHelper.getManagedBean(context, "NavigationBean");
                    if (nb == null) return;
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Selecting panel: " + panelSelected));
                        }
                        nb.processToolbarLocation(panelSelected, true);
                        return;
                    }
                    catch (InvalidNodeRefException refErr) {
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_homespace"), Application.getCurrentUser(context).getHomeSpaceId()), refErr);
                        return;
                    }
                    catch (Exception err) {
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                    }
                    return;
                }
                case 2: {
                    boolean nodeExists = true;
                    NodeRef nodeClicked = new NodeRef(navEvent.getItem());
                    UserTransaction tx = null;
                    try {
                        tx = Repository.getUserTransaction(context, true);
                        tx.begin();
                        NodeService nodeSvc = Repository.getServiceRegistry(context).getNodeService();
                        nodeExists = nodeSvc.exists(nodeClicked);
                        tx.commit();
                    }
                    catch (Throwable err) {
                        try {
                            if (tx != null) {
                                tx.rollback();
                            }
                        }
                        catch (Exception tex) {
                            // empty catch block
                        }
                    }
                    if (nodeExists) {
                        BrowseBean bb = (BrowseBean)FacesHelper.getManagedBean(context, "BrowseBean");
                        if (bb == null) return;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Selected node: " + nodeClicked));
                        }
                        bb.clickSpace(nodeClicked);
                        return;
                    }
                    String msg = Application.getMessage(context, "navigator_node_deleted");
                    Utils.addErrorMessage(msg);
                    return;
                }
            }
            return;
        }
        super.broadcast(event);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        NavigationBean navBean = (NavigationBean)FacesHelper.getManagedBean(context, "NavigationBean");
        NavigatorPluginBean navPluginBean = (NavigatorPluginBean)FacesHelper.getManagedBean(context, "NavigatorPluginBean");
        List<UITree.TreeNode> rootNodesForArea = null;
        String area = this.getActiveArea();
        String areaTitle = null;
        boolean treePanel = true;
        if ("companyhome".equals(area)) {
            rootNodesForArea = navPluginBean.getCompanyHomeRootNodes();
            areaTitle = Application.getMessage(context, "company_home");
        } else if ("userhome".equals(area)) {
            rootNodesForArea = navPluginBean.getMyHomeRootNodes();
            areaTitle = Application.getMessage(context, "my_home");
        } else if ("guesthome".equals(area)) {
            rootNodesForArea = navPluginBean.getGuestHomeRootNodes();
            areaTitle = Application.getMessage(context, "guest_home");
        } else {
            treePanel = false;
            areaTitle = Application.getMessage(context, "my_alfresco");
        }
        if (rootNodesForArea != null && rootNodesForArea.size() > 1) {
            QuickSort sorter = new QuickSort(rootNodesForArea, "name", true, "case-insensitive");
            sorter.sort();
        }
        out.write("<div id=\"navigator\" class=\"navigator\">");
        String cxPath = context.getExternalContext().getRequestContextPath();
        out.write("<div class=\"sidebarButtonSelected\" style=\"background-image: url(" + cxPath + "/images/parts/navigator_blue_gradient_bg.gif)\">");
        out.write("<a class='sidebarButtonSelectedLink' onclick=\"");
        out.write(Utils.generateFormSubmit(context, (UIComponent)this, this.getClientId(context), PANEL_ACTION + area));
        out.write("\" href=\"#\">");
        out.write(Utils.encode((String)areaTitle));
        out.write("</a></div>");
        if (treePanel) {
            out.write("<script type=\"text/javascript\">");
            out.write("function treeNodeSelected(nodeRef) {");
            out.write(Utils.generateFormSubmit(context, (UIComponent)this, this.getClientId(context), "nodeRef", true, null));
            out.write("}</script>");
            out.write("<div class=\"navigatorPanelBody\">");
            UITree tree = (UITree)context.getApplication().createComponent("org.alfresco.faces.Tree");
            tree.setId("tree");
            tree.setRootNodes(rootNodesForArea);
            tree.setRetrieveChildrenUrl("/ajax/invoke/NavigatorPluginBean.retrieveChildren?area=" + area);
            tree.setNodeCollapsedUrl("/ajax/invoke/NavigatorPluginBean.nodeCollapsed?area=" + area);
            tree.setNodeSelectedCallback("treeNodeSelected");
            tree.setNodeCollapsedCallback("informOfCollapse");
            Utils.encodeRecursive(context, (UIComponent)tree);
            out.write("</div>");
        }
        String sideBarStyle = "style=\"background-image: url(" + cxPath + "/images/parts/navigator_grey_gradient_bg.gif)\"";
        if (!"companyhome".equals(area) && navBean.getCompanyHomeVisible()) {
            this.encodeSidebarButton(context, out, sideBarStyle, "companyhome", "company_home");
        }
        if (!"userhome".equals(area)) {
            this.encodeSidebarButton(context, out, sideBarStyle, "userhome", "my_home");
        }
        if (!"guesthome".equals(area) && !navBean.getIsGuest() && navBean.getGuestHomeVisible()) {
            this.encodeSidebarButton(context, out, sideBarStyle, "guesthome", "guest_home");
        }
        if (!"myalfresco".equals(area)) {
            this.encodeSidebarButton(context, out, sideBarStyle, "myalfresco", "my_alfresco");
        }
        out.write("</div>");
    }

    private void encodeSidebarButton(FacesContext context, ResponseWriter out, String sideBarStyle, String location, String labelId) throws IOException {
        out.write("<div class=\"sidebarButton\" ");
        out.write(sideBarStyle);
        out.write("><a class='sidebarButtonLink' onclick=\"");
        out.write(Utils.generateFormSubmit(context, (UIComponent)this, this.getClientId(context), PANEL_ACTION + location));
        out.write("\" href=\"#\">");
        out.write(Application.getMessage(context, labelId));
        out.write("</a></div>");
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent child : this.getChildren()) {
            Utils.encodeRecursive(context, child);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getActiveArea() {
        ValueBinding vb = this.getValueBinding("activeArea");
        if (vb != null) {
            this.activeArea = (String)vb.getValue(this.getFacesContext());
        }
        if (this.activeArea == null) {
            this.activeArea = "userhome";
        }
        return this.activeArea;
    }

    public void setActiveArea(String activeArea) {
        this.activeArea = activeArea;
    }

    public static class NavigatorEvent
    extends ActionEvent {
        private int mode;
        private String item;

        public NavigatorEvent(UIComponent component, int mode, String item) {
            super(component);
            this.mode = mode;
            this.item = item;
        }

        public String getItem() {
            return this.item;
        }

        public int getMode() {
            return this.mode;
        }
    }
}

