/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.DataDictionary;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.config.AdvancedSearchConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UICategorySelector;
import org.alfresco.web.ui.repo.component.UISpaceSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UISearchCustomProperties
extends SelfRenderingComponent
implements NamingContainer {
    public static final String PREFIX_DATE_TO = "to_";
    public static final String PREFIX_DATE_FROM = "from_";
    public static final String PREFIX_LOV_ITEM = "item_";
    private static final String VALUE = "value";
    private static final String MSG_TO = "to";
    private static final String MSG_FROM = "from";
    private static Log logger = LogFactory.getLog(UISearchCustomProperties.class);
    private DataDictionary dataDictionary;

    public String getFamily() {
        return "org.alfresco.faces.AdvancedSearch";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        if (this.getChildCount() == 0) {
            this.createComponentsFromConfig(context);
        }
        out.write("<table cellspacing=2 cellpadding=2 border=0");
        UISearchCustomProperties.outputAttribute((ResponseWriter)out, this.getAttributes().get("styleClass"), (String)"class");
        UISearchCustomProperties.outputAttribute((ResponseWriter)out, this.getAttributes().get("style"), (String)"style");
        out.write(62);
        List children = this.getChildren();
        int colCounter = 0;
        for (int i = 0; i < children.size(); ++i) {
            UIComponent component = (UIComponent)children.get(i);
            if (component instanceof UIPanel) {
                out.write("<tr><td colspan=3>");
                Utils.encodeRecursive(context, component);
                out.write("</td></tr>");
                colCounter += 3;
                continue;
            }
            if (colCounter % 3 == 0) {
                out.write("<tr>");
            }
            out.write("<td>");
            Utils.encodeRecursive(context, component);
            out.write("</td>");
            if (colCounter % 3 == 2) {
                out.write("</tr>");
            }
            ++colCounter;
        }
        out.write("</table>");
    }

    private void createComponentsFromConfig(FacesContext context) {
        DictionaryService dd = Repository.getServiceRegistry(context).getDictionaryService();
        AdvancedSearchConfigElement config = (AdvancedSearchConfigElement)org.alfresco.web.app.Application.getConfigService(context).getConfig((Object)"Advanced Search").getConfigElement("advanced-search");
        String beanBinding = (String)this.getAttributes().get("bean") + '.' + (String)this.getAttributes().get("var");
        List<AdvancedSearchConfigElement.CustomProperty> props = config.getCustomProperties();
        if (props != null) {
            for (AdvancedSearchConfigElement.CustomProperty property : props) {
                try {
                    PropertyDefinition propDef = null;
                    if (property.Type != null) {
                        QName type = Repository.resolveToQName(property.Type);
                        TypeDefinition typeDef = dd.getType(type);
                        if (typeDef == null) {
                            logger.warn((Object)("No Type Definition found for: " + property.Type + " - Was an Aspect expected?"));
                            continue;
                        }
                        propDef = (PropertyDefinition)typeDef.getProperties().get(Repository.resolveToQName(property.Property));
                    } else if (property.Aspect != null) {
                        QName aspect = Repository.resolveToQName(property.Aspect);
                        AspectDefinition aspectDef = dd.getAspect(aspect);
                        if (aspectDef == null) {
                            logger.warn((Object)("No Aspect Definition found for: " + property.Aspect + " - Was a Type expected?"));
                            continue;
                        }
                        propDef = (PropertyDefinition)aspectDef.getProperties().get(Repository.resolveToQName(property.Property));
                    }
                    if (propDef == null) continue;
                    String label = property.LabelId != null && property.LabelId.length() != 0 ? org.alfresco.web.app.Application.getMessage(context, property.LabelId) : (propDef.getTitle() != null ? propDef.getTitle() : propDef.getName().getLocalName());
                    DataTypeDefinition dataTypeDef = propDef.getDataType();
                    if (DataTypeDefinition.DATE.equals((Object)dataTypeDef.getName()) || DataTypeDefinition.DATETIME.equals((Object)dataTypeDef.getName())) {
                        this.getChildren().add(this.generateControl(context, propDef, label, beanBinding));
                        continue;
                    }
                    ListOfValuesConstraint constraint = this.getListOfValuesConstraint(propDef);
                    if (constraint != null && propDef != null && !propDef.isProtected()) {
                        this.getChildren().add(this.generateCheck(context, propDef, beanBinding));
                        this.getChildren().add(this.generateLabel(context, label + ": "));
                    } else {
                        this.getChildren().add(this.generateLabel(context, ""));
                        this.getChildren().add(this.generateLabel(context, label + ": "));
                    }
                    this.getChildren().add(this.generateControl(context, propDef, null, beanBinding));
                }
                catch (DictionaryException ddErr) {
                    logger.warn((Object)("Error building custom properties for Advanced Search: " + ddErr.getMessage()));
                }
            }
        }
    }

    private UIComponent generateCheck(FacesContext context, PropertyDefinition propDef, String beanBinding) {
        UIInput checkbox = (UIInput)context.getApplication().createComponent("javax.faces.SelectBoolean");
        checkbox.setRendererType("javax.faces.Checkbox");
        checkbox.setId(context.getViewRoot().createUniqueId());
        ValueBinding vbCheckbox = context.getApplication().createValueBinding("#{" + beanBinding + "[\"" + propDef.getName().toString() + "\"]}");
        checkbox.setValueBinding(VALUE, vbCheckbox);
        return checkbox;
    }

    private UIComponent generateLabel(FacesContext context, String displayLabel) {
        UIOutput label = (UIOutput)context.getApplication().createComponent("javax.faces.Output");
        label.setId(context.getViewRoot().createUniqueId());
        label.setRendererType("javax.faces.Text");
        label.setValue((Object)displayLabel);
        return label;
    }

    private UIComponent generateControl(FacesContext context, PropertyDefinition propDef, String displayLabel, String beanBinding) {
        Object control = null;
        DataTypeDefinition dataTypeDef = propDef.getDataType();
        QName typeName = dataTypeDef.getName();
        Application facesApp = context.getApplication();
        ValueBinding vb = facesApp.createValueBinding("#{" + beanBinding + "[\"" + propDef.getName().toString() + "\"]}");
        if (typeName.equals((Object)DataTypeDefinition.BOOLEAN)) {
            control = (UISelectBoolean)facesApp.createComponent("javax.faces.SelectBoolean");
            control.setRendererType("javax.faces.Checkbox");
            control.setValueBinding(VALUE, vb);
        } else if (typeName.equals((Object)DataTypeDefinition.CATEGORY)) {
            control = (UICategorySelector)facesApp.createComponent("org.alfresco.faces.TagSelector");
            control.setValueBinding(VALUE, vb);
        } else if (typeName.equals((Object)DataTypeDefinition.DATETIME) || typeName.equals((Object)DataTypeDefinition.DATE)) {
            Boolean showTime = typeName.equals((Object)DataTypeDefinition.DATETIME);
            ValueBinding startYearBind = null;
            ValueBinding yearCountBind = null;
            if (showTime.booleanValue()) {
                startYearBind = facesApp.createValueBinding("#{DateTimePickerGenerator.startYear}");
                yearCountBind = facesApp.createValueBinding("#{DateTimePickerGenerator.yearCount}");
            } else {
                startYearBind = facesApp.createValueBinding("#{DatePickerGenerator.startYear}");
                yearCountBind = facesApp.createValueBinding("#{DatePickerGenerator.yearCount}");
            }
            control = (UIPanel)facesApp.createComponent("javax.faces.Panel");
            control.setRendererType("javax.faces.Grid");
            control.getAttributes().put("columns", 2);
            UIInput checkbox = (UIInput)facesApp.createComponent("javax.faces.SelectBoolean");
            checkbox.setRendererType("javax.faces.Checkbox");
            checkbox.setId(context.getViewRoot().createUniqueId());
            ValueBinding vbCheckbox = facesApp.createValueBinding("#{" + beanBinding + "[\"" + propDef.getName().toString() + "\"]}");
            checkbox.setValueBinding(VALUE, vbCheckbox);
            control.getChildren().add(checkbox);
            UIOutput label = (UIOutput)context.getApplication().createComponent("javax.faces.Output");
            label.setId(context.getViewRoot().createUniqueId());
            label.setRendererType("javax.faces.Text");
            label.setValue((Object)(displayLabel + ":"));
            control.getChildren().add(label);
            UIOutput labelFromDate = (UIOutput)context.getApplication().createComponent("javax.faces.Output");
            labelFromDate.setId(context.getViewRoot().createUniqueId());
            labelFromDate.setRendererType("javax.faces.Text");
            labelFromDate.setValue((Object)org.alfresco.web.app.Application.getMessage(context, MSG_FROM));
            control.getChildren().add(labelFromDate);
            UIInput inputFromDate = (UIInput)facesApp.createComponent("javax.faces.Input");
            inputFromDate.setId(context.getViewRoot().createUniqueId());
            inputFromDate.setRendererType("org.alfresco.faces.DatePickerRenderer");
            inputFromDate.setValueBinding("startYear", startYearBind);
            inputFromDate.setValueBinding("yearCount", yearCountBind);
            inputFromDate.getAttributes().put("initialiseIfNull", Boolean.TRUE);
            inputFromDate.getAttributes().put("showTime", showTime);
            ValueBinding vbFromDate = facesApp.createValueBinding("#{" + beanBinding + "[\"" + PREFIX_DATE_FROM + propDef.getName().toString() + "\"]}");
            inputFromDate.setValueBinding(VALUE, vbFromDate);
            control.getChildren().add(inputFromDate);
            UIOutput labelToDate = (UIOutput)context.getApplication().createComponent("javax.faces.Output");
            labelToDate.setId(context.getViewRoot().createUniqueId());
            labelToDate.setRendererType("javax.faces.Text");
            labelToDate.setValue((Object)org.alfresco.web.app.Application.getMessage(context, MSG_TO));
            control.getChildren().add(labelToDate);
            UIInput inputToDate = (UIInput)facesApp.createComponent("javax.faces.Input");
            inputToDate.setId(context.getViewRoot().createUniqueId());
            inputToDate.setRendererType("org.alfresco.faces.DatePickerRenderer");
            inputToDate.setValueBinding("startYear", startYearBind);
            inputToDate.setValueBinding("yearCount", yearCountBind);
            inputToDate.getAttributes().put("initialiseIfNull", Boolean.TRUE);
            inputToDate.getAttributes().put("showTime", showTime);
            ValueBinding vbToDate = facesApp.createValueBinding("#{" + beanBinding + "[\"" + PREFIX_DATE_TO + propDef.getName().toString() + "\"]}");
            inputToDate.setValueBinding(VALUE, vbToDate);
            control.getChildren().add(inputToDate);
        } else if (typeName.equals((Object)DataTypeDefinition.NODE_REF)) {
            control = (UISpaceSelector)facesApp.createComponent("org.alfresco.faces.SpaceSelector");
            control.setValueBinding(VALUE, vb);
        } else {
            ListOfValuesConstraint constraint = this.getListOfValuesConstraint(propDef);
            if (constraint != null && propDef != null && !propDef.isProtected()) {
                control = (UISelectOne)facesApp.createComponent("javax.faces.SelectOne");
                UISelectItems itemsComponent = (UISelectItems)facesApp.createComponent("javax.faces.SelectItems");
                ArrayList<SelectItem> items = new ArrayList<SelectItem>();
                List values = constraint.getAllowedValues();
                for (String value : values) {
                    items.add(new SelectItem((Object)value, value));
                }
                itemsComponent.setValue(items);
                control.getChildren().add(itemsComponent);
                ValueBinding vbItemList = facesApp.createValueBinding("#{" + beanBinding + "[\"" + PREFIX_LOV_ITEM + propDef.getName().toString() + "\"]}");
                control.setValueBinding(VALUE, vbItemList);
            } else {
                control = (UIInput)facesApp.createComponent("javax.faces.Input");
                control.setRendererType("javax.faces.Text");
                control.setValueBinding("size", facesApp.createValueBinding("#{TextFieldGenerator.size}"));
                control.setValueBinding("maxlength", facesApp.createValueBinding("#{TextFieldGenerator.maxLength}"));
                control.setValueBinding(VALUE, vb);
            }
        }
        control.setId(context.getViewRoot().createUniqueId());
        return control;
    }

    protected ListOfValuesConstraint getListOfValuesConstraint(PropertyDefinition propertyDef) {
        ListOfValuesConstraint lovConstraint = null;
        if (propertyDef != null) {
            List constraints = propertyDef.getConstraints();
            for (ConstraintDefinition constraintDef : constraints) {
                Constraint constraint = constraintDef.getConstraint();
                if (!(constraint instanceof ListOfValuesConstraint)) continue;
                lovConstraint = (ListOfValuesConstraint)constraint;
                break;
            }
        }
        return lovConstraint;
    }
}

