/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.repo.component.AbstractItemSelector;

public class UISpaceSelector
extends AbstractItemSelector {
    @Override
    public String getFamily() {
        return "org.alfresco.faces.SpaceSelector";
    }

    @Override
    public String getDefaultLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "select_space_prompt");
    }

    @Override
    public String getParentNodeId(FacesContext context) {
        String id = null;
        if (this.navigationId != null && !this.navigationId.equals(Application.getCompanyRootId(context))) {
            try {
                ChildAssociationRef parentRef = UISpaceSelector.getFastNodeService(context).getPrimaryParent(new NodeRef(Repository.getStoreRef(), this.navigationId));
                id = parentRef.getParentRef().getId();
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        return id;
    }

    @Override
    public Collection<NodeRef> getChildrenForNode(FacesContext context) {
        NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), this.navigationId);
        List allKids = UISpaceSelector.getNodeService(context).getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        DictionaryService dd = UISpaceSelector.getDictionaryService(context);
        NodeService service = UISpaceSelector.getFastNodeService(context);
        ArrayList<NodeRef> spaceKids = new ArrayList<NodeRef>();
        for (ChildAssociationRef ref : allKids) {
            if (!dd.isSubClass(service.getType(ref.getChildRef()), ContentModel.TYPE_FOLDER) || dd.isSubClass(service.getType(ref.getChildRef()), ContentModel.TYPE_SYSTEM_FOLDER)) continue;
            spaceKids.add(ref.getChildRef());
        }
        return spaceKids;
    }

    @Override
    public Collection<NodeRef> getRootChildren(FacesContext context) {
        NodeRef rootRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(context));
        PermissionService ps = Repository.getServiceRegistry(context).getPermissionService();
        if (ps.hasPermission(rootRef, "Read") != AccessStatus.ALLOWED) {
            String homeId = Application.getCurrentUser(context).getHomeSpaceId();
            rootRef = new NodeRef(Repository.getStoreRef(), homeId);
        }
        ArrayList<NodeRef> roots = new ArrayList<NodeRef>(1);
        roots.add(rootRef);
        return roots;
    }

    @Override
    public String getItemIcon(FacesContext context, NodeRef ref) {
        String icon = (String)((Object)UISpaceSelector.getFastNodeService(context).getProperty(ref, ApplicationModel.PROP_ICON));
        icon = icon != null ? "/images/icons/" + icon + "-16.gif" : "/images/icons/space_small.gif";
        return icon;
    }
}

