/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.alfresco.web.ui.common.Utils;

public class UITree
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.alfresco.faces.Tree";
    public static final String DEFAULT_RENDERER = "org.alfresco.faces.Yahoo";
    protected List<TreeNode> rootNodes = null;
    protected String retrieveChildrenUrl;
    protected String nodeCollapsedUrl;
    protected String nodeExpandedCallback;
    protected String nodeCollapsedCallback;
    protected String nodeSelectedCallback;

    public UITree() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.rootNodes = (List)values[1];
        this.retrieveChildrenUrl = (String)values[2];
        this.nodeCollapsedUrl = (String)values[3];
        this.nodeExpandedCallback = (String)values[4];
        this.nodeCollapsedCallback = (String)values[5];
        this.nodeSelectedCallback = (String)values[6];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.rootNodes, this.retrieveChildrenUrl, this.nodeCollapsedUrl, this.nodeExpandedCallback, this.nodeCollapsedCallback, this.nodeSelectedCallback};
        return values;
    }

    public List<TreeNode> getRootNodes() {
        ValueBinding vb = this.getValueBinding("rootNodes");
        if (vb != null) {
            this.rootNodes = (List)vb.getValue(this.getFacesContext());
        }
        return this.rootNodes;
    }

    public void setRootNodes(List<TreeNode> rootNodes) {
        this.rootNodes = rootNodes;
    }

    public String getNodeCollapsedCallback() {
        ValueBinding vb = this.getValueBinding("nodeCollapsedCallback");
        if (vb != null) {
            this.nodeCollapsedCallback = (String)vb.getValue(this.getFacesContext());
        }
        return this.nodeCollapsedCallback;
    }

    public void setNodeCollapsedCallback(String nodeCollapsedCallback) {
        this.nodeCollapsedCallback = nodeCollapsedCallback;
    }

    public String getNodeExpandedCallback() {
        ValueBinding vb = this.getValueBinding("nodeExpandedCallback");
        if (vb != null) {
            this.nodeExpandedCallback = (String)vb.getValue(this.getFacesContext());
        }
        return this.nodeExpandedCallback;
    }

    public void setNodeExpandedCallback(String nodeExpandedCallback) {
        this.nodeExpandedCallback = nodeExpandedCallback;
    }

    public String getNodeSelectedCallback() {
        ValueBinding vb = this.getValueBinding("nodeSelectedCallback");
        if (vb != null) {
            this.nodeSelectedCallback = (String)vb.getValue(this.getFacesContext());
        }
        return this.nodeSelectedCallback;
    }

    public void setNodeSelectedCallback(String nodeSelectedCallback) {
        this.nodeSelectedCallback = nodeSelectedCallback;
    }

    public String getRetrieveChildrenUrl() {
        ValueBinding vb = this.getValueBinding("retrieveChildrenUrl");
        if (vb != null) {
            this.retrieveChildrenUrl = (String)vb.getValue(this.getFacesContext());
        }
        return this.retrieveChildrenUrl;
    }

    public void setRetrieveChildrenUrl(String retrieveChildrenUrl) {
        this.retrieveChildrenUrl = retrieveChildrenUrl;
    }

    public String getNodeCollapsedUrl() {
        ValueBinding vb = this.getValueBinding("nodeCollapsedUrl");
        if (vb != null) {
            this.nodeCollapsedUrl = (String)vb.getValue(this.getFacesContext());
        }
        return this.nodeCollapsedUrl;
    }

    public void setNodeCollapsedUrl(String nodeCollapsedUrl) {
        this.nodeCollapsedUrl = nodeCollapsedUrl;
    }

    public static class TreeNode
    implements Serializable {
        private static final long serialVersionUID = 8820468648920825139L;
        private String nodeRef;
        private String name;
        private String icon;
        private boolean leafNode = false;
        private boolean expanded = false;
        private boolean selected = false;
        private TreeNode parent;
        private List<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String nodeRef, String name, String icon) {
            this.nodeRef = nodeRef;
            this.name = name;
            this.icon = icon;
            if (this.icon == null || this.icon.length() == 0) {
                this.icon = "space-icon-default";
            }
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public boolean isLeafNode() {
            return this.leafNode;
        }

        public void setLeafNode(boolean leafNode) {
            this.leafNode = leafNode;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNodeRef() {
            return this.nodeRef;
        }

        public void setNodeRef(String nodeRef) {
            this.nodeRef = nodeRef;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void addChild(TreeNode child) {
            child.setParent(this);
            this.children.add(child);
        }

        public void removeChildren() {
            this.children = new ArrayList<TreeNode>();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (nodeRef=").append(this.nodeRef);
            buffer.append(", name=").append(this.name);
            buffer.append(", icon=").append(this.icon);
            buffer.append(", expanded=").append(this.expanded);
            buffer.append(", selected=").append(this.selected);
            if (this.parent != null) {
                buffer.append(", parent=").append(this.parent.getNodeRef());
            } else {
                buffer.append(", parent=null");
            }
            buffer.append(", leafNode=").append(this.leafNode).append(")");
            return buffer.toString();
        }

        public String toXML() {
            StringBuilder xml = new StringBuilder();
            xml.append("<node ref=\"");
            xml.append(this.nodeRef);
            xml.append("\" name=\"");
            xml.append(Utils.encode((String)this.name));
            xml.append("\" icon=\"");
            xml.append(this.icon);
            xml.append("\"/>");
            return xml.toString();
        }
    }
}

