/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIWorkflowHistory
extends SelfRenderingComponent {
    protected WorkflowInstance value = null;
    private static final Log logger = LogFactory.getLog(UIWorkflowHistory.class);
    private static final String MSG_DESCRIPTION = "description";
    private static final String MSG_TASK = "task_type";
    private static final String MSG_ID = "id";
    private static final String MSG_CREATED = "created";
    private static final String MSG_ASSIGNEE = "assignee";
    private static final String MSG_COMMENT = "comment";
    private static final String MSG_DATE_COMPLETED = "completed_on";
    private static final String MSG_OUTCOME = "outcome";
    private static final String MSG_NO_HISTORY = "no_workflow_history";

    public String getFamily() {
        return "org.alfresco.faces.WorkflowHistory";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (WorkflowInstance)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.value};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        WorkflowInstance wi = this.getValue();
        if (wi != null) {
            ResponseWriter out = context.getResponseWriter();
            ResourceBundle bundle = Application.getBundle(context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving workflow history for workflow instance: " + wi));
            }
            WorkflowTaskQuery query = new WorkflowTaskQuery();
            query.setActive(null);
            query.setProcessId(wi.id);
            query.setTaskState(WorkflowTaskState.COMPLETED);
            query.setOrderBy(new WorkflowTaskQuery.OrderBy[]{WorkflowTaskQuery.OrderBy.TaskCreated_Desc, WorkflowTaskQuery.OrderBy.TaskActor_Asc});
            List tasks = Repository.getServiceRegistry(context).getWorkflowService().queryTasks(query);
            if (tasks.size() == 0) {
                out.write("<div style='margin-left:18px;margin-top: 6px;'>");
                out.write(bundle.getString(MSG_NO_HISTORY));
                out.write("</div>");
            } else {
                out.write("<table cellspacing='2' cellpadding='1' border='0'");
                if (this.getAttributes().get("style") != null) {
                    out.write(" style=\"");
                    out.write((String)this.getAttributes().get("style"));
                    out.write("\"");
                }
                if (this.getAttributes().get("styleClass") != null) {
                    out.write(" class=\"");
                    out.write((String)this.getAttributes().get("styleClass"));
                    out.write("\"");
                }
                out.write(">");
                out.write("<tr align=left><th>");
                out.write(bundle.getString(MSG_DESCRIPTION));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_TASK));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_ID));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_CREATED));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_ASSIGNEE));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_COMMENT));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_DATE_COMPLETED));
                out.write("</th><th>");
                out.write(bundle.getString(MSG_OUTCOME));
                out.write("</th></tr>");
                for (WorkflowTask task : tasks) {
                    String id = null;
                    Serializable idObject = (Serializable)task.properties.get(WorkflowModel.PROP_TASK_ID);
                    id = idObject instanceof Long ? ((Long)idObject).toString() : idObject.toString();
                    String desc = (String)task.properties.get(WorkflowModel.PROP_DESCRIPTION);
                    Date createdDate = (Date)task.properties.get(ContentModel.PROP_CREATED);
                    String owner = (String)task.properties.get(ContentModel.PROP_OWNER);
                    String comment = (String)task.properties.get(WorkflowModel.PROP_COMMENT);
                    Date completedDate = (Date)task.properties.get(WorkflowModel.PROP_COMPLETION_DATE);
                    String transition = (String)task.properties.get(WorkflowModel.PROP_OUTCOME);
                    String outcome = "";
                    if (transition != null) {
                        WorkflowTransition[] transitions;
                        for (WorkflowTransition trans : transitions = task.definition.node.transitions) {
                            if (!trans.id.equals(transition)) continue;
                            outcome = trans.title;
                            break;
                        }
                    }
                    if ((outcome == null || outcome.equals("")) && transition != null) {
                        outcome = transition;
                    }
                    out.write("<tr><td>");
                    out.write(desc == null ? "" : Utils.encode((String)desc));
                    out.write("</td><td>");
                    out.write(Utils.encode((String)task.title));
                    out.write("</td><td>");
                    out.write(id);
                    out.write("</td><td>");
                    out.write(Utils.getDateTimeFormat(context).format(createdDate));
                    out.write("</td><td>");
                    out.write(owner == null ? "" : owner);
                    out.write("</td><td>");
                    out.write(comment == null ? "" : Utils.encode((String)comment));
                    out.write("</td><td>");
                    out.write(Utils.getDateTimeFormat(context).format(completedDate));
                    out.write("</td><td>");
                    out.write(outcome);
                    out.write("</td></tr>");
                }
                out.write("</table>");
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
    }

    public boolean getRendersChildren() {
        return false;
    }

    public WorkflowInstance getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = (WorkflowInstance)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(WorkflowInstance value) {
        this.value = value;
    }
}

