/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIWorkflowSummary
extends SelfRenderingComponent {
    protected WorkflowInstance value = null;

    public String getFamily() {
        return "org.alfresco.faces.WorkflowSummary";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (WorkflowInstance)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[8];
        values[0] = super.saveState(context);
        values[1] = this.value;
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        WorkflowInstance wi = this.getValue();
        if (wi != null) {
            ResponseWriter out = context.getResponseWriter();
            ResourceBundle bundle = Application.getBundle(context);
            out.write("<table");
            if (this.getAttributes().get("style") != null) {
                out.write(" style=\"");
                out.write((String)this.getAttributes().get("style"));
                out.write("\"");
            }
            if (this.getAttributes().get("styleClass") != null) {
                out.write(" class=\"");
                out.write((String)this.getAttributes().get("styleClass"));
                out.write("\"");
            }
            out.write(">");
            out.write("<tr><td>");
            out.write(bundle.getString("title"));
            out.write(":</td><td>");
            out.write(wi.definition.title);
            if (wi.definition.description != null && wi.definition.description.length() > 0) {
                out.write("&nbsp;(");
                out.write(Utils.encode((String)wi.definition.description));
                out.write(")");
            }
            out.write("</td></tr><tr><td>");
            out.write(bundle.getString("initiated_by"));
            out.write(":</td><td>");
            NodeService nodeService = this.getNodeService(context);
            if (wi.initiator != null) {
                if (nodeService.exists(wi.initiator)) {
                    out.write(Utils.encode((String)User.getFullName(Repository.getServiceRegistry(context).getNodeService(), wi.initiator)));
                } else {
                    out.write("&lt;");
                    out.write(bundle.getString("unknown"));
                    out.write("&gt;");
                }
            }
            out.write("</td></tr><tr><td>");
            out.write(bundle.getString("started_on"));
            out.write(":</td><td>");
            if (wi.startDate != null) {
                out.write(Utils.getDateFormat(context).format(wi.startDate));
            }
            out.write("</td></tr><tr><td>");
            out.write(bundle.getString("completed_on"));
            out.write(":</td><td>");
            if (wi.endDate != null) {
                out.write(Utils.getDateFormat(context).format(wi.endDate));
            } else {
                out.write("&lt;");
                out.write(bundle.getString("in_progress"));
                out.write("&gt;");
            }
            out.write("</td></tr></table>");
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
    }

    public boolean getRendersChildren() {
        return false;
    }

    public WorkflowInstance getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = (WorkflowInstance)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(WorkflowInstance value) {
        this.value = value;
    }

    private NodeService getNodeService(FacesContext fc) {
        return Repository.getServiceRegistry(fc).getNodeService();
    }
}

