/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.evaluator;

import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.component.evaluator.BaseEvaluator;

public class PermissionEvaluator
extends BaseEvaluator {
    private String deny = null;
    private String allow = null;

    @Override
    public boolean evaluate() {
        boolean result = false;
        try {
            Object obj = this.getValue();
            if (obj instanceof Node) {
                String[] allow = this.getAllowPermissions();
                if (allow.length != 0) {
                    result = true;
                    for (int i = 0; i < allow.length; ++i) {
                        result &= ((Node)obj).hasPermission(allow[i]);
                    }
                }
            } else if (obj instanceof NodeRef) {
                PermissionService service = Repository.getServiceRegistry(this.getFacesContext()).getPermissionService();
                String[] allow = this.getAllowPermissions();
                if (allow.length != 0) {
                    result = true;
                    for (int i = 0; i < allow.length; ++i) {
                        result &= AccessStatus.ALLOWED == service.hasPermission((NodeRef)obj, allow[i]);
                    }
                }
            }
        }
        catch (Exception err) {
            s_logger.debug((Object)("Error during PermissionEvaluator evaluation: " + err.getMessage()));
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.allow = (String)values[1];
        this.deny = (String)values[2];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.allow, this.deny};
        return values;
    }

    private String[] getAllowPermissions() {
        String[] allowPermissions;
        String allow = this.getAllow();
        if (allow != null) {
            if (allow.indexOf(44) == -1) {
                allowPermissions = new String[]{allow};
            } else {
                StringTokenizer t = new StringTokenizer(allow, ",");
                allowPermissions = new String[t.countTokens()];
                for (int i = 0; i < allowPermissions.length; ++i) {
                    allowPermissions[i] = t.nextToken();
                }
            }
        } else {
            allowPermissions = new String[]{};
        }
        return allowPermissions;
    }

    public String getAllow() {
        ValueBinding vb = this.getValueBinding("allow");
        if (vb != null) {
            this.allow = (String)vb.getValue(this.getFacesContext());
        }
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
    }

    public String getDeny() {
        ValueBinding vb = this.getValueBinding("deny");
        if (vb != null) {
            this.deny = (String)vb.getValue(this.getFacesContext());
        }
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
    }
}

