/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UISeparator
extends PropertySheetItem {
    public static final String COMPONENT_FAMILY = "org.alfresco.faces.Separator";
    private static Log logger = LogFactory.getLog(UISeparator.class);

    public UISeparator() {
        this.setRendererType("org.alfresco.faces.SeparatorRenderer");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    @Override
    protected String getIncorrectParentMsg() {
        return "The separator component must be nested within a property sheet component";
    }

    @Override
    protected void generateItem(FacesContext context, UIPropertySheet propSheet) throws IOException {
        String componentGeneratorName = this.getComponentGenerator();
        if (componentGeneratorName == null) {
            componentGeneratorName = "SeparatorGenerator";
        }
        UIComponent separator = FacesHelper.getComponentGenerator(context, componentGeneratorName).generateAndAdd(context, propSheet, this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created separator " + separator + "(" + separator.getClientId(context) + ") for '" + this.getName() + "' and added it to component " + (Object)((Object)this)));
        }
    }
}

