/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.shelf;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.clipboard.ClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardStatus;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.shelf.UIShelfItem;

public class UIClipboardShelfItem
extends UIShelfItem {
    private static final String MSG_REMOVE_ALL = "remove_all";
    private static final String MSG_PASTE_ALL = "paste_all";
    private static final String MSG_PASTE_ITEM = "paste_item";
    private static final String MSG_PASTE_LINK = "paste_link";
    private static final String MSG_REMOVE_ITEM = "remove_item";
    private static final String MSG_CUT = "cut";
    private static final String MSG_COPY = "copy";
    public static final int ACTION_REMOVE_ITEM = 0;
    public static final int ACTION_REMOVE_ALL = 1;
    public static final int ACTION_PASTE_ITEM = 2;
    public static final int ACTION_PASTE_ALL = 3;
    public static final int ACTION_PASTE_LINK = 4;
    private List<ClipboardItem> collections;
    private MethodBinding pasteActionListener;

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.collections = (List)values[1];
        this.pasteActionListener = (MethodBinding)UIClipboardShelfItem.restoreAttachedState((FacesContext)context, (Object)values[2]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.collections, UIClipboardShelfItem.saveAttachedState((FacesContext)context, (Object)this.pasteActionListener)};
        return values;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName());
        if (value != null && value.length() != 0) {
            int sepIndex = value.indexOf(58);
            int action = Integer.parseInt(value.substring(0, sepIndex));
            int index = Integer.parseInt(value.substring(sepIndex + 1));
            ClipboardEvent event = new ClipboardEvent((UIComponent)this, action, index);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ClipboardEvent) {
            ClipboardEvent clipEvent = (ClipboardEvent)event;
            List<ClipboardItem> items = this.getCollections();
            if (items.size() > clipEvent.Index) {
                switch (clipEvent.Action) {
                    case 1: {
                        items.clear();
                        break;
                    }
                    case 0: {
                        items.remove(clipEvent.Index);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Utils.processActionMethod(this.getFacesContext(), this.getPasteActionListener(), clipEvent);
                    }
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        List<ClipboardItem> items = this.getCollections();
        out.write("<table border=\"0\" cellspacing=\"3\" cellpadding=\"0\" width=\"100%\" valign=\"top\">");
        if (items.size() != 0) {
            DictionaryService dd = Repository.getServiceRegistry(context).getDictionaryService();
            NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
            ResourceBundle bundle = Application.getBundle(context);
            for (int i = 0; i < items.size(); ++i) {
                ClipboardItem item = items.get(i);
                if (!nodeService.exists(item.getNodeRef())) {
                    items.remove(i--);
                    continue;
                }
                out.write("<tr><td width=16>");
                if (item.getMode() == ClipboardStatus.COPY) {
                    out.write(Utils.buildImageTag(context, "/images/icons/copy.gif", 14, 16, bundle.getString(MSG_COPY), null, "absmiddle"));
                } else {
                    out.write(Utils.buildImageTag(context, "/images/icons/cut.gif", 13, 16, bundle.getString(MSG_CUT), null, "absmiddle"));
                }
                out.write("</td><td width=16>");
                boolean isFolder = dd.isSubClass(item.getType(), ContentModel.TYPE_FOLDER);
                if (isFolder) {
                    String icon = item.getIcon();
                    icon = icon != null ? "/images/icons/" + icon + "-16.gif" : "/images/icons/space_small.gif";
                    out.write(Utils.buildImageTag(context, icon, 16, 16, null, null, "absmiddle"));
                } else {
                    String image = FileTypeImageUtils.getFileTypeImage((String)item.getName(), (boolean)true);
                    out.write(Utils.buildImageTag(context, image, null, "absmiddle"));
                }
                out.write("</td><td width=100%><nobr>&nbsp;");
                if (isFolder) {
                    out.write(Utils.cropEncode((String)item.getName()));
                } else {
                    out.write("<a href='");
                    out.write(context.getExternalContext().getRequestContextPath());
                    out.write(this.generateBrowserURL(dd, nodeService, item));
                    out.write("' target='new'>");
                    out.write(Utils.cropEncode((String)item.getName()));
                    out.write("</a>");
                }
                out.write("</nobr></td><td align=right><nobr>");
                out.write(this.buildActionLink(0, i, bundle.getString(MSG_REMOVE_ITEM), "/images/icons/delete.gif"));
                out.write("&nbsp;");
                out.write(this.buildActionLink(2, i, bundle.getString(MSG_PASTE_ITEM), "/images/icons/paste.gif"));
                if (item.supportsLink() && item.getMode() == ClipboardStatus.COPY && !dd.isSubClass(item.getType(), ContentModel.TYPE_LINK)) {
                    out.write("&nbsp;");
                    out.write(this.buildActionLink(4, i, bundle.getString(MSG_PASTE_LINK), "/images/icons/paste_link.gif"));
                }
                out.write("</nobr></td></tr>");
            }
            out.write("<tr><td colspan=4 style='padding-top:3px' align='center'><nobr>");
            out.write(this.buildActionLink(3, -1, bundle.getString(MSG_PASTE_ALL), null));
            out.write("&nbsp;|&nbsp;");
            out.write(this.buildActionLink(1, -1, bundle.getString(MSG_REMOVE_ALL), null));
            out.write("</nobr></td><td></td></tr>");
        }
        out.write("</table>");
    }

    public void setCollections(List<ClipboardItem> collections) {
        this.collections = collections;
    }

    public List<ClipboardItem> getCollections() {
        ValueBinding vb = this.getValueBinding("collections");
        if (vb != null) {
            this.collections = (List)vb.getValue(this.getFacesContext());
        }
        return this.collections;
    }

    public void setPasteActionListener(MethodBinding binding) {
        this.pasteActionListener = binding;
    }

    public MethodBinding getPasteActionListener() {
        return this.pasteActionListener;
    }

    private String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    private static String encodeValues(int action, int index) {
        return Integer.toString(action) + ':' + Integer.toString(index);
    }

    private String buildActionLink(int action, int index, String text, String image) {
        FacesContext context = this.getFacesContext();
        StringBuilder buf = new StringBuilder(256);
        buf.append("<a href='#' onclick=\"");
        buf.append(Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), UIClipboardShelfItem.encodeValues(action, index)));
        buf.append("\">");
        if (image != null) {
            buf.append(Utils.buildImageTag(context, image, text));
        } else {
            buf.append(Utils.encode((String)text));
        }
        buf.append("</a>");
        return buf.toString();
    }

    private String generateBrowserURL(DictionaryService dd, NodeService nodeService, ClipboardItem item) {
        NodeRef destNodeRef;
        Node document = new Node(item.getNodeRef());
        if (dd.isSubClass(item.getType(), ContentModel.TYPE_LINK) && nodeService.exists(destNodeRef = (NodeRef)nodeService.getProperty(item.getNodeRef(), ContentModel.PROP_LINK_DESTINATION))) {
            document = new Node(destNodeRef);
        }
        return DownloadContentServlet.generateBrowserURL(document.getNodeRef(), document.getName());
    }

    public static class ClipboardEvent
    extends ActionEvent {
        public int Action;
        public int Index;

        public ClipboardEvent(UIComponent component, int action, int index) {
            super(component);
            this.Action = action;
            this.Index = index;
        }
    }
}

