/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.alfresco.web.app.Application;

public class LoadBundleTag
extends TagSupport {
    private static final long serialVersionUID = -7336055169875448199L;
    private String _var;

    public void setVar(String var) {
        this._var = var;
    }

    public int doStartTag() throws JspException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new JspException("No faces context?!");
        }
        try {
            ResourceBundle bundle = Application.getBundle(facesContext);
            facesContext.getExternalContext().getRequestMap().put(this._var, new BundleMap(bundle));
        }
        catch (IllegalStateException ex) {
            throw new JspException((Throwable)ex);
        }
        return 0;
    }

    private static class BundleMap
    implements Map {
        private ResourceBundle _bundle;
        private List _values;

        public BundleMap(ResourceBundle bundle) {
            this._bundle = bundle;
        }

        public Object get(Object key) {
            try {
                return this._bundle.getObject(key.toString());
            }
            catch (Exception e) {
                return "$$" + key + "$$";
            }
        }

        @Override
        public boolean isEmpty() {
            return !this._bundle.getKeys().hasMoreElements();
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                return this._bundle.getObject(key.toString()) != null;
            }
            catch (MissingResourceException e) {
                return false;
            }
        }

        public Collection values() {
            if (this._values == null) {
                this._values = new ArrayList();
                Enumeration<String> enumer = this._bundle.getKeys();
                while (enumer.hasMoreElements()) {
                    String v = this._bundle.getString(enumer.nextElement());
                    this._values.add(v);
                }
            }
            return this._values;
        }

        @Override
        public int size() {
            return this.values().size();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        public Set entrySet() {
            HashSet<1> set = new HashSet<1>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                final String k = enumer.nextElement();
                set.add(new Map.Entry(){

                    public Object getKey() {
                        return k;
                    }

                    public Object getValue() {
                        return BundleMap.this._bundle.getObject(k);
                    }

                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                    }
                });
            }
            return set;
        }

        public Set keySet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                set.add(enumer.nextElement());
            }
            return set;
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    }
}

