/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.repo.component.UILockIcon;

public class UIAVMLockIcon
extends UILockIcon {
    public static final String ALFRESCO_FACES_AVMLOCKICON = "org.alfresco.faces.AVMLockIcon";

    @Override
    public String getFamily() {
        return ALFRESCO_FACES_AVMLOCKICON;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        boolean locked = false;
        boolean lockedOwner = false;
        Object val = this.getValue();
        String lockUser = null;
        if (val != null) {
            String[] stringArray;
            if (val instanceof AssetInfo) {
                AssetInfo asset = (AssetInfo)val;
                locked = asset.isLocked();
                String assetLockOwner = asset.getLockOwner();
                if (assetLockOwner != null) {
                    lockUser = assetLockOwner;
                    lockedOwner = lockUser.equals(Application.getCurrentUser(context).getUserName());
                }
            } else {
                String avmPath;
                AVMLockingService avmLockingService = Repository.getServiceRegistry(context).getAVMLockingService();
                String string = val instanceof NodeRef ? (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)((NodeRef)val)).getSecond() : (avmPath = val instanceof String ? (String)val : null);
                if (avmPath != null) {
                    String[] pathParts = WCMUtil.splitPath((String)avmPath);
                    String lockOwner = null;
                    try {
                        lockOwner = avmLockingService.getLockOwner(WCMUtil.getWebProjectStoreId((String)pathParts[0]), pathParts[1]);
                    }
                    catch (AVMNotFoundException nfe) {
                        // empty catch block
                    }
                    if (lockOwner != null) {
                        locked = true;
                        lockUser = lockOwner;
                        lockedOwner = lockUser.equals(Application.getCurrentUser(context).getUserName());
                    }
                }
            }
            if (lockUser == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = lockUser;
            }
            this.encodeBegin(context, locked, lockedOwner, stringArray);
        }
    }
}

