/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.actions.AVMDeployWebsiteAction;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DeploymentMonitor;
import org.alfresco.web.bean.wcm.DeploymentServerConfig;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.wcm.component.DeploymentServerConfigComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.comparator.CompoundComparator;

public class UIDeployWebsite
extends UIInput {
    protected NodeRef webProjectRef;
    protected Integer snapshotVersion = -1;
    protected Boolean monitorDeployment;
    protected List<String> monitorIds;
    protected String deployMode;
    protected String store;
    private static Log logger = LogFactory.getLog(UIDeployWebsite.class);

    public UIDeployWebsite() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.DeployWebsite";
    }

    public void decode(FacesContext context) {
        super.decode(context);
        LinkedList<String> selectedNodes = new LinkedList<String>();
        Map valuesMap = context.getExternalContext().getRequestParameterValuesMap();
        this.addValues(selectedNodes, valuesMap, this.getClientId(context));
        Set keys = valuesMap.keySet();
        for (String key : keys) {
            if (!key.matches(this.getClientId(context) + ":group[\\d]+:child")) continue;
            this.addValues(selectedNodes, valuesMap, key);
        }
        String[] retVal = new String[selectedNodes.size()];
        System.arraycopy(selectedNodes.toArray(), 0, retVal, 0, selectedNodes.size());
        this.setSubmittedValue(retVal);
    }

    private void addValues(List<String> selectedNodes, Map<String, String[]> valuesMap, String key) {
        String[] values = valuesMap.get(key);
        if (values != null) {
            for (String value : values) {
                selectedNodes.add(value);
            }
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.webProjectRef = (NodeRef)values[1];
        this.monitorDeployment = (Boolean)values[2];
        this.monitorIds = (List)values[3];
        this.snapshotVersion = (Integer)values[4];
        this.deployMode = (String)values[5];
        this.store = (String)values[6];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.webProjectRef, this.monitorDeployment, this.monitorIds, this.snapshotVersion, this.deployMode, this.store};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            NodeRef webProject = this.getWebsite();
            if (webProject == null) {
                throw new IllegalArgumentException("The web project must be specified.");
            }
            NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
            out.write("<script type='text/javascript' src='");
            out.write(context.getExternalContext().getRequestContextPath());
            out.write("/scripts/select-all.js'></script>\n");
            out.write("\n<div style='padding-top:4px;'></div>\n");
            if (this.getMonitor()) {
                List<String> deployMonitorIds = this.getMonitorIds();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Monitoring deployment of: " + deployMonitorIds));
                }
                this.renderScript(context, out, deployMonitorIds);
                for (String id : deployMonitorIds) {
                    DeploymentMonitor monitor = (DeploymentMonitor)context.getExternalContext().getSessionMap().get(id);
                    if (monitor == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found deployment monitor: " + monitor));
                    }
                    this.renderMonitoredServer(context, out, nodeService, monitor.getTargetServer(), id);
                }
            } else if ("test".equals(this.getDeployMode())) {
                List<NodeRef> allocatedServers = DeploymentUtil.findAllocatedTestServers(this.getStore());
                if (!allocatedServers.isEmpty()) {
                    for (NodeRef allocatedServer : allocatedServers) {
                        this.renderAllocatedTestServer(context, out, nodeService, allocatedServer);
                    }
                } else {
                    List refs = Repository.getServiceRegistry(context).getDeploymentService().findTestDeploymentServers(webProject, true);
                    List<DeploymentServerConfig> servers = this.toSortedDeploymentServerConfig(nodeService, refs);
                    if (servers.size() > 0) {
                        ParentChildCheckboxHelper helper = new ParentChildCheckboxHelper(this.getClientId(context));
                        boolean selected = false;
                        for (DeploymentServerConfig server : servers) {
                            String displayGroup = (String)server.getProperties().get("group");
                            helper.setCurrentDisplayGroup(displayGroup);
                            if (helper.newGroup) {
                                out.write("<p class='mainSubTitle'>");
                                out.write("<input type='checkbox' id='");
                                out.write(helper.groupParentId);
                                out.write("' value='");
                                out.write(Utils.encode((String)displayGroup));
                                out.write("'");
                                out.write(" ");
                                out.write("onClick=\"select_all('");
                                out.write(helper.groupChildName);
                                out.write("', this.checked);\" ");
                                out.write(" /> ");
                                out.write(Utils.encode((String)displayGroup));
                                out.write("</p>");
                            }
                            if (helper.groupParentId.length() > 0) {
                                this.renderCheckableServer(context, out, nodeService, server.getServerRef(), selected, helper.groupChildName, helper.groupParentId);
                                continue;
                            }
                            this.renderCheckableServer(context, out, nodeService, server.getServerRef(), selected, this.getClientId(context));
                        }
                    } else {
                        out.write("<div class='deployServersInfo'><img src='");
                        out.write(context.getExternalContext().getRequestContextPath());
                        out.write("/images/icons/info_icon.gif' />&nbsp;");
                        out.write(Application.getMessage(context, "deploy_test_server_not_available"));
                        out.write("</div>\n");
                        out.write("<script type='text/javascript'>\n");
                        out.write("disableOKButton = function() { ");
                        out.write("document.getElementById('dialog:finish-button').disabled = true; }\n");
                        out.write("window.onload = disableOKButton;\n");
                        out.write("</script>\n");
                    }
                }
            } else {
                List refs = Repository.getServiceRegistry(context).getDeploymentService().findLiveDeploymentServers(webProject);
                List<DeploymentServerConfig> servers = this.toSortedDeploymentServerConfig(nodeService, refs);
                ParentChildCheckboxHelper helper = new ParentChildCheckboxHelper(this.getClientId(context));
                for (DeploymentServerConfig server : servers) {
                    boolean selected = true;
                    String displayGroup = (String)server.getProperties().get("group");
                    helper.setCurrentDisplayGroup(displayGroup);
                    if (helper.newGroup) {
                        out.write("<p class='mainSubTitle'>");
                        out.write("<input type='checkbox' id='");
                        out.write(helper.groupParentId);
                        out.write("' value='");
                        out.write(Utils.encode((String)displayGroup));
                        out.write("'");
                        out.write(" checked='checked' ");
                        out.write("onClick=\"select_all('");
                        out.write(helper.groupChildName);
                        out.write("', this.checked);\" ");
                        out.write(" /> ");
                        out.write(Utils.encode((String)displayGroup));
                        out.write("</p>");
                    }
                    if (helper.groupParentId.length() > 0) {
                        this.renderCheckableServer(context, out, nodeService, server.getServerRef(), selected, helper.groupChildName, helper.groupParentId);
                        continue;
                    }
                    this.renderCheckableServer(context, out, nodeService, server.getServerRef(), selected, this.getClientId(context));
                }
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            throw new RuntimeException(err);
        }
    }

    public NodeRef getWebsite() {
        ValueBinding vb = this.getValueBinding("website");
        if (vb != null) {
            this.webProjectRef = (NodeRef)vb.getValue(this.getFacesContext());
        }
        return this.webProjectRef;
    }

    public void setWebsite(NodeRef value) {
        this.webProjectRef = value;
    }

    public boolean getMonitor() {
        ValueBinding vb = this.getValueBinding("monitor");
        if (vb != null) {
            this.monitorDeployment = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.monitorDeployment == null) {
            this.monitorDeployment = Boolean.FALSE;
        }
        return this.monitorDeployment;
    }

    public void setMonitor(boolean monitor) {
        this.monitorDeployment = new Boolean(monitor);
    }

    public List<String> getMonitorIds() {
        ValueBinding vb = this.getValueBinding("monitorIds");
        if (vb != null) {
            this.monitorIds = (List)vb.getValue(this.getFacesContext());
        }
        return this.monitorIds;
    }

    public void setMonitorIds(List<String> monitorIds) {
        this.monitorIds = monitorIds;
    }

    public int getSnapshotVersion() {
        ValueBinding vb = this.getValueBinding("snapshotVersion");
        if (vb != null) {
            this.snapshotVersion = (Integer)vb.getValue(this.getFacesContext());
        }
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(int snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public String getDeployMode() {
        ValueBinding vb = this.getValueBinding("deployMode");
        if (vb != null) {
            this.deployMode = (String)vb.getValue(this.getFacesContext());
        }
        if (this.deployMode == null || this.deployMode.length() == 0) {
            this.deployMode = "test";
        }
        return this.deployMode;
    }

    public void setDeployMode(String deployMode) {
        this.deployMode = deployMode;
    }

    public String getStore() {
        ValueBinding vb = this.getValueBinding("store");
        if (vb != null) {
            this.store = (String)vb.getValue(this.getFacesContext());
        }
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    private void renderScript(FacesContext context, ResponseWriter out, List<String> monitorIds) throws IOException {
        StringBuilder ids = new StringBuilder();
        for (int x = 0; x < monitorIds.size(); ++x) {
            if (x > 0) {
                ids.append(",");
            }
            String id = monitorIds.get(x);
            ids.append(id);
        }
        int pollFreq = AVMUtil.getRemoteDeploymentPollingFrequency() * 1000;
        out.write("<script type='text/javascript' src='");
        out.write(context.getExternalContext().getRequestContextPath());
        out.write("/scripts/ajax/deployment.js'></script>\n");
        out.write("<script type='text/javascript'>\n");
        out.write("Alfresco.initDeploymentMonitor = function() {\n");
        out.write("   Alfresco.monitor = new Alfresco.DeploymentMonitor('");
        out.write(ids.toString());
        out.write("', ");
        out.write(Integer.toString(pollFreq));
        out.write(", '");
        out.write(Application.getMessage(context, "deploy_failed"));
        out.write("', '");
        out.write(Application.getMessage(context, "deploy_successful"));
        out.write("');\n");
        out.write("   Alfresco.monitor.retrieveDeploymentStatus();\n");
        out.write("}\n");
        out.write("Alfresco.monitor = null;\n");
        out.write("window.onload = Alfresco.initDeploymentMonitor;\n");
        out.write("</script>\n");
    }

    private void renderCheckableServer(FacesContext context, ResponseWriter out, NodeService nodeService, NodeRef server, boolean selected, String checkBoxName) throws IOException {
        this.renderCheckableServer(context, out, nodeService, server, selected, checkBoxName, "");
    }

    private void renderCheckableServer(FacesContext context, ResponseWriter out, NodeService nodeService, NodeRef server, boolean selected, String checkBoxName, String parentId) throws IOException {
        String contextPath = context.getExternalContext().getRequestContextPath();
        this.renderPanelStart(out, contextPath);
        out.write("<div class='deployPanelControl'>");
        out.write("<input type='checkbox' ");
        if (checkBoxName != null && checkBoxName.length() > 0) {
            out.write("name='");
            out.write(checkBoxName);
            out.write("' ");
            if (parentId != null && parentId.length() > 0) {
                out.write("onClick=\"select_one('");
                out.write(parentId);
                out.write("', '");
                out.write(checkBoxName);
                out.write("');\" ");
            }
        }
        out.write("value='");
        out.write(server.toString());
        out.write("'");
        if (selected) {
            out.write(" checked='checked'");
        }
        out.write(" /></div>");
        this.renderPanelMiddle(out, contextPath, nodeService, server, true);
        this.renderPanelEnd(out, contextPath);
    }

    private void renderAllocatedTestServer(FacesContext context, ResponseWriter out, NodeService nodeService, NodeRef server) throws IOException {
        String contextPath = context.getExternalContext().getRequestContextPath();
        this.renderPanelStart(out, contextPath);
        this.renderPanelMiddle(out, contextPath, nodeService, server, false);
        String url = (String)((Object)nodeService.getProperty(server, WCMAppModel.PROP_DEPLOYSERVERURL));
        if (url != null && url.length() > 0) {
            out.write("<div class='deployServersUrl'><a target='new' href='");
            out.write(url);
            out.write("'>");
            out.write(Utils.encode((String)url));
            out.write("</a></div>");
        }
        this.renderPanelEnd(out, contextPath);
        out.write("<input type='hidden' name='");
        out.write(this.getClientId(context));
        out.write("' value='");
        out.write(server.toString());
        out.write("' />");
    }

    private void renderMonitoredServer(FacesContext context, ResponseWriter out, NodeService nodeService, NodeRef server, String monitorId) throws IOException {
        String contextPath = context.getExternalContext().getRequestContextPath();
        this.renderPanelStart(out, contextPath);
        out.write("<div class='deployPanelStatusIcon'>");
        out.write("<img id='");
        out.write(monitorId);
        out.write("_icon' src='");
        out.write(contextPath);
        out.write("/images/icons/ajax_anim.gif' />");
        out.write("</div>");
        this.renderPanelMiddle(out, contextPath, nodeService, server, true);
        out.write("<div class='deployPanelServerStatus' id='");
        out.write(monitorId);
        out.write("_status'>");
        out.write(Application.getMessage(context, "deploying"));
        out.write("</div>");
        out.write("<div class='deployPanelServerMsg' id='");
        out.write(monitorId);
        out.write("_msg'>");
        out.write("</div>");
        this.renderPanelEnd(out, contextPath);
    }

    private void renderPanelStart(ResponseWriter out, String contextPath) throws IOException {
        out.write("<table cellspacing='0' cellpadding='0' border='0' width='100%'>");
        out.write("<tr><td width='10'><img src='");
        out.write(contextPath);
        out.write("/images/parts/deploy_panel_start.gif' /></td>");
        out.write("<td style='background-image: url(");
        out.write(contextPath);
        out.write("/images/parts/deploy_panel_bg.gif); background-repeat: repeat-x;'>");
    }

    private void renderPanelMiddle(ResponseWriter out, String contextPath, NodeService nodeService, NodeRef server, boolean showSeparator) throws IOException {
        Map props = nodeService.getProperties(server);
        String deployType = (String)props.get(WCMAppModel.PROP_DEPLOYTYPE);
        String serverName = (String)props.get(WCMAppModel.PROP_DEPLOYSERVERNAME);
        if (serverName == null || serverName.length() == 0) {
            serverName = AVMDeployWebsiteAction.calculateServerUri((Map)props);
        }
        out.write("</td>");
        if (showSeparator) {
            out.write("<td width='2'><img src='");
            out.write(contextPath);
            out.write("/images/parts/deploy_panel_separator.gif' /></td>");
        }
        out.write("<td style='background-image: url(");
        out.write(contextPath);
        out.write("/images/parts/deploy_panel_bg.gif); background-repeat: repeat-x;'>");
        out.write("<div class='deployPanelIcon'>");
        out.write("<img src='");
        out.write(contextPath);
        out.write("/images/icons/deploy_server_");
        out.write(deployType);
        out.write(".gif' /></div></td>");
        out.write("<td style='background-image: url(");
        out.write(contextPath);
        out.write("/images/parts/deploy_panel_bg.gif); background-repeat: repeat-x; width: 100%;'>");
        out.write("<div class='deployPanelServerName'>");
        out.write(Utils.encode((String)serverName));
        out.write("</div>");
    }

    private void renderPanelEnd(ResponseWriter out, String contextPath) throws IOException {
        out.write("</td><td width='10'><img src='");
        out.write(contextPath);
        out.write("/images/parts/deploy_panel_end.gif' /></td></tr></table>");
        out.write("\n<div style='padding-top:8px;'></div>\n");
    }

    private List<DeploymentServerConfig> toSortedDeploymentServerConfig(NodeService nodeService, List<NodeRef> refs) {
        ArrayList<DeploymentServerConfig> servers = new ArrayList<DeploymentServerConfig>();
        for (NodeRef ref : refs) {
            DeploymentServerConfig server = new DeploymentServerConfig(ref, nodeService.getProperties(ref));
            servers.add(server);
        }
        CompoundComparator comp = new CompoundComparator();
        comp.addComparator((Comparator)new DeploymentServerConfigComparator("group"));
        comp.addComparator((Comparator)new DeploymentServerConfigComparator("name"));
        Collections.sort(servers, comp);
        return servers;
    }

    private class ParentChildCheckboxHelper {
        private String clientId;
        String currentDisplayGroup = "";
        String groupChildName = "";
        String groupParentId = "";
        String groupName = "";
        int groupNumber = 1;
        boolean newGroup = false;
        static final String helperChildPattern = ":group[\\d]+:child";

        public ParentChildCheckboxHelper(String clientId) {
            this.clientId = clientId;
        }

        public void setCurrentDisplayGroup(String currentDisplayGroup) {
            this.newGroup = !this.currentDisplayGroup.equalsIgnoreCase(currentDisplayGroup);
            this.currentDisplayGroup = currentDisplayGroup;
            if (this.newGroup) {
                this.changeGroup(currentDisplayGroup);
            }
        }

        public String getCurrentDisplayGroup() {
            return this.currentDisplayGroup;
        }

        private void changeGroup(String newGroupName) {
            this.groupName = this.clientId + ":group" + Integer.toString(this.groupNumber++);
            this.groupChildName = this.groupName + ":child";
            this.groupParentId = this.groupName + ":parent";
        }
    }
}

