/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.actions.AVMDeployWebsiteAction;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DeploymentServerConfig;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.repo.component.UIActions;
import org.alfresco.web.ui.wcm.component.DeploymentServerConfigComparator;
import org.springframework.util.comparator.CompoundComparator;

public class UIDeploymentServers
extends UIInput {
    private static final String MSG_LIVE_SERVER = "deploy_server_type_live";
    private static final String MSG_TEST_SERVER = "deploy_server_type_test";
    private static final String MSG_TYPE = "deploy_server_type";
    private static final String MSG_NAME = "deploy_server_name";
    private static final String MSG_GROUP = "deploy_server_group";
    private static final String MSG_ADAPTER_NAME = "deploy_server_adapter_name";
    private static final String MSG_HOST = "deploy_server_host";
    private static final String MSG_PORT = "deploy_server_port";
    private static final String MSG_USER = "deploy_server_username";
    private static final String MSG_PWD = "deploy_server_password";
    private static final String MSG_URL = "deploy_server_url";
    private static final String MSG_ALLOCATED = "deploy_server_allocated";
    private static final String MSG_SOURCE = "deploy_server_source_path";
    private static final String MSG_TARGET = "deploy_server_target_name";
    private static final String MSG_EXCLUDES = "deploy_server_excludes";
    private static final String MSG_INCLUDE_AUTO_DEPLOY = "deploy_server_include_auto_deploy";
    private static final String MSG_EDIT = "edit_deploy_server";
    private static final String MSG_DELETE = "delete_deploy_server";
    private static final String MSG_NO_DEPLOY_SERVERS = "no_deploy_servers";
    private static final String MSG_NO_DATA = "no_data";
    private List<DeploymentServerConfig> servers;
    private DeploymentServerConfig currentServer;
    private Boolean inAddMode;
    private String addType;
    private DeploymentService deploymentService;

    public UIDeploymentServers() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.DeploymentServers";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.servers = (List)values[1];
        this.inAddMode = (Boolean)values[2];
        this.addType = (String)values[3];
        this.currentServer = (DeploymentServerConfig)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.servers, this.inAddMode, this.addType, this.currentServer};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.getChildren().clear();
        ResponseWriter out = context.getResponseWriter();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            String contextPath = context.getExternalContext().getRequestContextPath();
            out.write("\n<script type='text/javascript'>");
            out.write("var MSG_PORT_MUST_BE_NUMBER = '" + org.alfresco.web.app.Application.getMessage(context, "port_must_be_number") + "'; \n");
            out.write("var MSG_HOST_WRONG_FORMAT = '" + org.alfresco.web.app.Application.getMessage(context, "host_wrong_format") + "'; \n");
            out.write("</script>\n");
            out.write("<script type='text/javascript' src='");
            out.write(contextPath);
            out.write("/scripts/ajax/deployment.js'></script>\n");
            out.write("<div class='deployConfig'>");
            Object servers = this.getValue();
            CompoundComparator comp = new CompoundComparator();
            comp.addComparator((Comparator)new DeploymentServerConfigComparator("group"));
            comp.addComparator((Comparator)new DeploymentServerConfigComparator("name"));
            Collections.sort(servers, comp);
            if (this.getInAddMode()) {
                this.renderServerForm(context, out, null, false);
            } else if (servers.size() == 0) {
                out.write("<div class='deployNoConfigServers'><img src='");
                out.write(contextPath);
                out.write("/images/icons/info_icon.gif' />&nbsp;");
                out.write(org.alfresco.web.app.Application.getMessage(context, MSG_NO_DEPLOY_SERVERS));
                out.write("</div>");
            }
            DeploymentServerConfig currentServer = this.getCurrentServer();
            String currentDisplayGroup = "";
            Iterator i$ = servers.iterator();
            while (i$.hasNext()) {
                DeploymentServerConfig server = (DeploymentServerConfig)i$.next();
                String displayGroup = (String)server.getProperties().get("group");
                if (!currentDisplayGroup.equalsIgnoreCase(displayGroup)) {
                    out.write("<p class='mainSubTitle'>");
                    out.write(Utils.encode((String)displayGroup));
                    out.write("</p>");
                    currentDisplayGroup = displayGroup;
                }
                if (currentServer != null && currentServer.getId().equals(server.getId())) {
                    this.renderServerForm(context, out, server, true);
                    continue;
                }
                this.renderServer(context, out, server);
            }
            out.write("</div>");
            out.write("\n<script type='text/javascript'>");
            out.write("YAHOO.util.Event.on(window, \"load\", Alfresco.checkDeployConfigPage);");
            if (currentServer != null) {
                out.write("var SCROLL_TO_SERVER_CONFIG_ID = '");
                out.write(currentServer.getId());
                out.write("';\n");
            }
            out.write("</script>\n");
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            throw new RuntimeException(err);
        }
    }

    public List<DeploymentServerConfig> getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.servers = (List)vb.getValue(this.getFacesContext());
        }
        return this.servers;
    }

    public void setValue(List<DeploymentServerConfig> value) {
        this.servers = value;
    }

    public void setCurrentServer(DeploymentServerConfig server) {
        this.currentServer = server;
    }

    public DeploymentServerConfig getCurrentServer() {
        ValueBinding vb = this.getValueBinding("currentServer");
        if (vb != null) {
            this.currentServer = (DeploymentServerConfig)vb.getValue(this.getFacesContext());
        }
        return this.currentServer;
    }

    public boolean getInAddMode() {
        ValueBinding vb = this.getValueBinding("inAddMode");
        if (vb != null) {
            this.inAddMode = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.inAddMode == null) {
            this.inAddMode = Boolean.FALSE;
        }
        return this.inAddMode;
    }

    public void setInAddMode(boolean inAddMode) {
        this.inAddMode = new Boolean(inAddMode);
    }

    public String getAddType() {
        ValueBinding vb = this.getValueBinding("addType");
        if (vb != null) {
            this.addType = (String)vb.getValue(this.getFacesContext());
        }
        if (this.addType == null) {
            this.addType = "file";
        }
        return this.addType;
    }

    public void setAddType(String value) {
        this.addType = value;
    }

    protected void renderServer(FacesContext context, ResponseWriter out, DeploymentServerConfig server) throws IOException {
        String contextPath = context.getExternalContext().getRequestContextPath();
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(context);
        String noData = bundle.getString(MSG_NO_DATA);
        String serverName = (String)server.getProperties().get("name");
        if (serverName == null || serverName.length() == 0) {
            serverName = AVMDeployWebsiteAction.calculateServerUri(server.getRepoProps());
        }
        out.write("<div class='deployConfigServer'>");
        PanelGenerator.generatePanelStart((Writer)out, contextPath, "lightstorm", "#eaeff2");
        out.write("<table width='100%'><tr><td><img class='deployConfigServerIcon' src='");
        out.write(contextPath);
        out.write("/images/icons/deploy_server_");
        out.write(Utils.encode((String)server.getDeployType()));
        out.write(".gif");
        out.write("' /></td><td width='100%'><span class='deployPanelServerName'>");
        out.write(Utils.encode((String)serverName));
        out.write("</span></td><td><div class='deployConfigServerActions'>");
        Utils.encodeRecursive(context, (UIComponent)this.aquireEditServerAction(context, server.getId()));
        Utils.encodeRecursive(context, (UIComponent)this.aquireDeleteServerAction(context, server.getId()));
        out.write("</div></td></tr>");
        out.write("<tr><td colspan='3'>");
        out.write("<table cellpadding='0' cellspacing='0'>");
        out.write("<tr><td width='100%'><table cellpadding='3' cellspacing='0' class='deployConfigServerDetailsLeftCol'>");
        if ("file".equals(server.getDeployType())) {
            out.write("<tr><td align='right'>");
            out.write(bundle.getString(MSG_ADAPTER_NAME));
            out.write(":</td><td>");
            if (server.getProperties().get("adapterName") != null) {
                out.write((String)server.getProperties().get("adapterName"));
            } else {
                out.write(noData);
            }
            out.write("</td></tr>");
        }
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_HOST));
        out.write(":</td><td>");
        if (server.getProperties().get("host") != null) {
            out.write(Utils.encode((String)((String)server.getProperties().get("host"))));
        }
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_PORT));
        out.write(":</td><td>");
        if (server.getProperties().get("port") != null) {
            out.write(Utils.encode((String)((String)server.getProperties().get("port"))));
        } else {
            out.write(noData);
        }
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_URL));
        out.write(":</td><td>");
        if (server.getProperties().get("url") != null) {
            out.write(Utils.encode((String)((String)server.getProperties().get("url"))));
        } else {
            out.write(noData);
        }
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_TYPE));
        out.write(":</td><td>");
        if (server.getProperties().get("type") != null) {
            String type = (String)server.getProperties().get("type");
            if ("live".equals(type)) {
                out.write(Utils.encode((String)org.alfresco.web.app.Application.getMessage(context, MSG_LIVE_SERVER)));
            } else if ("test".equals(type)) {
                out.write(Utils.encode((String)org.alfresco.web.app.Application.getMessage(context, MSG_TEST_SERVER)));
            }
        }
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_USER));
        out.write(":</td><td>");
        if (server.getProperties().get("username") != null) {
            out.write(Utils.encode((String)((String)server.getProperties().get("username"))));
        } else {
            out.write(noData);
        }
        out.write("</td></tr></table></td>");
        out.write("<td valign='top'><table cellpadding='3' cellspacing='0' class='deployConfigServerDetailsRightCol'>");
        out.write("<tr><td align='right'><nobr>");
        out.write(bundle.getString(MSG_SOURCE));
        out.write(":</nobr></td><td>");
        if (server.getProperties().get("sourcePath") != null) {
            out.write(Utils.encode((String)((String)server.getProperties().get("sourcePath"))));
        } else {
            out.write(noData);
        }
        out.write("</td></tr>");
        out.write("<tr><td align='right'><nobr>");
        out.write(bundle.getString(MSG_EXCLUDES));
        out.write(":</nobr></td><td>");
        if (server.getProperties().get("excludes") != null) {
            out.write(Utils.encode((String)((String)server.getProperties().get("excludes"))));
        } else {
            out.write(noData);
        }
        out.write("</td></tr>");
        if ("file".equals(server.getDeployType())) {
            out.write("<tr><td align='right'><nobr>");
            out.write(bundle.getString(MSG_TARGET));
            out.write(":</nobr></td><td>");
            if (server.getProperties().get("targetName") != null) {
                out.write(Utils.encode((String)((String)server.getProperties().get("targetName"))));
            } else {
                out.write(noData);
            }
            out.write("</td></tr>");
        }
        if ("live".equals(server.getProperties().get("type"))) {
            out.write("<tr><td align='right'><nobr>");
            out.write(bundle.getString(MSG_INCLUDE_AUTO_DEPLOY));
            out.write(":</nobr></td><td>");
            if (server.getProperties().get("onApproval") != null) {
                Object obj = server.getProperties().get("onApproval");
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    out.write(bundle.getString("yes"));
                } else {
                    out.write(bundle.getString("no"));
                }
            }
            out.write("</td></tr>");
        }
        if ("test".equals(server.getProperties().get("type"))) {
            out.write("<tr><td align='right'><nobr>");
            out.write(Utils.encode((String)bundle.getString(MSG_ALLOCATED)));
            out.write(":</nobr></td><td>");
            if (server.getProperties().get("allocatedTo") != null) {
                String allocatedToTip = (String)server.getProperties().get("allocatedTo");
                out.write("<span title='");
                out.write(Utils.encode((String)allocatedToTip));
                out.write("'><nobr>");
                out.write(bundle.getString("yes"));
                out.write("&nbsp;(");
                if (AVMUtil.isWorkflowStore(allocatedToTip)) {
                    out.write(bundle.getString("review_sandbox"));
                } else {
                    String username = AVMUtil.getUserName(allocatedToTip);
                    out.write(Utils.encode((String)username));
                }
                out.write(")</nobr></span>");
            } else {
                out.write(bundle.getString("no"));
            }
            out.write("</td></tr>");
        }
        out.write("</table></td></tr></table></td></tr></table>");
        PanelGenerator.generatePanelEnd((Writer)out, contextPath, "lightstorm");
        out.write("</div>");
    }

    protected void renderServerForm(FacesContext context, ResponseWriter out, DeploymentServerConfig server, boolean edit) throws IOException {
        String contextPath = context.getExternalContext().getRequestContextPath();
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(context);
        out.write("<div class='deployConfigServer'");
        if (edit) {
            out.write(" id='");
            out.write(server.getId());
            out.write("'");
        }
        out.write(">");
        PanelGenerator.generatePanelStart((Writer)out, contextPath, "lightstorm", "#eaeff2");
        out.write("<table width='100%'><tr><td><img class='deployConfigServerIcon' src='");
        out.write(contextPath);
        out.write("/images/icons/deploy_server_");
        if (edit) {
            out.write(Utils.encode((String)server.getDeployType()));
        } else {
            out.write(this.getAddType());
        }
        out.write(".gif' /></td>");
        out.write("<td width='100%'><span class='mainSubTitle'>");
        if (edit) {
            if ("alfresco".equals(server.getDeployType())) {
                out.write(bundle.getString("edit_alf_deploy_server_info"));
            } else {
                out.write(bundle.getString("edit_file_deploy_server_info"));
            }
        } else if ("alfresco".equals(this.getAddType())) {
            out.write(bundle.getString("add_alf_deploy_server_info"));
        } else {
            out.write(bundle.getString("add_file_deploy_server_info"));
        }
        out.write("</span></td></tr>");
        out.write("<tr><td colspan='2'><table class='deployConfigServerForm'>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_TYPE));
        out.write(":</td><td>");
        UIComponent type = context.getApplication().createComponent("javax.faces.SelectOne");
        FacesHelper.setupComponentId(context, type, "deployServerType");
        type.getAttributes().put("styleClass", "inputField");
        type.getAttributes().put("onchange", "javascript:Alfresco.deployServerTypeChanged();");
        ValueBinding vbType = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.type}");
        type.setValueBinding("value", vbType);
        UISelectItems itemsComponent = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(2);
        items.add(new SelectItem((Object)"live", org.alfresco.web.app.Application.getMessage(context, MSG_LIVE_SERVER)));
        items.add(new SelectItem((Object)"test", org.alfresco.web.app.Application.getMessage(context, MSG_TEST_SERVER)));
        itemsComponent.setValue(items);
        type.getChildren().add(itemsComponent);
        this.getChildren().add(type);
        Utils.encodeRecursive(context, type);
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_NAME));
        out.write(":</td><td>");
        UIComponent name = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, name, null);
        name.getAttributes().put("styleClass", "inputField");
        ValueBinding vbName = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.name}");
        name.setValueBinding("value", vbName);
        this.getChildren().add(name);
        Utils.encodeRecursive(context, name);
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_GROUP));
        out.write(":</td><td>");
        UIComponent group = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, group, null);
        group.getAttributes().put("styleClass", "inputField");
        ValueBinding vbGroup = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.group}");
        group.setValueBinding("value", vbGroup);
        this.getChildren().add(group);
        Utils.encodeRecursive(context, group);
        out.write("</td></tr>");
        if (!edit && "file".equals(this.getAddType()) || edit && "file".equals(server.getDeployType())) {
            out.write("<tr><td align='right'>");
            out.write(bundle.getString(MSG_ADAPTER_NAME));
            out.write(":</td><td>");
            UIComponent adapterName = context.getApplication().createComponent("javax.faces.SelectOne");
            FacesHelper.setupComponentId(context, adapterName, MSG_ADAPTER_NAME);
            adapterName.getAttributes().put("styleClass", "inputField");
            ValueBinding vbAdapterName = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.adapterName}");
            adapterName.setValueBinding("value", vbAdapterName);
            UISelectItems adaptersComponent = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
            DeploymentService dep = this.getDeploymentService();
            if (dep == null) {
                ArrayList<SelectItem> adapters = new ArrayList<SelectItem>(1);
                adapters.add(new SelectItem((Object)"default", "Default"));
                adaptersComponent.setValue(adapters);
            } else {
                Set adapterNames = dep.getAdapterNames();
                ArrayList<SelectItem> adapters = new ArrayList<SelectItem>(adapterNames.size());
                for (String aname : adapterNames) {
                    adapters.add(new SelectItem((Object)aname, aname));
                }
                adaptersComponent.setValue(adapters);
            }
            adapterName.getChildren().add(adaptersComponent);
            this.getChildren().add(adapterName);
            Utils.encodeRecursive(context, adapterName);
            out.write("</td></tr>");
        }
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_HOST));
        out.write(":</td><td>");
        UIComponent host = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, host, "deployServerHost");
        host.getAttributes().put("styleClass", "inputField");
        host.getAttributes().put("onkeyup", "javascript:Alfresco.checkDeployConfigButtonState();");
        host.getAttributes().put("onchange", "javascript:Alfresco.checkDeployConfigButtonState();");
        ValueBinding vbHost = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.host}");
        host.setValueBinding("value", vbHost);
        this.getChildren().add(host);
        Utils.encodeRecursive(context, host);
        out.write("</td><td><img src='");
        out.write(contextPath);
        out.write("/images/icons/required_field.gif' title='");
        out.write(bundle.getString("required_field"));
        out.write("'/></td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_PORT));
        out.write(":</td><td>");
        UIComponent port = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, port, "deployServerPort");
        port.getAttributes().put("styleClass", "inputField");
        port.getAttributes().put("onkeyup", "javascript:Alfresco.checkDeployConfigButtonState();");
        port.getAttributes().put("onchange", "javascript:Alfresco.checkDeployConfigButtonState();");
        ValueBinding vbPort = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.port}");
        port.setValueBinding("value", vbPort);
        this.getChildren().add(port);
        Utils.encodeRecursive(context, port);
        out.write("</td><td><img src='");
        out.write(contextPath);
        out.write("/images/icons/required_field.gif' title='");
        out.write(bundle.getString("required_field"));
        out.write("'/></td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_URL));
        out.write(":</td><td>");
        UIComponent url = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, url, null);
        url.getAttributes().put("styleClass", "inputField");
        ValueBinding vbUrl = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.url}");
        url.setValueBinding("value", vbUrl);
        this.getChildren().add(url);
        Utils.encodeRecursive(context, url);
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_USER));
        out.write(":</td><td>");
        UIComponent username = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, username, null);
        username.getAttributes().put("styleClass", "inputField");
        ValueBinding vbUser = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.username}");
        username.setValueBinding("value", vbUser);
        this.getChildren().add(username);
        Utils.encodeRecursive(context, username);
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_PWD));
        out.write(":</td><td>");
        UIComponent pwd = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, pwd, null);
        pwd.setRendererType("javax.faces.Secret");
        pwd.getAttributes().put("styleClass", "inputField");
        pwd.getAttributes().put("redisplay", true);
        ValueBinding vbPwd = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.password}");
        pwd.setValueBinding("value", vbPwd);
        this.getChildren().add(pwd);
        Utils.encodeRecursive(context, pwd);
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_SOURCE));
        out.write(":</td><td>");
        UIComponent source = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, source, null);
        source.getAttributes().put("styleClass", "inputField");
        ValueBinding vbSource = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.sourcePath}");
        source.setValueBinding("value", vbSource);
        this.getChildren().add(source);
        Utils.encodeRecursive(context, source);
        out.write("</td></tr>");
        out.write("<tr><td align='right'>");
        out.write(bundle.getString(MSG_EXCLUDES));
        out.write(":</td><td>");
        UIComponent excludes = context.getApplication().createComponent("javax.faces.Input");
        FacesHelper.setupComponentId(context, excludes, null);
        excludes.getAttributes().put("styleClass", "inputField");
        ValueBinding vbExcludes = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.excludes}");
        excludes.setValueBinding("value", vbExcludes);
        this.getChildren().add(excludes);
        Utils.encodeRecursive(context, excludes);
        out.write("</td></tr>");
        if (!edit && "file".equals(this.getAddType()) || edit && "file".equals(server.getDeployType())) {
            out.write("<tr><td align='right'>");
            out.write(bundle.getString(MSG_TARGET));
            out.write(":</td><td>");
            UIComponent target = context.getApplication().createComponent("javax.faces.Input");
            FacesHelper.setupComponentId(context, target, null);
            target.getAttributes().put("styleClass", "inputField");
            ValueBinding vbTarget = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.targetName}");
            target.setValueBinding("value", vbTarget);
            this.getChildren().add(target);
            Utils.encodeRecursive(context, target);
            out.write("</td></tr>");
        }
        out.write("<tr><td align='right'></td><td>");
        UIComponent auto = context.getApplication().createComponent("javax.faces.SelectBoolean");
        FacesHelper.setupComponentId(context, auto, "autoDeployCheckbox");
        ValueBinding vbAuto = context.getApplication().createValueBinding("#{WizardManager.bean.editedDeployServerProperties.onApproval}");
        auto.setValueBinding("value", vbAuto);
        this.getChildren().add(auto);
        Utils.encodeRecursive(context, auto);
        out.write("<span id='autoDeployLabel'>&nbsp;");
        out.write(bundle.getString(MSG_INCLUDE_AUTO_DEPLOY));
        out.write("</td></tr>");
        out.write("<tr><td colspan='2' align='right'>");
        UICommand cancelButton = (UICommand)context.getApplication().createComponent("javax.faces.Command");
        FacesHelper.setupComponentId(context, (UIComponent)cancelButton, null);
        cancelButton.setValue((Object)bundle.getString("cancel"));
        MethodBinding cancelBinding = context.getApplication().createMethodBinding("#{WizardManager.bean.cancelDeploymentServerConfig}", new Class[0]);
        cancelButton.setAction(cancelBinding);
        this.getChildren().add(cancelButton);
        Utils.encodeRecursive(context, (UIComponent)cancelButton);
        out.write("&nbsp;&nbsp;");
        if (edit) {
            UICommand saveButton = (UICommand)context.getApplication().createComponent("javax.faces.Command");
            FacesHelper.setupComponentId(context, (UIComponent)saveButton, "deployActionButton");
            saveButton.setValue((Object)bundle.getString("save"));
            MethodBinding saveBinding = context.getApplication().createMethodBinding("#{WizardManager.bean.saveDeploymentServerConfig}", new Class[0]);
            saveButton.setAction(saveBinding);
            this.getChildren().add(saveButton);
            Utils.encodeRecursive(context, (UIComponent)saveButton);
        } else {
            UICommand addButton = (UICommand)context.getApplication().createComponent("javax.faces.Command");
            FacesHelper.setupComponentId(context, (UIComponent)addButton, "deployActionButton");
            addButton.setValue((Object)bundle.getString("add"));
            MethodBinding addBinding = context.getApplication().createMethodBinding("#{WizardManager.bean.addDeploymentServerConfig}", new Class[0]);
            addButton.setAction(addBinding);
            this.getChildren().add(addButton);
            Utils.encodeRecursive(context, (UIComponent)addButton);
            out.write("</td></tr>");
        }
        out.write("</td></tr></table></td></tr></table>");
        PanelGenerator.generatePanelEnd((Writer)out, contextPath, "lightstorm");
        out.write("</div>");
    }

    protected UIActionLink aquireEditServerAction(FacesContext context, String serverId) {
        UIActionLink action = null;
        String actionId = "edit_" + serverId;
        for (UIComponent component : this.getChildren()) {
            if (!actionId.equals(component.getId())) continue;
            action = (UIActionLink)component;
            break;
        }
        if (action == null) {
            Application facesApp = context.getApplication();
            action = (UIActionLink)facesApp.createComponent("org.alfresco.faces.ActionLink");
            action.setId(actionId);
            action.setValue(org.alfresco.web.app.Application.getMessage(context, MSG_EDIT));
            action.setImage("/images/icons/edit_icon.gif");
            action.setShowLink(false);
            action.setActionListener(facesApp.createMethodBinding("#{WizardManager.bean.editDeploymentServerConfig}", UIActions.ACTION_CLASS_ARGS));
            UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
            param.setId(actionId + "_1");
            param.setName("id");
            param.setValue((Object)serverId);
            action.getChildren().add(param);
            this.getChildren().add(action);
        }
        return action;
    }

    protected UIActionLink aquireDeleteServerAction(FacesContext context, String serverId) {
        UIActionLink action = null;
        String actionId = "delete_" + serverId;
        for (UIComponent component : this.getChildren()) {
            if (!actionId.equals(component.getId())) continue;
            action = (UIActionLink)component;
            break;
        }
        if (action == null) {
            Application facesApp = context.getApplication();
            action = (UIActionLink)facesApp.createComponent("org.alfresco.faces.ActionLink");
            action.setId(actionId);
            action.setValue(org.alfresco.web.app.Application.getMessage(context, MSG_DELETE));
            action.setImage("/images/icons/delete.gif");
            action.setShowLink(false);
            action.setActionListener(facesApp.createMethodBinding("#{WizardManager.bean.deleteDeploymentServerConfig}", UIActions.ACTION_CLASS_ARGS));
            UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
            param.setId(actionId + "_1");
            param.setName("id");
            param.setValue((Object)serverId);
            action.getChildren().add(param);
            this.getChildren().add(action);
        }
        return action;
    }

    public List<UIListItem> getDeployServerTypes() {
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem live = new UIListItem();
        live.setValue("live");
        live.setLabel(org.alfresco.web.app.Application.getMessage(FacesContext.getCurrentInstance(), MSG_LIVE_SERVER));
        UIListItem test = new UIListItem();
        test.setValue("test");
        test.setLabel(org.alfresco.web.app.Application.getMessage(FacesContext.getCurrentInstance(), MSG_TEST_SERVER));
        items.add(live);
        items.add(test);
        return items;
    }

    protected DeploymentService getDeploymentService() {
        if (this.deploymentService == null) {
            this.deploymentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDeploymentService();
        }
        return this.deploymentService;
    }
}

