/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.sandbox.SandboxVersion;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.alfresco.web.bean.wcm.WCMCompareUtils;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.repo.component.UIActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.ConstantMethodBinding;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;
import org.springframework.web.jsf.FacesContextUtils;

public class UISandboxSnapshots
extends SelfRenderingComponent {
    private static final String ACT_SNAPSHOT_PREVIEW = "snapshot_preview";
    private static final String ACT_SNAPSHOT_REVERT = "snapshot_revert";
    private static final String ACT_SNAPSHOT_COMPARE_TO_CURRENT = "snapshot_compare_to_current";
    private static final String ACT_SNAPSHOT_COMPARE_TO_PREVIOUS = "snapshot_compare_to_previous";
    private static final String ACT_SNAPSHOT_COMPARE_TO_ANY = "snapshot_compare_to_any";
    private static final String ACT_SNAPSHOT_DEPLOY = "snapshot_deploy";
    private static final String REQUEST_SNAPVERSION = "_snapVer";
    private static Log logger = LogFactory.getLog(UISandboxSnapshots.class);
    public static final String FILTER_DATE_ALL = "all";
    public static final String FILTER_DATE_TODAY = "today";
    public static final String FILTER_DATE_WEEK = "week";
    public static final String FILTER_DATE_MONTH = "month";
    private static final String MSG_LABEL = "name";
    private static final String MSG_DESCRIPTION = "description";
    private static final String MSG_DATE = "date";
    private static final String MSG_USERNAME = "snapshot_submitted_by";
    private static final String MSG_VERSION = "version";
    private static final String MSG_STATUS = "status";
    private static final String MSG_ACTIONS = "actions";
    private static final String MSG_LIVE = "live";
    private String value;
    private String dateFilter;
    private int deployAttemptVersion = -1;
    private String deployStatus;

    public String getFamily() {
        return "org.alfresco.faces.SandboxSnapshots";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.value};
        return values;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(context);
        DateFormat df = Utils.getDateTimeFormat(context);
        AVMService avmService = this.getAVMService(context);
        SandboxService sbService = this.getSandboxService(context);
        UserTransaction tx = null;
        try {
            List versions;
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            String sandbox = this.getValue();
            if (sandbox == null) {
                throw new IllegalArgumentException("Sandbox must be specified.");
            }
            out.write("<table class='snapshotItemsList' cellspacing=2 cellpadding=1 border=0 width=100%>");
            out.write("<tr align=left><th>");
            out.write(bundle.getString(MSG_LABEL));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_DESCRIPTION));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_DATE));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_USERNAME));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_VERSION));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_STATUS));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_ACTIONS));
            out.write("</th></tr>");
            String dateFilter = this.getDateFilter();
            if (dateFilter == null || dateFilter.equals(FILTER_DATE_ALL)) {
                versions = sbService.listSnapshots(sandbox, false);
            } else {
                Date fromDate;
                Date toDate = new Date();
                if (FILTER_DATE_TODAY.equals(dateFilter)) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(toDate);
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    fromDate = c.getTime();
                } else if (FILTER_DATE_WEEK.equals(dateFilter)) {
                    fromDate = new Date(toDate.getTime() - 604800000L);
                } else if (FILTER_DATE_MONTH.equals(dateFilter)) {
                    fromDate = new Date(toDate.getTime() - 2592000000L);
                } else {
                    throw new IllegalArgumentException("Unknown date filter mode: " + dateFilter);
                }
                versions = sbService.listSnapshots(sandbox, fromDate, toDate, false);
            }
            boolean showDeployAction = false;
            NodeRef webProjectRef = Repository.getServiceRegistry(context).getWebProjectService().getWebProjectNodeFromStore(WCMUtil.getWebProjectStoreId((String)sandbox));
            List deployToServers = Repository.getServiceRegistry(context).getDeploymentService().findLiveDeploymentServers(webProjectRef);
            if (deployToServers != null && deployToServers.size() > 0) {
                showDeployAction = true;
            }
            NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
            this.determineDeploymentStatus(context, webProjectRef, sandbox, nodeService, avmService);
            Map requestMap = context.getExternalContext().getRequestMap();
            for (SandboxVersion item : versions) {
                HashMap<String, String> params;
                boolean isFirstVersion;
                boolean isLatestVersion;
                HashMap<String, String> params2;
                if (item.isSystemGenerated()) continue;
                int version = item.getVersion();
                out.write("<tr><td>");
                out.write(Utils.encode((String)item.getLabel()));
                out.write("</td><td>");
                out.write(item.getDescription() != null ? Utils.encode((String)item.getDescription()) : "");
                out.write("</td><td>");
                out.write(df.format(item.getCreatedDate()));
                out.write("</td><td>");
                out.write(Utils.encode((String)item.getCreator()));
                out.write("</td><td>");
                out.write(Integer.toString(version));
                out.write("</td><td>");
                if (version == this.deployAttemptVersion && this.deployStatus != null) {
                    out.write(this.deployStatus);
                } else {
                    out.write("&nbsp;");
                }
                out.write("</td><td><nobr>");
                UIActionLink action = this.findAction(ACT_SNAPSHOT_REVERT, sandbox);
                if (action == null) {
                    params2 = new HashMap<String, String>(2, 1.0f);
                    params2.put("sandbox", sandbox);
                    params2.put(MSG_VERSION, "#{_snapVer}");
                    action = this.createAction(context, sandbox, ACT_SNAPSHOT_REVERT, "/images/icons/revert.gif", "#{DialogManager.setupParameters}", "dialog:revertSnapshot", null, params2);
                }
                requestMap.put(REQUEST_SNAPVERSION, Integer.toString(item.getVersion()));
                Utils.encodeRecursive(context, (UIComponent)action);
                if (showDeployAction) {
                    out.write("&nbsp;&nbsp;");
                    action = this.findAction(ACT_SNAPSHOT_DEPLOY, sandbox);
                    if (action == null) {
                        params2 = new HashMap(2, 1.0f);
                        params2.put(MSG_VERSION, "#{_snapVer}");
                        params2.put("store", sandbox);
                        action = this.createAction(context, sandbox, ACT_SNAPSHOT_DEPLOY, "/images/icons/deploy.gif", "#{DialogManager.setupParameters}", "dialog:deployWebsite", null, params2);
                    }
                    Utils.encodeRecursive(context, (UIComponent)action);
                }
                if (!(isLatestVersion = WCMCompareUtils.isLatestVersion(versions, item))) {
                    out.write("&nbsp;&nbsp;");
                    action = this.findAction(ACT_SNAPSHOT_COMPARE_TO_CURRENT, sandbox);
                    if (action == null) {
                        HashMap<String, String> params3 = new HashMap<String, String>(4, 1.0f);
                        params3.put("sandbox", sandbox);
                        params3.put("store", sandbox);
                        params3.put(MSG_VERSION, "#{_snapVer}");
                        action = this.createAction(context, sandbox, ACT_SNAPSHOT_COMPARE_TO_CURRENT, "/images/icons/comparetocurrent.png", "#{DialogManager.setupParameters}", "dialog:compareToCurrentSnapshot", null, params3);
                    }
                    Utils.encodeRecursive(context, (UIComponent)action);
                }
                if (!(isFirstVersion = WCMCompareUtils.isFirstVersion(versions, item))) {
                    out.write("&nbsp;&nbsp;");
                    action = this.findAction(ACT_SNAPSHOT_COMPARE_TO_PREVIOUS, sandbox);
                    if (action == null) {
                        params = new HashMap<String, String>(2, 1.0f);
                        params.put("sandbox", sandbox);
                        params.put(MSG_VERSION, "#{_snapVer}");
                        action = this.createAction(context, sandbox, ACT_SNAPSHOT_COMPARE_TO_PREVIOUS, "/images/icons/comparetoprevious.png", "#{DialogManager.setupParameters}", "dialog:compareToPreviousSnapshot", null, params);
                    }
                    Utils.encodeRecursive(context, (UIComponent)action);
                }
                out.write("&nbsp;&nbsp;");
                action = this.findAction(ACT_SNAPSHOT_COMPARE_TO_ANY, sandbox);
                if (action == null) {
                    params = new HashMap(2, 1.0f);
                    params.put("sandbox", sandbox);
                    params.put(MSG_VERSION, "#{_snapVer}");
                    action = this.createAction(context, sandbox, ACT_SNAPSHOT_COMPARE_TO_ANY, "/images/icons/comparetoany.png", "#{DialogManager.setupParameters}", "dialog:compareToAnySnapshot", null, params);
                }
                Utils.encodeRecursive(context, (UIComponent)action);
                requestMap.remove(REQUEST_SNAPVERSION);
                out.write("</nobr></td></tr>");
            }
            out.write("</table>");
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            throw new RuntimeException(err);
        }
    }

    private UIActionLink aquireAction(FacesContext fc, String sandbox, String name, String icon, String actionListener, String outcome) {
        return this.aquireAction(fc, sandbox, name, icon, actionListener, outcome, null, null);
    }

    private UIActionLink aquireAction(FacesContext fc, String sandbox, String name, String icon, String actionListener, String outcome, String url, Map<String, String> params) {
        UIActionLink action = this.findAction(name, sandbox);
        if (action == null) {
            action = this.createAction(fc, sandbox, name, icon, actionListener, outcome, url, params);
        }
        return action;
    }

    private UIActionLink findAction(String name, String sandbox) {
        UIActionLink action = null;
        String actionId = name + '_' + sandbox;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding action Id: " + actionId));
        }
        for (UIComponent component : this.getChildren()) {
            if (!actionId.equals(component.getId())) continue;
            action = (UIActionLink)component;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("...found action Id: " + actionId));
            break;
        }
        return action;
    }

    private UIActionLink createAction(FacesContext fc, String sandbox, String name, String icon, String actionListener, String outcome, String url, Map<String, String> params) {
        Application facesApp = fc.getApplication();
        UIActionLink control = (UIActionLink)facesApp.createComponent("org.alfresco.faces.ActionLink");
        String id = name + '_' + sandbox;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("...creating action Id: " + id));
        }
        control.setRendererType("org.alfresco.faces.ActionLinkRenderer");
        control.setId(id);
        control.setValue(org.alfresco.web.app.Application.getMessage(fc, name));
        control.setShowLink(icon == null);
        control.setImage(icon);
        if (actionListener != null) {
            control.setActionListener(facesApp.createMethodBinding(actionListener, UIActions.ACTION_CLASS_ARGS));
            if (params == null) {
                UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                param.setId(id + "_1");
                param.setName("sandbox");
                param.setValue((Object)sandbox);
                control.getChildren().add(param);
            } else {
                int idIndex = 1;
                for (String key : params.keySet()) {
                    UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                    param.setId(id + '_' + Integer.toString(idIndex++));
                    param.setName(key);
                    String value = params.get(key);
                    if (value.startsWith("#{")) {
                        ValueBinding vb = facesApp.createValueBinding(value);
                        param.setValueBinding("value", vb);
                    } else {
                        param.setValue((Object)params.get(key));
                    }
                    control.getChildren().add(param);
                }
            }
        }
        if (outcome != null) {
            control.setAction((MethodBinding)new ConstantMethodBinding(outcome));
        }
        if (url != null) {
            control.setHref(url);
            control.setTarget("new");
        }
        this.getChildren().add(control);
        return control;
    }

    private void determineDeploymentStatus(FacesContext context, NodeRef webProjectRef, String sandbox, NodeService nodeService, AVMService avmService) {
        NodeRef attempt;
        PropertyValue val = avmService.getStoreProperty(sandbox, SandboxConstants.PROP_LAST_DEPLOYMENT_ID);
        String attemptId = null;
        if (val != null && (attempt = DeploymentUtil.findDeploymentAttempt(attemptId = val.getStringValue())) != null) {
            Integer ver = (Integer)nodeService.getProperty(attempt, WCMAppModel.PROP_DEPLOYATTEMPTVERSION);
            if (ver != null) {
                this.deployAttemptVersion = ver;
            }
            List selectedServers = (List)((Object)nodeService.getProperty(attempt, WCMAppModel.PROP_DEPLOYATTEMPTSERVERS));
            int numServersSelected = 0;
            if (selectedServers != null) {
                numServersSelected = selectedServers.size();
                List deployReportRefs = nodeService.getChildAssocs(attempt, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTREPORTS, RegexQNamePattern.MATCH_ALL);
                if (deployReportRefs.size() >= numServersSelected) {
                    boolean oneOrMoreFailed = false;
                    boolean allFailed = true;
                    for (ChildAssociationRef ref : deployReportRefs) {
                        NodeRef report = ref.getChildRef();
                        Boolean successful = (Boolean)nodeService.getProperty(report, WCMAppModel.PROP_DEPLOYSUCCESSFUL);
                        if (successful == null) continue;
                        if (successful.booleanValue()) {
                            allFailed = false;
                            continue;
                        }
                        oneOrMoreFailed = true;
                    }
                    this.deployStatus = allFailed ? org.alfresco.web.app.Application.getMessage(context, "deploy_status_failed") : (oneOrMoreFailed ? org.alfresco.web.app.Application.getMessage(context, "deploy_status_partial") : org.alfresco.web.app.Application.getMessage(context, "deploy_status_live"));
                } else {
                    this.deployStatus = org.alfresco.web.app.Application.getMessage(context, "deploy_status_in_progress");
                }
            }
        }
    }

    private AVMService getAVMService(FacesContext fc) {
        return (AVMService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc).getBean("AVMLockingAwareService");
    }

    private SandboxService getSandboxService(FacesContext fc) {
        return (SandboxService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc).getBean("SandboxService");
    }

    public String getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = (String)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDateFilter() {
        ValueBinding vb = this.getValueBinding("dateFilter");
        if (vb != null) {
            this.dateFilter = (String)vb.getValue(this.getFacesContext());
        }
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }
}

