/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetInfoImpl;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.forms.Form;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIMenu;
import org.alfresco.web.ui.common.converter.ByteSizeConverter;
import org.alfresco.web.ui.repo.component.UIActions;
import org.alfresco.web.ui.wcm.component.UIAVMLockIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.ConstantMethodBinding;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIUserSandboxes
extends SelfRenderingComponent
implements Serializable {
    private static final long serialVersionUID = 362170364310941059L;
    private static Log logger = LogFactory.getLog(UIUserSandboxes.class);
    private static final String ACT_FIND_FORM_CONTENT = "find_form_content";
    private static final String ACT_CREATE_FORM_CONTENT = "create_form_content";
    private static final String ACT_SANDBOX_REVERTSELECTED = "sandbox_revertselected";
    private static final String ACT_SANDBOX_SUBMITSELECTED = "sandbox_submitselected";
    private static final String ACT_SANDBOX_BROWSE = "sandbox_browse";
    private static final String ACT_SANDBOX_REVERTALL = "sandbox_revertall";
    private static final String ACT_SANDBOX_SUBMITALL = "sandbox_submitall";
    private static final String ACT_SANDBOX_PREVIEW = "sandbox_preview";
    private static final String ACT_SANDBOX_ICON = "sandbox_icon";
    private static final String ACT_REMOVE_SANDBOX = "sandbox_remove";
    private static final String ACT_SANDBOX_REFRESH = "sandbox_refresh";
    private static final String ACT_SANDBOX_DEPLOY = "sandbox_deploy";
    private static final String ACT_SANDBOX_DEPLOY_REPORT = "deployment_report_action";
    private static final String ACT_SANDBOX_RELEASE_SERVER = "sandbox_release_test_server";
    private static final String ACTIONS_FILE = "avm_file_modified";
    private static final String ACTIONS_FOLDER = "avm_folder_modified";
    private static final String ACTIONS_DELETED = "avm_deleted_modified";
    private static final String COMPONENT_ACTIONS = "org.alfresco.faces.Actions";
    private static final String PANEL_MODIFIED = "_items";
    private static final String PANEL_FORMS = "_forms";
    private static final String MSG_MODIFIED_ITEMS = "modified_items";
    private static final String MSG_CONTENT_FORMS = "content_forms";
    private static final String MSG_SIZE = "size";
    private static final String MSG_CREATED = "created_date";
    private static final String MSG_USERNAME = "sandbox_user";
    private static final String MSG_NAME = "name";
    private static final String MSG_TITLE = "title";
    private static final String MSG_DESCRIPTION = "description";
    private static final String MSG_MODIFIED = "modified_date";
    private static final String MSG_ACTIONS = "actions";
    private static final String MSG_DELETED_ITEM = "avm_node_deleted";
    private static final String MSG_SELECTED = "selected";
    private static final String MSG_NO_MODIFIED_ITEMS = "sandbox_no_modified_items";
    private static final String MSG_NO_WEB_FORMS = "sandbox_no_web_forms";
    private static final String MSG_MY_SANDBOX = "sandbox_my_sandbox";
    private static final String MSG_COUNT_CONFLICTED_ITEMS = "count_conflicted_items";
    private static final String MSG_REVERT_ALL_CONFLICTS = "revert_all_conflicts";
    private static final String REQUEST_FORM_REF = "formref";
    private static final String REQUEST_PREVIEW_REF = "prevhref";
    private static final String REQUEST_UPDATE_TEST_SERVER = "updatetestserver";
    private static final String SPACE_ICON = "/images/icons/space_small.gif";
    private static final String CONFLICTED_ICON = "/images/icons/conflict-16.gif";
    public static final String PARAM_FORM_NAME = "form-name";
    private static final String SCRIPT_MULTISELECT = "<script>function _sb_select(obj) {var p = obj.value + '_';var b = document.getElementsByTagName('input');for (var i=0; i<b.length; i++) {  if (b[i].value.indexOf(p, 0) != -1) {    b[i].checked = obj.checked;\r\n  }}}</script>";
    private NodeRef value;
    private String webapp;
    private transient ByteSizeConverter sizeConverter = null;
    private Set<String> expandedPanels = new HashSet<String>();
    private Map<Integer, String> userToRowLookup = new HashMap<Integer, String>(8, 1.0f);
    private Map<String, Integer> rowToUserLookup = new HashMap<String, Integer>(8, 1.0f);
    private Map<String, List<AVMNodeDescriptor>> userNodes = new HashMap<String, List<AVMNodeDescriptor>>(8, 1.0f);
    private String[] checkedItems = null;
    private List<Form> forms = null;

    public String getFamily() {
        return "org.alfresco.faces.UserSandboxes";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (NodeRef)values[1];
        this.expandedPanels = (Set)values[2];
        this.userToRowLookup = (Map)values[3];
        this.rowToUserLookup = (Map)values[4];
        this.userNodes = (Map)values[5];
        this.checkedItems = (String[])values[6];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.value, this.expandedPanels, this.userToRowLookup, this.rowToUserLookup, this.userNodes, this.checkedItems};
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void decode(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Map valuesMap = context.getExternalContext().getRequestParameterValuesMap();
        String fieldId = this.getClientId(context) + PANEL_FORMS;
        String value = (String)requestMap.get(fieldId);
        if (value == null || value.length() == 0) {
            fieldId = this.getClientId(context) + PANEL_MODIFIED;
            value = (String)requestMap.get(fieldId);
        }
        if (value != null && value.length() != 0) {
            if (this.expandedPanels.contains(value)) {
                this.expandedPanels.remove(value);
            } else {
                this.expandedPanels.add(value);
            }
        }
        this.checkedItems = (String[])valuesMap.get(this.getClientId(context));
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        this.rowToUserLookup.clear();
        this.userToRowLookup.clear();
        this.userNodes.clear();
        this.forms = null;
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(context);
        SandboxService sbService = this.getSandboxService(context);
        WebProjectService wpService = this.getWebProjectService(context);
        NodeService nodeService = this.getNodeService(context);
        PermissionService permissionService = this.getPermissionService(context);
        AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(context, "AVMBrowseBean");
        boolean showAllSandboxes = avmBrowseBean.getShowAllSandboxes();
        UserTransaction tx = null;
        try {
            List<UserRoleWrapper> userRoleWrappers;
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            NodeRef websiteRef = this.getValue();
            if (websiteRef == null) {
                throw new IllegalArgumentException("Website NodeRef must be specified.");
            }
            String storeRoot = (String)((Object)nodeService.getProperty(websiteRef, WCMAppModel.PROP_AVMSTORE));
            User currentUser = org.alfresco.web.app.Application.getCurrentUser(context);
            String currentUserName = currentUser.getUserName();
            String currentUserRole = wpService.getWebUserRole(websiteRef, currentUserName);
            if (showAllSandboxes) {
                HashMap<String, String> userRoles = null;
                if (currentUserRole.equals("ContentManager") || currentUserRole.equals("ContentPublisher")) {
                    Map allUserRoles = wpService.listWebUsers(websiteRef);
                    WebProjectInfo wpInfo = wpService.getWebProject(websiteRef);
                    List sbInfos = sbService.listSandboxes(wpInfo.getStoreId());
                    userRoles = new HashMap(sbInfos.size());
                    for (SandboxInfo sbInfo : sbInfos) {
                        if (!sbInfo.getSandboxType().equals((Object)SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN)) continue;
                        userRoles.put(sbInfo.getName(), (String)allUserRoles.get(sbInfo.getName()));
                    }
                } else {
                    userRoles = new HashMap<String, String>(1);
                    userRoles.put(currentUserName, currentUserRole);
                }
                userRoleWrappers = UIUserSandboxes.buildSortedUserRoles(nodeService, currentUserName, userRoles);
            } else {
                userRoleWrappers = UIUserSandboxes.buildCurrentUserRole(wpService, websiteRef, currentUserName);
            }
            boolean deployServersConfigured = false;
            List deployToServers = Repository.getServiceRegistry(context).getDeploymentService().findTestDeploymentServers(websiteRef, false);
            if (deployToServers != null && deployToServers.size() > 0) {
                deployServersConfigured = true;
            }
            out.write(SCRIPT_MULTISELECT);
            int index = 0;
            for (UserRoleWrapper wrapper : userRoleWrappers) {
                List<NodeRef> testServers;
                String username = wrapper.UserName;
                String userrole = wrapper.UserRole;
                this.userToRowLookup.put(index, username);
                this.rowToUserLookup.put(username, index);
                String mainStore = AVMUtil.buildUserMainStoreName(storeRoot, username);
                if (sbService.getSandbox(mainStore) == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checking user role to view store: " + mainStore));
                }
                if ((!showAllSandboxes || !currentUserName.equals(username) && !"ContentManager".equals(currentUserRole) && !"ContentPublisher".equals(currentUserRole)) && showAllSandboxes) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Building sandbox view for user store: " + mainStore));
                }
                boolean hasAllocatedTestServer = !(testServers = DeploymentUtil.findAllocatedTestServers(mainStore)).isEmpty();
                List<NodeRef> deployAttempts = DeploymentUtil.findDeploymentAttempts(mainStore);
                boolean hasPreviousDeployments = deployAttempts.size() > 0;
                PanelGenerator.generatePanelStart((Writer)out, context.getExternalContext().getRequestContextPath(), "innerwhite", "white");
                out.write("<table cellspacing=2 cellpadding=2 border=0 width=100%><tr><td>");
                UIActionLink browseAction = this.aquireAction(context, mainStore, username, ACT_SANDBOX_ICON, "/images/icons/user_sandbox_large.gif", "#{AVMBrowseBean.setupSandboxAction}", "browseSandbox");
                browseAction.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_BROWSE) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                browseAction.setShowLink(false);
                Utils.encodeRecursive(context, (UIComponent)browseAction);
                out.write("</td><td width=100%>");
                if (!wrapper.IsCurrentUser) {
                    out.write("<b>");
                    out.write(bundle.getString(MSG_USERNAME));
                    out.write(":</b>&nbsp;");
                    out.write(Utils.encode((String)username));
                } else {
                    out.write("<b>");
                    out.write(bundle.getString(MSG_MY_SANDBOX));
                    out.write("</b>");
                }
                out.write(" (");
                out.write(bundle.getString(userrole));
                out.write(")</td><td><table cellpadding='4' cellspacing='0'><tr><td><nobr>");
                UIActionLink action = this.aquireAction(context, mainStore, username, ACT_SANDBOX_BROWSE, SPACE_ICON, "#{AVMBrowseBean.setupSandboxAction}", "browseSandbox");
                action.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_BROWSE) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                Utils.encodeRecursive(context, (UIComponent)action);
                out.write("</nobr></td><td><nobr>");
                String websiteUrl = AVMUtil.getPreviewURI(mainStore, "/www/avm_webapps/" + this.getWebapp());
                Map requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(REQUEST_PREVIEW_REF, websiteUrl);
                action = this.aquireAction(context, mainStore, username, ACT_SANDBOX_PREVIEW, "/images/icons/preview_website.gif", null, null, "#{prevhref}", null);
                action.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_PREVIEW) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                Utils.encodeRecursive(context, (UIComponent)action);
                requestMap.remove(REQUEST_PREVIEW_REF);
                out.write("</nobr></td><td><nobr>");
                action = this.aquireAction(context, mainStore, username, ACT_SANDBOX_SUBMITALL, "/images/icons/submit_all.gif", "#{AVMBrowseBean.setupAllItemsAction}", "dialog:submitSandboxItems");
                action.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_SUBMITALL) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                Utils.encodeRecursive(context, (UIComponent)action);
                out.write("</nobr></td><td><nobr>");
                action = this.aquireAction(context, mainStore, username, ACT_SANDBOX_REVERTALL, "/images/icons/revert_all.gif", "#{AVMBrowseBean.setupAllItemsAction}", "dialog:revertAllItems");
                action.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_REVERTALL) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                Utils.encodeRecursive(context, (UIComponent)action);
                out.write("</nobr></td><td><nobr>");
                UIMenu menu = this.findMenu(mainStore);
                if (menu == null) {
                    menu = this.createMenu(context, mainStore);
                    menu.setTooltip(org.alfresco.web.app.Application.getMessage(context, "more_actions") + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                    this.getChildren().add(menu);
                }
                menu.getChildren().clear();
                if (deployServersConfigured) {
                    HashMap<String, String> dialogParams = new HashMap<String, String>(6);
                    dialogParams.put("store", mainStore);
                    dialogParams.put("username", username);
                    requestMap.put(REQUEST_UPDATE_TEST_SERVER, Boolean.toString(hasAllocatedTestServer));
                    dialogParams.put("updateTestServer", "#{updatetestserver}");
                    UIActionLink deploy = this.createAction(context, mainStore, username, ACT_SANDBOX_DEPLOY, "/images/icons/deploy.gif", "#{DialogManager.setupParameters}", "dialog:deployWebsite", null, dialogParams, false);
                    deploy.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_DEPLOY) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                    menu.getChildren().add(deploy);
                }
                if (hasPreviousDeployments) {
                    UIActionLink reports = this.createAction(context, mainStore, username, ACT_SANDBOX_DEPLOY_REPORT, "/images/icons/deployment_report.gif", "#{DialogManager.setupParameters}", "dialog:viewDeploymentReport", null, null, false);
                    reports.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_DEPLOY_REPORT) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                    menu.getChildren().add(reports);
                }
                if (hasAllocatedTestServer) {
                    UIActionLink releaseServer = this.createAction(context, mainStore, username, ACT_SANDBOX_RELEASE_SERVER, "/images/icons/release_server.gif", "#{DialogManager.setupParameters}", "dialog:releaseTestServer", null, null, false);
                    releaseServer.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_RELEASE_SERVER) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                    menu.getChildren().add(releaseServer);
                }
                UIActionLink refresh = this.createAction(context, mainStore, username, ACT_SANDBOX_REFRESH, "/images/icons/reset.gif", "#{AVMBrowseBean.refreshSandbox}", null, null, null, false);
                refresh.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_SANDBOX_REFRESH) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                menu.getChildren().add(refresh);
                if ("ContentManager".equals(currentUserRole)) {
                    UIActionLink delete = this.createAction(context, mainStore, username, ACT_REMOVE_SANDBOX, "/images/icons/delete_sandbox.gif", "#{AVMBrowseBean.setupSandboxAction}", "dialog:deleteSandbox", null, null, false);
                    delete.setTooltip(org.alfresco.web.app.Application.getMessage(context, ACT_REMOVE_SANDBOX) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")");
                    menu.getChildren().add(delete);
                }
                Utils.encodeRecursive(context, (UIComponent)menu);
                out.write("</nobr></td></tr></table></td></tr>");
                out.write("<tr><td></td><td colspan=2>");
                String panelImage = "/images/icons/collapsed.gif";
                if (this.expandedPanels.contains(username + PANEL_MODIFIED)) {
                    panelImage = "/images/icons/expanded.gif";
                }
                String title = org.alfresco.web.app.Application.getMessage(context, MSG_MODIFIED_ITEMS) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")";
                String submitScript = Utils.generateFormSubmit(context, (UIComponent)this, this.getClientId(context) + PANEL_MODIFIED, username + PANEL_MODIFIED);
                out.write("<a href=\"#\" tabIndex=\"0\" onclick=\"" + submitScript + "\">");
                out.write(Utils.buildImageTag(context, panelImage, 11, 11, title));
                out.write("</a>");
                out.write("&nbsp;<b title=\"" + title + "\">");
                out.write(bundle.getString(MSG_MODIFIED_ITEMS));
                out.write("</b>");
                if (this.expandedPanels.contains(username + PANEL_MODIFIED)) {
                    out.write("<div style='padding:2px'></div>");
                    this.renderUserFiles(context, out, username, storeRoot, index);
                }
                out.write("</td></tr>");
                if (permissionService.hasPermission(AVMNodeConverter.ToNodeRef((int)-1, (String)AVMUtil.buildSandboxRootPath(mainStore)), "AddChildren") == AccessStatus.ALLOWED) {
                    out.write("<tr style='padding-top:4px'><td></td><td colspan=2>");
                    panelImage = "/images/icons/collapsed.gif";
                    if (this.expandedPanels.contains(username + PANEL_FORMS)) {
                        panelImage = "/images/icons/expanded.gif";
                    }
                    title = org.alfresco.web.app.Application.getMessage(context, MSG_CONTENT_FORMS) + " (" + username + " " + org.alfresco.web.app.Application.getMessage(context, "sandbox_title_extension") + ")";
                    submitScript = Utils.generateFormSubmit(context, (UIComponent)this, this.getClientId(context) + PANEL_FORMS, username + PANEL_FORMS);
                    out.write("<a href=\"#\" tabIndex=\"0\" onclick=\"" + submitScript + "\">");
                    out.write(Utils.buildImageTag(context, panelImage, 11, 11, title));
                    out.write("</a>");
                    out.write("&nbsp;<b title=\"" + title + "\">");
                    out.write(bundle.getString(MSG_CONTENT_FORMS));
                    out.write("</b>");
                    if (this.expandedPanels.contains(username + PANEL_FORMS)) {
                        out.write("<div style='padding:2px'></div>");
                        this.renderContentForms(context, out, websiteRef, username, storeRoot);
                    }
                    out.write("</td></tr>");
                }
                out.write("</table>");
                PanelGenerator.generatePanelEnd((Writer)out, context.getExternalContext().getRequestContextPath(), "innerwhite");
                if (index++ >= userRoleWrappers.size() - 1) continue;
                out.write("<div style='padding:4px'></div>");
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            throw new RuntimeException(err);
        }
    }

    private static List<UserRoleWrapper> buildSortedUserRoles(NodeService nodeService, String currentUser, Map<String, String> userRoles) {
        UserRoleWrapper currentUserWrapper = null;
        LinkedList<UserRoleWrapper> wrappers = new LinkedList<UserRoleWrapper>();
        for (Map.Entry<String, String> userRole : userRoles.entrySet()) {
            String username = userRole.getKey();
            String userrole = userRole.getValue();
            UserRoleWrapper wrapper = new UserRoleWrapper(username, userrole);
            if (currentUser.equals(username)) {
                wrapper.IsCurrentUser = true;
                currentUserWrapper = wrapper;
                continue;
            }
            wrappers.add(wrapper);
        }
        QuickSort sorter = new QuickSort(wrappers, "UserName", true, "case-insensitive");
        sorter.sort();
        if (currentUserWrapper != null) {
            wrappers.add(0, currentUserWrapper);
        }
        return wrappers;
    }

    private static List<UserRoleWrapper> buildCurrentUserRole(WebProjectService wpService, NodeRef webProjectRef, String username) {
        ArrayList<UserRoleWrapper> wrappers = new ArrayList<UserRoleWrapper>(0);
        String userrole = wpService.getWebUserRole(webProjectRef, username);
        if (userrole != null) {
            wrappers = new ArrayList(1);
            UserRoleWrapper wrapper = new UserRoleWrapper(username, userrole);
            wrapper.IsCurrentUser = true;
            wrappers.add(0, wrapper);
        }
        return wrappers;
    }

    private void renderUserFiles(FacesContext fc, ResponseWriter out, String username, String storeRoot, int index) throws IOException {
        PermissionService permissionService = this.getPermissionService(fc);
        SandboxService sandboxService = this.getSandboxService(fc);
        DateFormat df = Utils.getDateTimeFormat(fc);
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(fc);
        String userStore = AVMUtil.buildUserMainStoreName(storeRoot, username);
        String userStorePath = AVMUtil.buildStoreWebappPath(userStore, this.getWebapp());
        String stagingStore = AVMUtil.buildStagingStoreName(storeRoot);
        String stagingStorePath = AVMUtil.buildStoreWebappPath(stagingStore, this.getWebapp());
        long start = System.currentTimeMillis();
        List assets = sandboxService.listChangedWebApp(userStore, this.getWebapp(), true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("List " + assets.size() + " changes webapp in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        if (assets.size() != 0) {
            start = System.currentTimeMillis();
            int diffCount = 0;
            for (AssetInfo asset : assets) {
                if (asset.getDiffCode() != 2) continue;
                ++diffCount;
            }
            if (diffCount > 0) {
                out.write("<table cellspacing=\"0\" cellpadding=\"2\"");
                out.write(" class='conflictItemsList' width=\"100%\"");
                out.write(">");
                out.write("<tr width=\"100%\">");
                out.write("<td width=\"100%\">");
                out.write(Utils.buildImageTag(fc, CONFLICTED_ICON, 16, 16, "", null, "-25%"));
                out.write("&nbsp;");
                out.write(MessageFormat.format(bundle.getString(MSG_COUNT_CONFLICTED_ITEMS), diffCount));
                out.write("</td>");
                out.write("<td>");
                Utils.encodeRecursive(fc, (UIComponent)this.createRevertAllItemsButton(fc, bundle, username, userStorePath, stagingStorePath));
                out.write("</td>");
                out.write("</tr>");
                out.write("</table>");
                out.write("<div style='padding:2px'></div>");
            }
            int rootPathIndex = AVMUtil.buildSandboxRootPath(userStore).length();
            UIActions uiFileActions = this.aquireUIActions(ACTIONS_FILE, userStore);
            UIActions uiFolderActions = this.aquireUIActions(ACTIONS_FOLDER, userStore);
            UIActions uiDeletedActions = this.aquireUIActions(ACTIONS_DELETED, userStore);
            String id = this.getClientId(fc);
            ArrayList<AVMNodeDescriptor> nodes = new ArrayList<AVMNodeDescriptor>(assets.size());
            for (AssetInfo asset : assets) {
                nodes.add(((AssetInfoImpl)asset).getAVMNodeDescriptor());
            }
            this.userNodes.put(username, nodes);
            out.write("<table class='modifiedItemsList' cellspacing=0 cellpadding=2 border=0 width=100%>");
            out.write("<tr><td colspan=8>");
            out.write(bundle.getString(MSG_SELECTED));
            out.write(":&nbsp;&nbsp;");
            NodeRef userStoreRef = AVMNodeConverter.ToNodeRef((int)-1, (String)AVMUtil.buildSandboxRootPath(userStore));
            if (permissionService.hasPermission(userStoreRef, "Write") == AccessStatus.ALLOWED || permissionService.hasPermission(userStoreRef, "AddChildren") == AccessStatus.ALLOWED) {
                Utils.encodeRecursive(fc, (UIComponent)this.aquireAction(fc, userStore, username, ACT_SANDBOX_SUBMITSELECTED, "/images/icons/submit_all.gif", "#{AVMBrowseBean.setupSandboxAction}", "dialog:submitSandboxItems"));
                out.write("&nbsp;&nbsp;");
                Utils.encodeRecursive(fc, (UIComponent)this.aquireAction(fc, userStore, username, ACT_SANDBOX_REVERTSELECTED, "/images/icons/revert_all.gif", "#{AVMBrowseBean.setupSandboxAction}", "dialog:revertSelectedItems"));
            }
            out.write("</td></tr>");
            out.write("<tr align=left><th>");
            out.write("<input type='checkbox' value='");
            out.write(Integer.toString(index));
            out.write("' onclick='");
            out.write("javascript:_sb_select(this);");
            out.write("'></th><th></th><th></th><th></th><th>");
            out.write(bundle.getString(MSG_NAME));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_CREATED));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_MODIFIED));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_SIZE));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_ACTIONS));
            out.write("</th></tr>");
            ArrayList assetsCopy = new ArrayList(assets);
            if (diffCount > 0) {
                ArrayList<AssetInfo> conflicted = new ArrayList<AssetInfo>();
                Iterator it = assets.iterator();
                while (it.hasNext()) {
                    AssetInfo diff = (AssetInfo)it.next();
                    if (diff.getDiffCode() != 2) continue;
                    conflicted.add(diff);
                    it.remove();
                }
                assets.addAll(0, conflicted);
            }
            int rowIndex = 0;
            for (AssetInfo node : assets) {
                String name;
                boolean isGhost = node.isDeleted();
                String sourcePath = node.getAvmPath();
                out.write("<tr");
                if (node.getDiffCode() == 2) {
                    out.write(" class='conflictItem'");
                }
                out.write("><td><input type='checkbox' name='");
                out.write(id);
                out.write("' id='");
                out.write(id);
                out.write("' value='");
                out.write(Integer.toString(index) + '_' + Integer.toString(assetsCopy.indexOf(node)));
                out.write("'></td>");
                ++rowIndex;
                if (!isGhost) {
                    name = node.getName();
                    String linkPrefix = "<a href=\"" + fc.getExternalContext().getRequestContextPath() + DownloadContentServlet.generateBrowserURL(AVMNodeConverter.ToNodeRef((int)-1, (String)sourcePath), name) + "\" target='new'>";
                    if (node.isFile()) {
                        out.write("<td width=16>");
                        if (node.getDiffCode() == 2) {
                            out.write(Utils.buildImageTag(fc, CONFLICTED_ICON, 16, 16, ""));
                        }
                        out.write("</td><td width=20>");
                        UIAVMLockIcon lockIcon = (UIAVMLockIcon)fc.getApplication().createComponent("org.alfresco.faces.AVMLockIcon");
                        lockIcon.setId("avmlock_" + Integer.toString(rowIndex));
                        lockIcon.setValue(node);
                        Utils.encodeRecursive(fc, (UIComponent)lockIcon);
                        out.write("</td><td width=16>");
                        out.write(linkPrefix);
                        out.write(Utils.buildImageTag(fc, FileTypeImageUtils.getFileTypeImage((FacesContext)fc, (String)name, (boolean)true), ""));
                        out.write("</a>");
                        out.write("</td><td>");
                        out.write(linkPrefix);
                        out.write(Utils.encode((String)name));
                        out.write("</a>");
                    } else {
                        out.write("<td width=16></td>");
                        out.write("<td width=20></td>");
                        out.write("<td width=16>");
                        out.write(Utils.buildImageTag(fc, SPACE_ICON, 16, 16, ""));
                        out.write("</td><td>");
                        out.write(Utils.encode((String)name));
                    }
                    out.write("</td><td>");
                    out.write(df.format(node.getCreatedDate()));
                    out.write("</td><td>");
                    out.write(df.format(node.getModifiedDate()));
                    out.write("</td><td>");
                    AVMNode avmNode = new AVMNode(node);
                    String assetPath = sourcePath.substring(rootPathIndex);
                    String previewUrl = AVMUtil.getPreviewURI(userStore, "/www/avm_webapps" + assetPath);
                    avmNode.getProperties().put("previewUrl", previewUrl);
                    avmNode.getProperties().put("avmDiff", node.getDiffCode());
                    if (node.isFile()) {
                        out.write(this.getSizeConverter().getAsString(fc, (UIComponent)this, node.getFileSize()));
                        out.write("</td><td>");
                        uiFileActions.setContext(avmNode);
                        Utils.encodeRecursive(fc, (UIComponent)uiFileActions);
                    } else {
                        out.write("</td><td>");
                        uiFolderActions.setContext(avmNode);
                        Utils.encodeRecursive(fc, (UIComponent)uiFolderActions);
                    }
                } else {
                    name = node.getName();
                    out.write("<td width=16></td>");
                    out.write("<td width=20></td>");
                    out.write("<td width=16>");
                    if (node.isFile() && node.isDeleted()) {
                        out.write(Utils.buildImageTag(fc, FileTypeImageUtils.getFileTypeImage((FacesContext)fc, (String)name, (boolean)true), ""));
                        out.write("</td><td style='color:#aaaaaa'>");
                        out.write(Utils.encode((String)name) + " [" + bundle.getString(MSG_DELETED_ITEM) + "]");
                        out.write("</a>");
                    } else {
                        out.write(Utils.buildImageTag(fc, SPACE_ICON, 16, 16, ""));
                        out.write("</td><td style='color:#aaaaaa'>");
                        out.write(Utils.encode((String)name) + " [" + bundle.getString(MSG_DELETED_ITEM) + "]");
                    }
                    out.write("</td><td style='color:#aaaaaa'>");
                    out.write(df.format(node.getCreatedDate()));
                    out.write("</td><td style='color:#aaaaaa'>");
                    out.write(df.format(node.getModifiedDate()));
                    out.write("</td><td style='color:#aaaaaa'>");
                    if (node.isFile()) {
                        out.write(this.getSizeConverter().getAsString(fc, (UIComponent)this, node.getFileSize()));
                    }
                    out.write("</td><td style='color:#aaaaaa'>");
                    uiDeletedActions.setContext(new AVMNode(node));
                    Utils.encodeRecursive(fc, (UIComponent)uiDeletedActions);
                }
                out.write("</td></tr>");
            }
            out.write("</table>");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Wrote table in " + (System.currentTimeMillis() - start) + " msecs"));
            }
        } else {
            out.write("<div style='padding-left:16px'><i>");
            out.write(bundle.getString(MSG_NO_MODIFIED_ITEMS));
            out.write("</i></div>");
        }
    }

    private void renderContentForms(FacesContext fc, ResponseWriter out, NodeRef websiteRef, String username, String storeRoot) throws IOException {
        Map requestMap = fc.getExternalContext().getRequestMap();
        String userStorePrefix = AVMUtil.buildUserMainStoreName(storeRoot, username);
        if (this.forms == null) {
            this.forms = new WebProject(websiteRef).getForms();
        }
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(fc);
        if (this.forms.size() != 0) {
            out.write("<table class='modifiedItemsList' cellspacing='2' cellpadding='1' border='0' width='100%'>");
            out.write("<tr align='left'><th>");
            out.write(bundle.getString(MSG_NAME));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_TITLE));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_DESCRIPTION));
            out.write("</th><th>");
            out.write(bundle.getString(MSG_ACTIONS));
            out.write("</th></tr>");
            for (Form f : this.forms) {
                HashMap<String, String> params;
                out.write("<tr><td>");
                String name = f.getName();
                out.write(name != null ? Utils.encode((String)name) : "");
                out.write("</td><td>");
                String title = f.getTitle();
                out.write(title != null ? Utils.encode((String)title) : "");
                out.write("</td><td>");
                String desc = f.getDescription();
                out.write(desc != null ? Utils.encode((String)desc) : "");
                out.write("</td><td>");
                requestMap.put(REQUEST_FORM_REF, f);
                UIActionLink action = this.findAction(ACT_CREATE_FORM_CONTENT, userStorePrefix);
                if (action == null) {
                    params = new HashMap<String, String>(4, 1.0f);
                    params.put(PARAM_FORM_NAME, "#{formref.name}");
                    params.put("username", username);
                    params.put("store", userStorePrefix);
                    action = this.createAction(fc, userStorePrefix, username, ACT_CREATE_FORM_CONTENT, "/images/icons/new_content.gif", "#{AVMBrowseBean.createFormContent}", null, null, params, true);
                }
                Utils.encodeRecursive(fc, (UIComponent)action);
                out.write("&nbsp;&nbsp;");
                action = this.findAction(ACT_FIND_FORM_CONTENT, userStorePrefix);
                if (action == null) {
                    params = new HashMap(4, 1.0f);
                    params.put(PARAM_FORM_NAME, "#{formref.name}");
                    params.put("username", username);
                    params.put("store", userStorePrefix);
                    action = this.createAction(fc, userStorePrefix, username, ACT_FIND_FORM_CONTENT, "/images/icons/search_icon.gif", "#{AVMBrowseBean.searchFormContent}", "browseSandbox", null, params, true);
                }
                Utils.encodeRecursive(fc, (UIComponent)action);
                requestMap.remove(REQUEST_FORM_REF);
                out.write("</td></tr>");
            }
            out.write("</table>");
        } else {
            out.write("<div style='padding-left:16px'><i>");
            out.write(bundle.getString(MSG_NO_WEB_FORMS));
            out.write("</i></div>");
        }
    }

    private ByteSizeConverter getSizeConverter() {
        if (this.sizeConverter == null) {
            this.sizeConverter = new ByteSizeConverter();
        }
        return this.sizeConverter;
    }

    private UIActions aquireUIActions(String id, String store) {
        UIActions uiActions = null;
        String componentId = id + '_' + FacesHelper.makeLegalId(store);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Find UIActions component id: " + componentId));
        }
        for (UIComponent component : this.getChildren()) {
            if (!componentId.equals(component.getId())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("...found UIActions component id: " + componentId));
            }
            uiActions = (UIActions)component;
            break;
        }
        if (uiActions == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("...creating UIActions component id: " + componentId));
            }
            Application facesApp = FacesContext.getCurrentInstance().getApplication();
            uiActions = (UIActions)facesApp.createComponent(COMPONENT_ACTIONS);
            uiActions.setShowLink(false);
            uiActions.getAttributes().put("styleClass", "inlineAction");
            uiActions.setId(componentId);
            uiActions.setParent((UIComponent)this);
            uiActions.setValue(id);
            this.getChildren().add(uiActions);
        }
        return uiActions;
    }

    private UIActionLink aquireAction(FacesContext fc, String store, String username, String name, String icon, String actionListener, String outcome) {
        return this.aquireAction(fc, store, username, name, icon, actionListener, outcome, null, null);
    }

    private HtmlCommandButton createRevertAllItemsButton(FacesContext fc, ResourceBundle bundle, String name, String userStorePath, String stagingStorePath) {
        Application facesApp = fc.getApplication();
        String id = "revert_all_conflict" + new Date().getTime() + FacesHelper.makeLegalId(name);
        HtmlCommandButton cb = (HtmlCommandButton)facesApp.createComponent("javax.faces.HtmlCommandButton");
        cb.setId(id);
        cb.setValue((Object)bundle.getString(MSG_REVERT_ALL_CONFLICTS));
        cb.setActionListener(facesApp.createMethodBinding("#{AVMBrowseBean.revertAllConflict}", UIActions.ACTION_CLASS_ARGS));
        UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
        param.setId(id + "_1");
        param.setName("userStorePath");
        param.setValue((Object)userStorePath);
        cb.getChildren().add(param);
        param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
        param.setId(id + "_2");
        param.setName("stagingStorePath");
        param.setValue((Object)stagingStorePath);
        cb.getChildren().add(param);
        this.getChildren().add(cb);
        return cb;
    }

    private UIActionLink aquireAction(FacesContext fc, String store, String username, String name, String icon, String actionListener, String outcome, String url, Map<String, String> params) {
        UIActionLink action = this.findAction(name, store);
        if (action == null) {
            action = this.createAction(fc, store, username, name, icon, actionListener, outcome, url, params, true);
        }
        return action;
    }

    private UIActionLink findAction(String name, String store) {
        UIActionLink action = null;
        String actionId = name + '_' + FacesHelper.makeLegalId(store);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding action Id: " + actionId));
        }
        for (UIComponent component : this.getChildren()) {
            if (!actionId.equals(component.getId())) continue;
            action = (UIActionLink)component;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("...found action Id: " + actionId));
            break;
        }
        return action;
    }

    private UIActionLink createAction(FacesContext fc, String store, String username, String name, String icon, String actionListener, String outcome, String url, Map<String, String> params, boolean addAsChild) {
        Application facesApp = fc.getApplication();
        UIActionLink control = (UIActionLink)facesApp.createComponent("org.alfresco.faces.ActionLink");
        String id = name + '_' + FacesHelper.makeLegalId(store);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("...creating action Id: " + id));
        }
        control.setRendererType("org.alfresco.faces.ActionLinkRenderer");
        control.setId(id);
        control.setValue(org.alfresco.web.app.Application.getMessage(fc, name));
        control.setImage(icon);
        if (actionListener != null) {
            control.setActionListener(facesApp.createMethodBinding(actionListener, UIActions.ACTION_CLASS_ARGS));
            if (params == null) {
                UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                param.setId(id + "_1");
                param.setName("store");
                param.setValue((Object)store);
                control.getChildren().add(param);
                param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                param.setId(id + "_2");
                param.setName("username");
                param.setValue((Object)username);
                control.getChildren().add(param);
            } else {
                int idIndex = 1;
                for (String key : params.keySet()) {
                    UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                    param.setId(id + '_' + Integer.toString(idIndex++));
                    param.setName(key);
                    String value = params.get(key);
                    if (value.startsWith("#{")) {
                        ValueBinding vb = facesApp.createValueBinding(value);
                        param.setValueBinding("value", vb);
                    } else {
                        param.setValue((Object)params.get(key));
                    }
                    control.getChildren().add(param);
                }
            }
        }
        if (outcome != null) {
            control.setAction((MethodBinding)new ConstantMethodBinding(outcome));
        }
        if (url != null) {
            if (url.startsWith("#{")) {
                ValueBinding vb = facesApp.createValueBinding(url);
                control.setValueBinding("href", vb);
            } else {
                control.setHref(url);
            }
            control.setTarget("new");
        }
        if (addAsChild) {
            this.getChildren().add(control);
        }
        return control;
    }

    private UIMenu findMenu(String store) {
        UIMenu menu = null;
        String menuId = "menu_" + FacesHelper.makeLegalId(store);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding action Id: " + menuId));
        }
        for (UIComponent component : this.getChildren()) {
            if (!menuId.equals(component.getId())) continue;
            menu = (UIMenu)component;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("...found action Id: " + menuId));
            break;
        }
        return menu;
    }

    private UIMenu createMenu(FacesContext context, String store) {
        UIMenu menu = (UIMenu)context.getApplication().createComponent("org.alfresco.faces.Menu");
        String id = "menu_" + FacesHelper.makeLegalId(store);
        menu.setId(id);
        menu.setLabel(org.alfresco.web.app.Application.getMessage(context, "more_actions") + " ");
        menu.getAttributes().put("itemSpacing", 4);
        menu.getAttributes().put("image", "/images/icons/menu.gif");
        menu.getAttributes().put("menuStyleClass", "moreActionsMenu");
        menu.getAttributes().put("style", "white-space:nowrap; margin-left: 4px; margin-right: 6px;");
        return menu;
    }

    private WebProjectService getWebProjectService(FacesContext fc) {
        return Repository.getServiceRegistry(fc).getWebProjectService();
    }

    private NodeService getNodeService(FacesContext fc) {
        return Repository.getServiceRegistry(fc).getNodeService();
    }

    private PermissionService getPermissionService(FacesContext fc) {
        return Repository.getServiceRegistry(fc).getPermissionService();
    }

    private SandboxService getSandboxService(FacesContext fc) {
        return Repository.getServiceRegistry(fc).getSandboxService();
    }

    public NodeRef getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = (NodeRef)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(NodeRef value) {
        this.value = value;
    }

    public String getWebapp() {
        ValueBinding vb = this.getValueBinding("webapp");
        if (vb != null) {
            this.webapp = (String)vb.getValue(this.getFacesContext());
        }
        return this.webapp;
    }

    public void setWebapp(String webapp) {
        this.webapp = webapp;
    }

    public List<AVMNodeDescriptor> getSelectedNodes(String username) {
        return this.getSelectedNodes(username, this.rowToUserLookup.get(username));
    }

    public List<AVMNodeDescriptor> getSelectedNodes(int sandbox) {
        return this.getSelectedNodes(this.userToRowLookup.get(sandbox), sandbox);
    }

    private List<AVMNodeDescriptor> getSelectedNodes(String username, int sandbox) {
        List<AVMNodeDescriptor> paths;
        ArrayList<AVMNodeDescriptor> nodes = null;
        if (username != null && this.checkedItems != null && (paths = this.userNodes.get(username)) != null) {
            nodes = new ArrayList<AVMNodeDescriptor>(paths.size());
            String sandboxPrefix = Integer.toString(sandbox) + '_';
            for (int i = 0; i < this.checkedItems.length; ++i) {
                String value = this.checkedItems[i];
                if (!value.startsWith(sandboxPrefix)) continue;
                int pathIndex = Integer.valueOf(value.substring(sandboxPrefix.length()));
                nodes.add(paths.get(pathIndex));
            }
        }
        return nodes;
    }

    public static class UserRoleWrapper {
        String UserName;
        String UserRole;
        boolean IsCurrentUser = false;

        UserRoleWrapper(String username, String userrole) {
            this.UserName = username;
            this.UserRole = userrole;
        }

        public String getUserName() {
            return this.UserName;
        }
    }
}

