/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ActionListenerImpl;
import org.apache.myfaces.application.NavigationHandlerImpl;
import org.apache.myfaces.application.jsp.JspStateManagerImpl;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.config.impl.digester.elements.Property;
import org.apache.myfaces.el.MethodBindingImpl;
import org.apache.myfaces.el.PropertyResolverImpl;
import org.apache.myfaces.el.ValueBindingImpl;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.shared_impl.util.BiLevelCacheMap;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class ApplicationImpl
extends Application {
    private static final Log log = LogFactory.getLog((Class)ApplicationImpl.class);
    private final Map _valueBindingCache = new BiLevelCacheMap(90){

        protected Object newInstance(Object key) {
            return new ValueBindingImpl(ApplicationImpl.this, (String)key);
        }
    };
    private Collection _supportedLocales = Collections.EMPTY_SET;
    private Locale _defaultLocale;
    private String _messageBundle;
    private ViewHandler _viewHandler;
    private NavigationHandler _navigationHandler;
    private VariableResolver _variableResolver;
    private PropertyResolver _propertyResolver;
    private ActionListener _actionListener;
    private String _defaultRenderKitId = "HTML_BASIC";
    private StateManager _stateManager;
    private final Map _converterIdToClassMap = Collections.synchronizedMap(new HashMap());
    private final Map _converterClassNameToClassMap = Collections.synchronizedMap(new HashMap());
    private final Map _converterClassNameToConfigurationMap = Collections.synchronizedMap(new HashMap());
    private final Map _componentClassMap = Collections.synchronizedMap(new HashMap());
    private final Map _validatorClassMap = Collections.synchronizedMap(new HashMap());

    public ApplicationImpl() {
        this._viewHandler = new JspViewHandlerImpl();
        this._navigationHandler = new NavigationHandlerImpl();
        this._variableResolver = new VariableResolverImpl();
        this._propertyResolver = new PropertyResolverImpl();
        this._actionListener = new ActionListenerImpl();
        this._stateManager = new JspStateManagerImpl();
        if (log.isTraceEnabled()) {
            log.trace((Object)"New Application instance created");
        }
    }

    public void setActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            log.error((Object)"setting actionListener to null is not allowed");
            throw new NullPointerException("setting actionListener to null is not allowed");
        }
        this._actionListener = actionListener;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set actionListener = " + actionListener.getClass().getName()));
        }
    }

    public ActionListener getActionListener() {
        return this._actionListener;
    }

    public Iterator getComponentTypes() {
        return this._componentClassMap.keySet().iterator();
    }

    public Iterator getConverterIds() {
        return this._converterIdToClassMap.keySet().iterator();
    }

    public Iterator getConverterTypes() {
        return this._converterClassNameToClassMap.keySet().iterator();
    }

    public void setDefaultLocale(Locale locale) {
        if (locale == null) {
            log.error((Object)"setting locale to null is not allowed");
            throw new NullPointerException("setting locale to null is not allowed");
        }
        this._defaultLocale = locale;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set defaultLocale = " + locale.getCountry() + " " + locale.getLanguage()));
        }
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public void setMessageBundle(String messageBundle) {
        if (messageBundle == null) {
            log.error((Object)"setting messageBundle to null is not allowed");
            throw new NullPointerException("setting messageBundle to null is not allowed");
        }
        this._messageBundle = messageBundle;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set MessageBundle = " + messageBundle));
        }
    }

    public String getMessageBundle() {
        return this._messageBundle;
    }

    public void setNavigationHandler(NavigationHandler navigationHandler) {
        if (navigationHandler == null) {
            log.error((Object)"setting navigationHandler to null is not allowed");
            throw new NullPointerException("setting navigationHandler to null is not allowed");
        }
        this._navigationHandler = navigationHandler;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set NavigationHandler = " + navigationHandler.getClass().getName()));
        }
    }

    public NavigationHandler getNavigationHandler() {
        return this._navigationHandler;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        if (propertyResolver == null) {
            log.error((Object)"setting propertyResolver to null is not allowed");
            throw new NullPointerException("setting propertyResolver to null is not allowed");
        }
        this._propertyResolver = propertyResolver;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set PropertyResolver = " + propertyResolver.getClass().getName()));
        }
    }

    public PropertyResolver getPropertyResolver() {
        return this._propertyResolver;
    }

    public void setSupportedLocales(Collection locales) {
        if (locales == null) {
            log.error((Object)"setting supportedLocales to null is not allowed");
            throw new NullPointerException("setting supportedLocales to null is not allowed");
        }
        this._supportedLocales = locales;
        if (log.isTraceEnabled()) {
            log.trace((Object)"set SupportedLocales");
        }
    }

    public Iterator getSupportedLocales() {
        return this._supportedLocales.iterator();
    }

    public Iterator getValidatorIds() {
        return this._validatorClassMap.keySet().iterator();
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        if (variableResolver == null) {
            log.error((Object)"setting variableResolver to null is not allowed");
            throw new NullPointerException("setting variableResolver to null is not allowed");
        }
        this._variableResolver = variableResolver;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set VariableResolver = " + variableResolver.getClass().getName()));
        }
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        if (viewHandler == null) {
            log.error((Object)"setting viewHandler to null is not allowed");
            throw new NullPointerException("setting viewHandler to null is not allowed");
        }
        this._viewHandler = viewHandler;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set ViewHandler = " + viewHandler.getClass().getName()));
        }
    }

    public ViewHandler getViewHandler() {
        return this._viewHandler;
    }

    public void addComponent(String componentType, String componentClassName) {
        if (componentType == null || componentType.length() == 0) {
            log.error((Object)"addComponent: componentType = null is not allowed");
            throw new NullPointerException("addComponent: componentType = null is not allowed");
        }
        if (componentClassName == null || componentClassName.length() == 0) {
            log.error((Object)"addComponent: component = null is not allowed");
            throw new NullPointerException("addComponent: component = null is not allowed");
        }
        try {
            this._componentClassMap.put(componentType, ClassUtils.simpleClassForName(componentClassName));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Component class = " + componentClassName + " for type = " + componentType));
            }
        }
        catch (Exception e) {
            log.error((Object)("Component class " + componentClassName + " not found"), (Throwable)e);
        }
    }

    public void addConverter(String converterId, String converterClass) {
        if (converterId == null || converterId.length() == 0) {
            log.error((Object)"addConverter: converterId = null is not allowed");
            throw new NullPointerException("addConverter: converterId = null is not allowed");
        }
        if (converterClass == null || converterClass.length() == 0) {
            log.error((Object)"addConverter: converterClass = null is not allowed");
            throw new NullPointerException("addConverter: converterClass = null is not allowed");
        }
        try {
            this._converterIdToClassMap.put(converterId, ClassUtils.simpleClassForName(converterClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Converter id = " + converterId + " converterClass = " + converterClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Converter class " + converterClass + " not found"), (Throwable)e);
        }
    }

    public void addConverter(Class targetClass, String converterClass) {
        if (targetClass == null) {
            log.error((Object)"addConverter: targetClass = null is not allowed");
            throw new NullPointerException("addConverter: targetClass = null is not allowed");
        }
        if (converterClass == null || converterClass.length() == 0) {
            log.error((Object)"addConverter: converterClass = null is not allowed");
            throw new NullPointerException("addConverter: converterClass = null is not allowed");
        }
        try {
            this._converterClassNameToClassMap.put(targetClass, converterClass);
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Converter for class = " + targetClass + " converterClass = " + converterClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Converter class " + converterClass + " not found"), (Throwable)e);
        }
    }

    public void addConverterConfiguration(String converterClassName, org.apache.myfaces.config.impl.digester.elements.Converter configuration) {
        if (converterClassName == null || converterClassName.length() == 0) {
            log.error((Object)"addConverterConfiguration: converterClassName = null is not allowed");
            throw new NullPointerException("addConverterConfiguration: converterClassName = null is not allowed");
        }
        if (configuration == null) {
            log.error((Object)"addConverterConfiguration: configuration = null is not allowed");
            throw new NullPointerException("addConverterConfiguration: configuration = null is not allowed");
        }
        this._converterClassNameToConfigurationMap.put(converterClassName, configuration);
    }

    public void addValidator(String validatorId, String validatorClass) {
        if (validatorId == null || validatorId.length() == 0) {
            log.error((Object)"addValidator: validatorId = null is not allowed");
            throw new NullPointerException("addValidator: validatorId = null is not allowed");
        }
        if (validatorClass == null || validatorClass.length() == 0) {
            log.error((Object)"addValidator:  validatorClass = null is not allowed");
            throw new NullPointerException("addValidator:  validatorClass = null is not allowed");
        }
        try {
            this._validatorClassMap.put(validatorId, ClassUtils.simpleClassForName(validatorClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Validator id = " + validatorId + " class = " + validatorClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Validator class " + validatorClass + " not found"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent createComponent(String componentType) throws FacesException {
        Class componentClass;
        if (componentType == null || componentType.length() == 0) {
            log.error((Object)"createComponent: componentType = null is not allowed");
            throw new NullPointerException("createComponent: componentType = null is not allowed");
        }
        Map map = this._componentClassMap;
        synchronized (map) {
            componentClass = (Class)this._componentClassMap.get(componentType);
        }
        if (componentClass == null) {
            log.error((Object)("Undefined component type " + componentType));
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            return (UIComponent)componentClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate component componentType = " + componentType), (Throwable)e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, (Throwable)e);
        }
    }

    public UIComponent createComponent(ValueBinding valueBinding, FacesContext facesContext, String componentType) throws FacesException {
        if (valueBinding == null) {
            log.error((Object)"createComponent: valueBinding = null is not allowed");
            throw new NullPointerException("createComponent: valueBinding = null is not allowed");
        }
        if (facesContext == null) {
            log.error((Object)"createComponent: facesContext = null is not allowed");
            throw new NullPointerException("createComponent: facesContext = null is not allowed");
        }
        if (componentType == null || componentType.length() == 0) {
            log.error((Object)"createComponent: componentType = null is not allowed");
            throw new NullPointerException("createComponent: componentType = null is not allowed");
        }
        Object obj = valueBinding.getValue(facesContext);
        if (obj instanceof UIComponent) {
            UIComponent parent = (UIComponent)obj;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (!(parent instanceof UIViewRoot) || parent == facesContext.getViewRoot()) {
                return (UIComponent)obj;
            }
            log.debug((Object)("Stale component found while creating component of type [" + componentType + "]" + " for binding [" + valueBinding.getExpressionString() + "]"));
            return (UIComponent)obj;
        }
        try {
            UIComponent component = this.createComponent(componentType);
            valueBinding.setValue(facesContext, (Object)component);
            return component;
        }
        catch (FacesException ex) {
            log.error((Object)("Exception while creating component of type [" + componentType + "]" + " for binding [" + valueBinding.getExpressionString() + "]"));
            throw ex;
        }
    }

    public Converter createConverter(String converterId) {
        if (converterId == null || converterId.length() == 0) {
            log.error((Object)"createConverter: converterId = null is not allowed");
            throw new NullPointerException("createConverter: converterId = null is not allowed");
        }
        Class converterClass = (Class)this._converterIdToClassMap.get(converterId);
        if (converterClass == null) {
            throw new FacesException("Could not find any registered converter-class by converterId : " + converterId);
        }
        try {
            Converter converter = (Converter)converterClass.newInstance();
            this.setConverterProperties(converterClass, converter);
            return converter;
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate converter " + converterClass + " by converterId : " + converterId), (Throwable)e);
            throw new FacesException("Could not instantiate converter " + converterClass + " by converterId : " + converterId, (Throwable)e);
        }
    }

    public Converter createConverter(Class targetClass) {
        if (targetClass == null) {
            log.error((Object)"createConverter: targetClass = null is not allowed");
            throw new NullPointerException("createConverter: targetClass = null is not allowed");
        }
        Converter converter = this.internalCreateConverter(targetClass);
        return converter;
    }

    private Converter internalCreateConverter(Class targetClass) {
        Class<?>[] interfaces;
        String converterClassName = (String)this._converterClassNameToClassMap.get(targetClass);
        if (converterClassName == null && (interfaces = targetClass.getInterfaces()) != null) {
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Converter converter = this.internalCreateConverter(interfaces[i]);
                if (converter == null) continue;
                return converter;
            }
        }
        if (converterClassName != null) {
            try {
                Class converterClass = ClassUtils.simpleClassForName(converterClassName);
                Converter converter = (Converter)converterClass.newInstance();
                this.setConverterProperties(converterClass, converter);
                return converter;
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate converter by class-name : " + converterClassName), (Throwable)e);
                throw new FacesException("Could not instantiate converter by class-name : " + converterClassName, (Throwable)e);
            }
        }
        if (targetClass == Long.TYPE) {
            return this.internalCreateConverter(Long.class);
        }
        if (targetClass == Boolean.TYPE) {
            return this.internalCreateConverter(Boolean.class);
        }
        if (targetClass == Double.TYPE) {
            return this.internalCreateConverter(Double.class);
        }
        if (targetClass == Byte.TYPE) {
            return this.internalCreateConverter(Byte.class);
        }
        if (targetClass == Short.TYPE) {
            return this.internalCreateConverter(Short.class);
        }
        if (targetClass == Integer.TYPE) {
            return this.internalCreateConverter(Integer.class);
        }
        if (targetClass == Float.TYPE) {
            return this.internalCreateConverter(Float.class);
        }
        if (targetClass == Character.TYPE) {
            return this.internalCreateConverter(Character.class);
        }
        Class superClazz = targetClass.getSuperclass();
        if (superClazz != null) {
            return this.internalCreateConverter(superClazz);
        }
        return null;
    }

    private void setConverterProperties(Class converterClass, Converter converter) {
        org.apache.myfaces.config.impl.digester.elements.Converter converterConfig = (org.apache.myfaces.config.impl.digester.elements.Converter)this._converterClassNameToConfigurationMap.get(converterClass.getName());
        if (converterConfig != null) {
            Iterator it = converterConfig.getProperties();
            while (it.hasNext()) {
                Property property = (Property)it.next();
                try {
                    BeanUtils.setProperty((Object)converter, (String)property.getPropertyName(), (Object)property.getDefaultValue());
                }
                catch (Throwable th) {
                    log.error((Object)("Initializing converter : " + converterClass.getName() + " with property : " + property.getPropertyName() + " and value : " + property.getDefaultValue() + " failed."), th);
                }
            }
        }
    }

    public synchronized MethodBinding createMethodBinding(String reference, Class[] params) throws ReferenceSyntaxException {
        if (reference == null || reference.length() == 0) {
            log.error((Object)"createMethodBinding: reference = null is not allowed");
            throw new NullPointerException("createMethodBinding: reference = null is not allowed");
        }
        return new MethodBindingImpl(this, reference, params);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        if (validatorId == null || validatorId.length() == 0) {
            log.error((Object)"createValidator: validatorId = null is not allowed");
            throw new NullPointerException("createValidator: validatorId = null is not allowed");
        }
        Class validatorClass = (Class)this._validatorClassMap.get(validatorId);
        if (validatorClass == null) {
            String message = "Unknown validator id '" + validatorId + "'.";
            log.error((Object)message);
            throw new FacesException(message);
        }
        try {
            return (Validator)validatorClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate validator " + validatorClass), (Throwable)e);
            throw new FacesException("Could not instantiate validator: " + validatorClass, (Throwable)e);
        }
    }

    public ValueBinding createValueBinding(String reference) throws ReferenceSyntaxException {
        if (reference == null || reference.length() == 0) {
            log.error((Object)"createValueBinding: reference = null is not allowed");
            throw new NullPointerException("createValueBinding: reference = null is not allowed");
        }
        return (ValueBinding)this._valueBindingCache.get(reference);
    }

    public String getDefaultRenderKitId() {
        return this._defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String defaultRenderKitId) {
        this._defaultRenderKitId = defaultRenderKitId;
    }

    public StateManager getStateManager() {
        return this._stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this._stateManager = stateManager;
    }
}

