/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentBodyTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.shared_impl.util.LocaleUtils;

public class ViewTag
extends UIComponentBodyTag {
    private static final Log log = LogFactory.getLog(ViewTag.class);
    private static final String PARTIAL_STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_METHOD";
    private static final String PARTIAL_STATE_SAVING_METHOD_ON = "true";
    private static final String PARTIAL_STATE_SAVING_METHOD_OFF = "false";
    private Boolean _partialStateSaving = null;
    private String _locale;

    private boolean isPartialStateSavingOn(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSaving != null) {
            return this._partialStateSaving;
        }
        String string = facesContext.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_METHOD_PARAM_NAME);
        if (string == null) {
            this._partialStateSaving = Boolean.FALSE;
            facesContext.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; no partial state saving method defined, assuming default partial state saving method off.");
        } else if (string.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSaving = Boolean.TRUE;
        } else if (string.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSaving = Boolean.FALSE;
        } else {
            this._partialStateSaving = Boolean.FALSE;
            facesContext.getExternalContext().log("Illegal partial state saving method '" + string + "', default partial state saving will be used (partial state saving off).");
        }
        return this._partialStateSaving;
    }

    public String getComponentType() {
        return "javax.faces.ViewRoot";
    }

    public String getRendererType() {
        return null;
    }

    public void setLocale(String string) {
        this._locale = string;
    }

    public int doStartTag() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doStartTag");
        }
        super.doStartTag();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            responseWriter.startDocument();
        }
        catch (IOException iOException) {
            log.error((Object)"Error writing startDocument", (Throwable)iOException);
            throw new JspException((Throwable)iOException);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doStartTag");
        }
        return 2;
    }

    protected boolean isSuppressed() {
        return true;
    }

    public int doEndTag() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doEndTag");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            responseWriter.endDocument();
        }
        catch (IOException iOException) {
            log.error((Object)"Error writing endDocument", (Throwable)iOException);
            throw new JspException((Throwable)iOException);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doEndTag");
        }
        return super.doEndTag();
    }

    public int doAfterBody() throws JspException {
        FacesContext facesContext;
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doAfterBody");
        }
        if (!this.isPartialStateSavingOn(facesContext = FacesContext.getCurrentInstance())) {
            try {
                BodyContent bodyContent = this.getBodyContent();
                if (bodyContent != null) {
                    StateManager stateManager = facesContext.getApplication().getStateManager();
                    StateManager.SerializedView serializedView = stateManager.saveSerializedView(facesContext);
                    ResponseWriter responseWriter = facesContext.getResponseWriter();
                    responseWriter.flush();
                    ResponseWriter responseWriter2 = responseWriter.cloneWithWriter((Writer)this.getPreviousOut());
                    facesContext.setResponseWriter(responseWriter2);
                    String string = bodyContent.getString();
                    int n = string.indexOf("<!--@@JSF_FORM_STATE_MARKER@@-->");
                    int n2 = 0;
                    while (n != -1) {
                        responseWriter2.write(string, n2, n - n2);
                        stateManager.writeState(facesContext, serializedView);
                        n2 = n + JspViewHandlerImpl.FORM_STATE_MARKER_LEN;
                        n = string.indexOf("<!--@@JSF_FORM_STATE_MARKER@@-->", n2);
                    }
                    responseWriter2.write(string, n2, string.length() - n2);
                }
            }
            catch (IOException iOException) {
                log.error((Object)"Error writing body content", (Throwable)iOException);
                throw new JspException((Throwable)iOException);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doAfterBody");
        }
        return super.doAfterBody();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setProperties(UIComponent uIComponent) {
        block6: {
            Locale locale;
            block5: {
                block7: {
                    super.setProperties(uIComponent);
                    if (this._locale == null) break block6;
                    if (!UIComponentTag.isValueReference((String)this._locale)) break block7;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    ValueBinding valueBinding = facesContext.getApplication().createValueBinding(this._locale);
                    Object object = valueBinding.getValue(facesContext);
                    if (object instanceof Locale) {
                        locale = (Locale)object;
                        break block5;
                    } else if (object instanceof String) {
                        locale = LocaleUtils.toLocale((String)object);
                        break block5;
                    } else {
                        if (object != null) {
                            throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return class: " + object.getClass().getName());
                        }
                        throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return value null");
                    }
                }
                locale = LocaleUtils.toLocale(this._locale);
            }
            ((UIViewRoot)uIComponent).setLocale(locale);
            Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        }
    }
}

