/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.javascript;

import com.yahoo.platform.yui.javascript.Scriptable;
import com.yahoo.platform.yui.javascript.ScriptableObject;
import java.util.Hashtable;

public class ClassCache {
    private static final Object AKEY = new Object();
    private volatile boolean cachingIsEnabled = true;
    Hashtable classTable = new Hashtable();
    Hashtable javaAdapterGeneratedClasses = new Hashtable();
    ScriptableObject scope;
    private Hashtable interfaceAdapterCache;
    private int generatedClassSerial;

    public static ClassCache get(Scriptable scope) {
        ClassCache cache = (ClassCache)ScriptableObject.getTopScopeValue(scope, AKEY);
        if (cache == null) {
            cache = new ClassCache();
        }
        return cache;
    }

    public boolean associate(ScriptableObject topScope) {
        if (topScope.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        if (this == topScope.associateValue(AKEY, this)) {
            this.scope = topScope;
            return true;
        }
        return false;
    }

    public synchronized void clearCaches() {
        this.classTable = new Hashtable();
        this.javaAdapterGeneratedClasses = new Hashtable();
        this.interfaceAdapterCache = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean enabled) {
        if (enabled == this.cachingIsEnabled) {
            return;
        }
        if (!enabled) {
            this.clearCaches();
        }
        this.cachingIsEnabled = enabled;
    }

    public boolean isInvokerOptimizationEnabled() {
        return false;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean enabled) {
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class cl) {
        Hashtable cache = this.interfaceAdapterCache;
        Object result = cache == null ? null : cache.get(cl);
        return result;
    }

    synchronized void cacheInterfaceAdapter(Class cl, Object iadapter) {
        if (this.cachingIsEnabled) {
            if (this.interfaceAdapterCache == null) {
                this.interfaceAdapterCache = new Hashtable();
            }
            this.interfaceAdapterCache.put(cl, iadapter);
        }
    }
}

