/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.javascript;

import com.yahoo.platform.yui.javascript.Context;
import com.yahoo.platform.yui.javascript.Function;
import com.yahoo.platform.yui.javascript.JavaMembers;
import com.yahoo.platform.yui.javascript.Kit;
import com.yahoo.platform.yui.javascript.MemberBox;
import com.yahoo.platform.yui.javascript.NativeArray;
import com.yahoo.platform.yui.javascript.NativeJavaArray;
import com.yahoo.platform.yui.javascript.NativeJavaMethod;
import com.yahoo.platform.yui.javascript.NativeJavaObject;
import com.yahoo.platform.yui.javascript.ScriptRuntime;
import com.yahoo.platform.yui.javascript.Scriptable;
import com.yahoo.platform.yui.javascript.ScriptableObject;
import com.yahoo.platform.yui.javascript.Wrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final long serialVersionUID = -6460763940409461664L;
    static final String javaClassPropertyName = "__javaObject__";
    private Hashtable staticFieldAndMethods;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scope, Class cl) {
        this.parent = scope;
        this.javaObject = cl;
        this.initMembers();
    }

    protected void initMembers() {
        Class cl = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(this.parent, cl, cl, false);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, cl, true);
    }

    public String getClassName() {
        return "JavaClass";
    }

    public boolean has(String name, Scriptable start) {
        return this.members.has(name, true) || javaClassPropertyName.equals(name);
    }

    public Object get(String name, Scriptable start) {
        Object result;
        if (name.equals("prototype")) {
            return null;
        }
        if (this.staticFieldAndMethods != null && (result = this.staticFieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.members.has(name, true)) {
            return this.members.get(this, name, this.javaObject, true);
        }
        if (javaClassPropertyName.equals(name)) {
            Context cx = Context.getContext();
            Scriptable scope = ScriptableObject.getTopLevelScope(start);
            return cx.getWrapFactory().wrap(cx, scope, this.javaObject, ScriptRuntime.ClassClass);
        }
        Class nestedClass = NativeJavaClass.findNestedClass(this.getClassObject(), name);
        if (nestedClass != null) {
            NativeJavaClass nestedValue = new NativeJavaClass(ScriptableObject.getTopLevelScope(this), nestedClass);
            nestedValue.setParentScope(this);
            return nestedValue;
        }
        throw this.members.reportMemberNotFound(name);
    }

    public void put(String name, Scriptable start, Object value) {
        this.members.put(this, name, this.javaObject, value, true);
    }

    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 1 && args[0] instanceof Scriptable) {
            Class c = this.getClassObject();
            Scriptable p = (Scriptable)args[0];
            do {
                Object o;
                if (!(p instanceof Wrapper) || !c.isInstance(o = ((Wrapper)((Object)p)).unwrap())) continue;
                return p;
            } while ((p = p.getPrototype()) != null);
        }
        return this.construct(cx, scope, args);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        String msg;
        Class classObject;
        block5: {
            classObject = this.getClassObject();
            int modifiers = classObject.getModifiers();
            if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers)) {
                MemberBox[] ctors = this.members.ctors;
                int index = NativeJavaMethod.findFunction(cx, ctors, args);
                if (index < 0) {
                    String sig = NativeJavaMethod.scriptSignature(args);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", classObject.getName(), sig);
                }
                return NativeJavaClass.constructSpecific(cx, scope, args, ctors[index]);
            }
            Scriptable topLevel = ScriptableObject.getTopLevelScope(this);
            msg = "";
            try {
                Object v = topLevel.get("JavaAdapter", topLevel);
                if (v != NOT_FOUND) {
                    Function f = (Function)v;
                    Object[] adapterArgs = new Object[]{this, args[0]};
                    return f.construct(cx, topLevel, adapterArgs);
                }
            }
            catch (Exception ex) {
                String m = ex.getMessage();
                if (m == null) break block5;
                msg = m;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", msg, classObject.getName());
    }

    static Scriptable constructSpecific(Context cx, Scriptable scope, Object[] args, MemberBox ctor) {
        Scriptable topLevel = ScriptableObject.getTopLevelScope(scope);
        Class[] argTypes = ctor.argTypes;
        if (ctor.vararg) {
            Object varArgs;
            Object[] newArgs = new Object[argTypes.length];
            for (int i = 0; i < argTypes.length - 1; ++i) {
                newArgs[i] = Context.jsToJava(args[i], argTypes[i]);
            }
            if (args.length == argTypes.length && (args[args.length - 1] == null || args[args.length - 1] instanceof NativeArray || args[args.length - 1] instanceof NativeJavaArray)) {
                varArgs = Context.jsToJava(args[args.length - 1], argTypes[argTypes.length - 1]);
            } else {
                Class<?> componentType = argTypes[argTypes.length - 1].getComponentType();
                varArgs = Array.newInstance(componentType, args.length - argTypes.length + 1);
                for (int i = 0; i < Array.getLength(varArgs); ++i) {
                    Object value = Context.jsToJava(args[argTypes.length - 1 + i], componentType);
                    Array.set(varArgs, i, value);
                }
            }
            newArgs[argTypes.length - 1] = varArgs;
            args = newArgs;
        } else {
            Object[] origArgs = args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object x = Context.jsToJava(arg, argTypes[i]);
                if (x == arg) continue;
                if (args == origArgs) {
                    args = (Object[])origArgs.clone();
                }
                args[i] = x;
            }
        }
        Object instance = ctor.newInstance(args);
        return cx.getWrapFactory().wrapNewObject(cx, topLevel, instance);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    public boolean hasInstance(Scriptable value) {
        if (value instanceof Wrapper && !(value instanceof NativeJavaClass)) {
            Object instance = ((Wrapper)((Object)value)).unwrap();
            return this.getClassObject().isInstance(instance);
        }
        return false;
    }

    private static Class findNestedClass(Class parentClass, String name) {
        String nestedClassName = parentClass.getName() + '$' + name;
        ClassLoader loader = parentClass.getClassLoader();
        if (loader == null) {
            return Kit.classOrNull(nestedClassName);
        }
        return Kit.classOrNull(loader, nestedClassName);
    }
}

