/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.javascript;

import com.yahoo.platform.yui.javascript.Context;
import com.yahoo.platform.yui.javascript.IdFunctionObject;
import com.yahoo.platform.yui.javascript.IdScriptableObject;
import com.yahoo.platform.yui.javascript.RegExpProxy;
import com.yahoo.platform.yui.javascript.ScriptRuntime;
import com.yahoo.platform.yui.javascript.Scriptable;
import com.yahoo.platform.yui.javascript.Undefined;
import java.text.Collator;

final class NativeString
extends IdScriptableObject {
    static final long serialVersionUID = 920268368584188687L;
    private static final Object STRING_TAG = new Object();
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int Id_localeCompare = 34;
    private static final int Id_toLocaleLowerCase = 35;
    private static final int Id_toLocaleUpperCase = 36;
    private static final int MAX_PROTOTYPE_ID = 36;
    private String string;

    static void init(Scriptable scope, boolean sealed) {
        NativeString obj = new NativeString("");
        obj.exportAsJSClass(36, scope, sealed);
    }

    private NativeString(String s) {
        this.string = s;
    }

    public String getClassName() {
        return "String";
    }

    protected int getMaxInstanceId() {
        return 1;
    }

    protected int findInstanceIdInfo(String s) {
        if (s.equals("length")) {
            return NativeString.instanceIdInfo(7, 1);
        }
        return super.findInstanceIdInfo(s);
    }

    protected String getInstanceIdName(int id) {
        if (id == 1) {
            return "length";
        }
        return super.getInstanceIdName(id);
    }

    protected Object getInstanceIdValue(int id) {
        if (id == 1) {
            return ScriptRuntime.wrapInt(this.string.length());
        }
        return super.getInstanceIdValue(id);
    }

    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, STRING_TAG, -1, "fromCharCode", 1);
        super.fillConstructorProperties(ctor);
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toSource";
                break;
            }
            case 4: {
                arity = 0;
                s = "valueOf";
                break;
            }
            case 5: {
                arity = 1;
                s = "charAt";
                break;
            }
            case 6: {
                arity = 1;
                s = "charCodeAt";
                break;
            }
            case 7: {
                arity = 1;
                s = "indexOf";
                break;
            }
            case 8: {
                arity = 1;
                s = "lastIndexOf";
                break;
            }
            case 9: {
                arity = 2;
                s = "split";
                break;
            }
            case 10: {
                arity = 2;
                s = "substring";
                break;
            }
            case 11: {
                arity = 0;
                s = "toLowerCase";
                break;
            }
            case 12: {
                arity = 0;
                s = "toUpperCase";
                break;
            }
            case 13: {
                arity = 2;
                s = "substr";
                break;
            }
            case 14: {
                arity = 1;
                s = "concat";
                break;
            }
            case 15: {
                arity = 2;
                s = "slice";
                break;
            }
            case 16: {
                arity = 0;
                s = "bold";
                break;
            }
            case 17: {
                arity = 0;
                s = "italics";
                break;
            }
            case 18: {
                arity = 0;
                s = "fixed";
                break;
            }
            case 19: {
                arity = 0;
                s = "strike";
                break;
            }
            case 20: {
                arity = 0;
                s = "small";
                break;
            }
            case 21: {
                arity = 0;
                s = "big";
                break;
            }
            case 22: {
                arity = 0;
                s = "blink";
                break;
            }
            case 23: {
                arity = 0;
                s = "sup";
                break;
            }
            case 24: {
                arity = 0;
                s = "sub";
                break;
            }
            case 25: {
                arity = 0;
                s = "fontsize";
                break;
            }
            case 26: {
                arity = 0;
                s = "fontcolor";
                break;
            }
            case 27: {
                arity = 0;
                s = "link";
                break;
            }
            case 28: {
                arity = 0;
                s = "anchor";
                break;
            }
            case 29: {
                arity = 1;
                s = "equals";
                break;
            }
            case 30: {
                arity = 1;
                s = "equalsIgnoreCase";
                break;
            }
            case 31: {
                arity = 1;
                s = "match";
                break;
            }
            case 32: {
                arity = 1;
                s = "search";
                break;
            }
            case 33: {
                arity = 1;
                s = "replace";
                break;
            }
            case 34: {
                arity = 1;
                s = "localeCompare";
                break;
            }
            case 35: {
                arity = 0;
                s = "toLocaleLowerCase";
                break;
            }
            case 36: {
                arity = 0;
                s = "toLocaleUpperCase";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(STRING_TAG, id, s, arity);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(STRING_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case -1: {
                int N = args.length;
                if (N < 1) {
                    return "";
                }
                StringBuffer sb = new StringBuffer(N);
                for (int i = 0; i != N; ++i) {
                    sb.append(ScriptRuntime.toUint16(args[i]));
                }
                return sb.toString();
            }
            case 1: {
                String s;
                String string = s = args.length >= 1 ? ScriptRuntime.toString(args[0]) : "";
                if (thisObj == null) {
                    return new NativeString(s);
                }
                return s;
            }
            case 2: 
            case 4: {
                return NativeString.realThis((Scriptable)thisObj, (IdFunctionObject)f).string;
            }
            case 3: {
                String s = NativeString.realThis((Scriptable)thisObj, (IdFunctionObject)f).string;
                return "(new String(\"" + ScriptRuntime.escapeString(s) + "\"))";
            }
            case 5: 
            case 6: {
                String target = ScriptRuntime.toString(thisObj);
                double pos = ScriptRuntime.toInteger(args, 0);
                if (pos < 0.0 || pos >= (double)target.length()) {
                    if (id == 5) {
                        return "";
                    }
                    return ScriptRuntime.NaNobj;
                }
                char c = target.charAt((int)pos);
                if (id == 5) {
                    return String.valueOf(c);
                }
                return ScriptRuntime.wrapInt(c);
            }
            case 7: {
                return ScriptRuntime.wrapInt(NativeString.js_indexOf(ScriptRuntime.toString(thisObj), args));
            }
            case 8: {
                return ScriptRuntime.wrapInt(NativeString.js_lastIndexOf(ScriptRuntime.toString(thisObj), args));
            }
            case 9: {
                return NativeString.js_split(cx, scope, ScriptRuntime.toString(thisObj), args);
            }
            case 10: {
                return NativeString.js_substring(cx, ScriptRuntime.toString(thisObj), args);
            }
            case 11: {
                return ScriptRuntime.toString(thisObj).toLowerCase();
            }
            case 12: {
                return ScriptRuntime.toString(thisObj).toUpperCase();
            }
            case 13: {
                return NativeString.js_substr(ScriptRuntime.toString(thisObj), args);
            }
            case 14: {
                return NativeString.js_concat(ScriptRuntime.toString(thisObj), args);
            }
            case 15: {
                return NativeString.js_slice(ScriptRuntime.toString(thisObj), args);
            }
            case 16: {
                return NativeString.tagify(thisObj, "b", null, null);
            }
            case 17: {
                return NativeString.tagify(thisObj, "i", null, null);
            }
            case 18: {
                return NativeString.tagify(thisObj, "tt", null, null);
            }
            case 19: {
                return NativeString.tagify(thisObj, "strike", null, null);
            }
            case 20: {
                return NativeString.tagify(thisObj, "small", null, null);
            }
            case 21: {
                return NativeString.tagify(thisObj, "big", null, null);
            }
            case 22: {
                return NativeString.tagify(thisObj, "blink", null, null);
            }
            case 23: {
                return NativeString.tagify(thisObj, "sup", null, null);
            }
            case 24: {
                return NativeString.tagify(thisObj, "sub", null, null);
            }
            case 25: {
                return NativeString.tagify(thisObj, "font", "size", args);
            }
            case 26: {
                return NativeString.tagify(thisObj, "font", "color", args);
            }
            case 27: {
                return NativeString.tagify(thisObj, "a", "href", args);
            }
            case 28: {
                return NativeString.tagify(thisObj, "a", "name", args);
            }
            case 29: 
            case 30: {
                String s1 = ScriptRuntime.toString(thisObj);
                String s2 = ScriptRuntime.toString(args, 0);
                return ScriptRuntime.wrapBoolean(id == 29 ? s1.equals(s2) : s1.equalsIgnoreCase(s2));
            }
            case 31: 
            case 32: 
            case 33: {
                int actionType = id == 31 ? 1 : (id == 32 ? 3 : 2);
                return ScriptRuntime.checkRegExpProxy(cx).action(cx, scope, thisObj, args, actionType);
            }
            case 34: {
                Collator collator = Collator.getInstance(cx.getLocale());
                collator.setStrength(3);
                collator.setDecomposition(1);
                return ScriptRuntime.wrapNumber(collator.compare(ScriptRuntime.toString(thisObj), ScriptRuntime.toString(args, 0)));
            }
            case 35: {
                return ScriptRuntime.toString(thisObj).toLowerCase(cx.getLocale());
            }
            case 36: {
                return ScriptRuntime.toString(thisObj).toUpperCase(cx.getLocale());
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    private static NativeString realThis(Scriptable thisObj, IdFunctionObject f) {
        if (!(thisObj instanceof NativeString)) {
            throw NativeString.incompatibleCallError(f);
        }
        return (NativeString)thisObj;
    }

    private static String tagify(Object thisObj, String tag, String attribute, Object[] args) {
        String str = ScriptRuntime.toString(thisObj);
        StringBuffer result = new StringBuffer();
        result.append('<');
        result.append(tag);
        if (attribute != null) {
            result.append(' ');
            result.append(attribute);
            result.append("=\"");
            result.append(ScriptRuntime.toString(args, 0));
            result.append('\"');
        }
        result.append('>');
        result.append(str);
        result.append("</");
        result.append(tag);
        result.append('>');
        return result.toString();
    }

    public String toString() {
        return this.string;
    }

    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.string.length()) {
            return this.string.substring(index, index + 1);
        }
        return super.get(index, start);
    }

    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.string.length()) {
            return;
        }
        super.put(index, start, value);
    }

    private static int js_indexOf(String target, Object[] args) {
        String search = ScriptRuntime.toString(args, 0);
        double begin = ScriptRuntime.toInteger(args, 1);
        if (begin > (double)target.length()) {
            return -1;
        }
        if (begin < 0.0) {
            begin = 0.0;
        }
        return target.indexOf(search, (int)begin);
    }

    private static int js_lastIndexOf(String target, Object[] args) {
        String search = ScriptRuntime.toString(args, 0);
        double end = ScriptRuntime.toNumber(args, 1);
        if (end != end || end > (double)target.length()) {
            end = target.length();
        } else if (end < 0.0) {
            end = 0.0;
        }
        return target.lastIndexOf(search, (int)end);
    }

    private static int find_split(Context cx, Scriptable scope, String target, String separator, int version, RegExpProxy reProxy, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int i;
        int length = target.length();
        if (version == 120 && re == null && separator.length() == 1 && separator.charAt(0) == ' ') {
            int j;
            if (i == 0) {
                for (i = ip[0]; i < length && Character.isWhitespace(target.charAt(i)); ++i) {
                }
                ip[0] = i;
            }
            if (i == length) {
                return -1;
            }
            while (i < length && !Character.isWhitespace(target.charAt(i))) {
                ++i;
            }
            for (j = i; j < length && Character.isWhitespace(target.charAt(j)); ++j) {
            }
            matchlen[0] = j - i;
            return i;
        }
        if (i > length) {
            return -1;
        }
        if (re != null) {
            return reProxy.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
        }
        if (version != 0 && version < 130 && length == 0) {
            return -1;
        }
        if (separator.length() == 0) {
            if (version == 120) {
                if (i == length) {
                    matchlen[0] = 1;
                    return i;
                }
                return i + 1;
            }
            return i == length ? -1 : i + 1;
        }
        if (ip[0] >= length) {
            return length;
        }
        i = target.indexOf(separator, ip[0]);
        return i != -1 ? i : length;
    }

    private static Object js_split(Context cx, Scriptable scope, String target, Object[] args) {
        int match;
        Scriptable test;
        Scriptable top = NativeString.getTopLevelScope(scope);
        Scriptable result = ScriptRuntime.newObject(cx, top, "Array", null);
        if (args.length < 1) {
            result.put(0, result, (Object)target);
            return result;
        }
        boolean limited = args.length > 1 && args[1] != Undefined.instance;
        long limit = 0L;
        if (limited && (limit = ScriptRuntime.toUint32(args[1])) > (long)target.length()) {
            limit = 1 + target.length();
        }
        String separator = null;
        int[] matchlen = new int[1];
        Scriptable re = null;
        RegExpProxy reProxy = null;
        if (args[0] instanceof Scriptable && (reProxy = ScriptRuntime.getRegExpProxy(cx)) != null && reProxy.isRegExp(test = (Scriptable)args[0])) {
            re = test;
        }
        if (re == null) {
            separator = ScriptRuntime.toString(args[0]);
            matchlen[0] = separator.length();
        }
        int[] ip = new int[]{0};
        int len = 0;
        boolean[] matched = new boolean[]{false};
        String[][] parens = new String[][]{null};
        int version = cx.getLanguageVersion();
        while (!((match = NativeString.find_split(cx, scope, target, separator, version, reProxy, re, ip, matchlen, matched, parens)) < 0 || limited && (long)len >= limit || match > target.length())) {
            String substr = target.length() == 0 ? target : target.substring(ip[0], match);
            result.put(len, result, (Object)substr);
            ++len;
            if (re != null && matched[0]) {
                int size = parens[0].length;
                for (int num = 0; !(num >= size || limited && (long)len >= limit); ++num) {
                    result.put(len, result, (Object)parens[0][num]);
                    ++len;
                }
                matched[0] = false;
            }
            ip[0] = match + matchlen[0];
            if (version >= 130 || version == 0 || limited || ip[0] != target.length()) continue;
            break;
        }
        return result;
    }

    private static String js_substring(Context cx, String target, Object[] args) {
        double end;
        int length = target.length();
        double start = ScriptRuntime.toInteger(args, 0);
        if (start < 0.0) {
            start = 0.0;
        } else if (start > (double)length) {
            start = length;
        }
        if (args.length <= 1 || args[1] == Undefined.instance) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            } else if (end > (double)length) {
                end = length;
            }
            if (end < start) {
                if (cx.getLanguageVersion() != 120) {
                    double temp = start;
                    start = end;
                    end = temp;
                } else {
                    end = start;
                }
            }
        }
        return target.substring((int)start, (int)end);
    }

    int getLength() {
        return this.string.length();
    }

    private static String js_substr(String target, Object[] args) {
        double end;
        if (args.length < 1) {
            return target;
        }
        double begin = ScriptRuntime.toInteger(args[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        if (args.length == 1) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            }
            if ((end += begin) > (double)length) {
                end = length;
            }
        }
        return target.substring((int)begin, (int)end);
    }

    private static String js_concat(String target, Object[] args) {
        int N = args.length;
        if (N == 0) {
            return target;
        }
        if (N == 1) {
            String arg = ScriptRuntime.toString(args[0]);
            return target.concat(arg);
        }
        int size = target.length();
        String[] argsAsStrings = new String[N];
        for (int i = 0; i != N; ++i) {
            String s;
            argsAsStrings[i] = s = ScriptRuntime.toString(args[i]);
            size += s.length();
        }
        StringBuffer result = new StringBuffer(size);
        result.append(target);
        for (int i = 0; i != N; ++i) {
            result.append(argsAsStrings[i]);
        }
        return result.toString();
    }

    private static String js_slice(String target, Object[] args) {
        if (args.length != 0) {
            double end;
            double begin = ScriptRuntime.toInteger(args[0]);
            int length = target.length();
            if (begin < 0.0) {
                if ((begin += (double)length) < 0.0) {
                    begin = 0.0;
                }
            } else if (begin > (double)length) {
                begin = length;
            }
            if (args.length == 1) {
                end = length;
            } else {
                end = ScriptRuntime.toInteger(args[1]);
                if (end < 0.0) {
                    if ((end += (double)length) < 0.0) {
                        end = 0.0;
                    }
                } else if (end > (double)length) {
                    end = length;
                }
                if (end < begin) {
                    end = begin;
                }
            }
            return target.substring((int)begin, (int)end);
        }
        return target;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(2);
                if (c == 'b') {
                    if (s.charAt(0) != 's' || s.charAt(1) != 'u') break;
                    return 24;
                }
                if (c == 'g') {
                    if (s.charAt(0) != 'b' || s.charAt(1) != 'i') break;
                    return 21;
                }
                if (c != 'p' || s.charAt(0) != 's' || s.charAt(1) != 'u') break;
                return 23;
            }
            case 4: {
                char c = s.charAt(0);
                if (c == 'b') {
                    X = "bold";
                    id = 16;
                    break;
                }
                if (c != 'l') break;
                X = "link";
                id = 27;
                break;
            }
            case 5: {
                switch (s.charAt(4)) {
                    case 'd': {
                        X = "fixed";
                        id = 18;
                        break block0;
                    }
                    case 'e': {
                        X = "slice";
                        id = 15;
                        break block0;
                    }
                    case 'h': {
                        X = "match";
                        id = 31;
                        break block0;
                    }
                    case 'k': {
                        X = "blink";
                        id = 22;
                        break block0;
                    }
                    case 'l': {
                        X = "small";
                        id = 20;
                        break block0;
                    }
                    case 't': {
                        X = "split";
                        id = 9;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'e': {
                        X = "search";
                        id = 32;
                        break block0;
                    }
                    case 'h': {
                        X = "charAt";
                        id = 5;
                        break block0;
                    }
                    case 'n': {
                        X = "anchor";
                        id = 28;
                        break block0;
                    }
                    case 'o': {
                        X = "concat";
                        id = 14;
                        break block0;
                    }
                    case 'q': {
                        X = "equals";
                        id = 29;
                        break block0;
                    }
                    case 't': {
                        X = "strike";
                        id = 19;
                        break block0;
                    }
                    case 'u': {
                        X = "substr";
                        id = 13;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "valueOf";
                        id = 4;
                        break block0;
                    }
                    case 'e': {
                        X = "replace";
                        id = 33;
                        break block0;
                    }
                    case 'n': {
                        X = "indexOf";
                        id = 7;
                        break block0;
                    }
                    case 't': {
                        X = "italics";
                        id = 17;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(4);
                if (c == 'r') {
                    X = "toString";
                    id = 2;
                    break;
                }
                if (c == 's') {
                    X = "fontsize";
                    id = 25;
                    break;
                }
                if (c != 'u') break;
                X = "toSource";
                id = 3;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'f') {
                    X = "fontcolor";
                    id = 26;
                    break;
                }
                if (c != 's') break;
                X = "substring";
                id = 10;
                break;
            }
            case 10: {
                X = "charCodeAt";
                id = 6;
                break;
            }
            case 11: {
                switch (s.charAt(2)) {
                    case 'L': {
                        X = "toLowerCase";
                        id = 11;
                        break block0;
                    }
                    case 'U': {
                        X = "toUpperCase";
                        id = 12;
                        break block0;
                    }
                    case 'n': {
                        X = "constructor";
                        id = 1;
                        break block0;
                    }
                    case 's': {
                        X = "lastIndexOf";
                        id = 8;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                X = "localeCompare";
                id = 34;
                break;
            }
            case 16: {
                X = "equalsIgnoreCase";
                id = 30;
                break;
            }
            case 17: {
                char c = s.charAt(8);
                if (c == 'L') {
                    X = "toLocaleLowerCase";
                    id = 35;
                    break;
                }
                if (c != 'U') break;
                X = "toLocaleUpperCase";
                id = 36;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

