/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import org.alfresco.webservice.administration.NewUserDetails;
import org.alfresco.webservice.administration.UserDetails;
import org.alfresco.webservice.administration.UserFilter;
import org.alfresco.webservice.administration.UserQueryResults;
import org.alfresco.webservice.repository.RepositoryServiceLocator;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.QueryConfiguration;
import org.alfresco.webservice.util.AuthenticationDetails;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdministrationServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(AdministrationServiceSystemTest.class);

    public void testGetUsersBatching() throws Exception {
        int batchSize = 1;
        QueryConfiguration queryCfg = new QueryConfiguration();
        queryCfg.setFetchSize(batchSize);
        WebServiceFactory.getAdministrationService().setHeader(new RepositoryServiceLocator().getServiceName().getNamespaceURI(), "QueryHeader", queryCfg);
        String homeFolder = store.getScheme() + "://" + store.getAddress() + "/" + folderReference.getUuid();
        String one = Long.toString(System.currentTimeMillis());
        String two = one + "2";
        NewUserDetails[] newUsers = new NewUserDetails[]{new NewUserDetails("user" + one, "password" + one, this.createPersonProperties(homeFolder, "first" + one, "middle" + one, "last" + one, "email" + one, "org" + one)), new NewUserDetails("user" + two, "password2" + two, this.createPersonProperties(homeFolder, "first" + two, "middle" + two, "last" + two, "email" + two, "org" + two))};
        WebServiceFactory.getAdministrationService().createUsers(newUsers);
        UserQueryResults results = WebServiceFactory.getAdministrationService().queryUsers(null);
        AdministrationServiceSystemTest.assertNotNull((Object)results);
        if (logger.isDebugEnabled()) {
            while (true) {
                System.out.println("Next batch");
                System.out.println("Session Id: " + results.getQuerySession());
                for (UserDetails details : results.getUserDetails()) {
                    System.out.println("User name: " + details.getUserName());
                }
                if (results.getQuerySession() == null) break;
                results = WebServiceFactory.getAdministrationService().fetchMoreUsers(results.getQuerySession());
            }
        }
        String[] userNames = new String[]{"user" + one, "user" + two};
        WebServiceFactory.getAdministrationService().deleteUsers(userNames);
    }

    public void testCreateGetDeleteUser() throws Exception {
        NamedValue[] properties;
        try {
            WebServiceFactory.getAdministrationService().getUser("badUser");
            AdministrationServiceSystemTest.fail((String)"An exception should have been raised since we are trying to get hold of a user that does not exist.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String homeFolder = store.getScheme() + "://" + store.getAddress() + "/" + folderReference.getUuid();
        String one = Long.toString(System.currentTimeMillis());
        String two = one + "2";
        NewUserDetails[] newUsers = new NewUserDetails[]{new NewUserDetails("user" + one, "password" + one, this.createPersonProperties(homeFolder, "first" + one, "middle" + one, "last" + one, "email" + one, "org" + one)), new NewUserDetails("user" + two, "password2" + two, this.createPersonProperties(homeFolder, "first" + two, "middle" + two, "last" + two, "email" + two, "org" + two))};
        UserDetails[] userDetails = WebServiceFactory.getAdministrationService().createUsers(newUsers);
        AdministrationServiceSystemTest.assertNotNull((Object)userDetails);
        AdministrationServiceSystemTest.assertEquals((int)2, (int)userDetails.length);
        String name = one;
        for (UserDetails result : userDetails) {
            NamedValue[] properties2;
            for (NamedValue value : properties2 = result.getProperties()) {
                if (value.getName().equals(Constants.PROP_USER_FIRSTNAME)) {
                    AdministrationServiceSystemTest.assertEquals((String)("first" + name), (String)value.getValue());
                    continue;
                }
                if (value.getName().equals(Constants.PROP_USER_MIDDLENAME)) {
                    AdministrationServiceSystemTest.assertEquals((String)("middle" + name), (String)value.getValue());
                    continue;
                }
                if (value.getName().equals(Constants.PROP_USER_LASTNAME)) {
                    AdministrationServiceSystemTest.assertEquals((String)("last" + name), (String)value.getValue());
                    continue;
                }
                if (value.getName().equals(Constants.PROP_USER_HOMEFOLDER)) {
                    AdministrationServiceSystemTest.assertEquals((String)homeFolder, (String)value.getValue());
                    continue;
                }
                if (value.getName().equals(Constants.PROP_USER_EMAIL)) {
                    AdministrationServiceSystemTest.assertEquals((String)("email" + name), (String)value.getValue());
                    continue;
                }
                if (value.getName().equals(Constants.PROP_USER_ORGID)) {
                    AdministrationServiceSystemTest.assertEquals((String)("org" + name), (String)value.getValue());
                    continue;
                }
                if (!value.getName().equals(Constants.PROP_USERNAME)) continue;
                AdministrationServiceSystemTest.assertEquals((String)("user" + name), (String)value.getValue());
            }
            name = two;
        }
        UserDetails userDetails2 = WebServiceFactory.getAdministrationService().getUser("user" + one);
        AdministrationServiceSystemTest.assertNotNull((Object)userDetails2);
        AdministrationServiceSystemTest.assertEquals((String)("user" + one), (String)userDetails2.getUserName());
        for (NamedValue value : properties = userDetails2.getProperties()) {
            if (value.getName().equals(Constants.PROP_USER_FIRSTNAME)) {
                AdministrationServiceSystemTest.assertEquals((String)("first" + one), (String)value.getValue());
                continue;
            }
            if (value.getName().equals(Constants.PROP_USER_MIDDLENAME)) {
                AdministrationServiceSystemTest.assertEquals((String)("middle" + one), (String)value.getValue());
                continue;
            }
            if (value.getName().equals(Constants.PROP_USER_LASTNAME)) {
                AdministrationServiceSystemTest.assertEquals((String)("last" + one), (String)value.getValue());
                continue;
            }
            if (value.getName().equals(Constants.PROP_USER_HOMEFOLDER)) {
                AdministrationServiceSystemTest.assertEquals((String)homeFolder, (String)value.getValue());
                continue;
            }
            if (value.getName().equals(Constants.PROP_USER_EMAIL)) {
                AdministrationServiceSystemTest.assertEquals((String)("email" + one), (String)value.getValue());
                continue;
            }
            if (value.getName().equals(Constants.PROP_USER_ORGID)) {
                AdministrationServiceSystemTest.assertEquals((String)("org" + one), (String)value.getValue());
                continue;
            }
            if (!value.getName().equals(Constants.PROP_USERNAME)) continue;
            AdministrationServiceSystemTest.assertEquals((String)("user" + one), (String)value.getValue());
        }
        String[] userNames = new String[]{"user" + one, "user" + two};
        WebServiceFactory.getAdministrationService().deleteUsers(userNames);
        try {
            WebServiceFactory.getAdministrationService().getUser("user" + two);
            AdministrationServiceSystemTest.fail((String)"An exception should have been raised since we are trying to get hold of a user that has previously been deleted.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUserFilter() throws Exception {
        UserFilter userFilter = new UserFilter("^user.*");
        UserQueryResults results = WebServiceFactory.getAdministrationService().queryUsers(userFilter);
        AdministrationServiceSystemTest.assertNotNull((Object)results);
        if (results.getUserDetails() != null) {
            AdministrationServiceSystemTest.assertTrue((results.getUserDetails().length != 0 ? 1 : 0) != 0);
        }
        UserFilter userFilter2 = new UserFilter("^bob.*");
        UserQueryResults results2 = WebServiceFactory.getAdministrationService().queryUsers(userFilter2);
        AdministrationServiceSystemTest.assertNotNull((Object)results2);
        AdministrationServiceSystemTest.assertNull((Object)results2.getUserDetails());
        UserFilter userFilter3 = new UserFilter("^ad.*");
        UserQueryResults results3 = WebServiceFactory.getAdministrationService().queryUsers(userFilter3);
        AdministrationServiceSystemTest.assertNotNull((Object)results3);
        AdministrationServiceSystemTest.assertTrue((results3.getUserDetails().length == 1 ? 1 : 0) != 0);
        UserFilter userFilter4 = new UserFilter("admin");
        UserQueryResults results4 = WebServiceFactory.getAdministrationService().queryUsers(userFilter4);
        AdministrationServiceSystemTest.assertNotNull((Object)results4);
        AdministrationServiceSystemTest.assertTrue((results4.getUserDetails().length == 1 ? 1 : 0) != 0);
    }

    public void testCreateAndAuthenticateNewUser() throws Exception {
        String homeFolder = store.getScheme() + "://" + store.getAddress() + "/" + folderReference.getUuid();
        String one = Long.toString(System.currentTimeMillis());
        NewUserDetails[] newUsers = new NewUserDetails[]{new NewUserDetails("user" + one, "password" + one, this.createPersonProperties(homeFolder, "first" + one, "middle" + one, "last" + one, "email" + one, "org" + one))};
        UserDetails[] userDetails = WebServiceFactory.getAdministrationService().createUsers(newUsers);
        AdministrationServiceSystemTest.assertNotNull((Object)userDetails);
        AdministrationServiceSystemTest.assertEquals((int)1, (int)userDetails.length);
        AuthenticationUtils.endSession();
        AuthenticationUtils.startSession("user" + one, "password" + one);
        AuthenticationUtils.endSession();
        AuthenticationUtils.startSession("admin", "admin");
        WebServiceFactory.getAdministrationService().changePassword("user" + one, null, "newPassword");
        AuthenticationUtils.endSession();
        AuthenticationUtils.startSession("user" + one, "newPassword");
    }

    private NamedValue[] createPersonProperties(String homeFolder, String firstName, String middleName, String lastName, String email, String orgId) {
        return new NamedValue[]{new NamedValue(Constants.PROP_USER_HOMEFOLDER, false, homeFolder, null), new NamedValue(Constants.PROP_USER_FIRSTNAME, false, firstName, null), new NamedValue(Constants.PROP_USER_MIDDLENAME, false, middleName, null), new NamedValue(Constants.PROP_USER_LASTNAME, false, lastName, null), new NamedValue(Constants.PROP_USER_EMAIL, false, email, null), new NamedValue(Constants.PROP_USER_ORGID, false, orgId, null)};
    }

    public void testCreateUsersWithSameName() throws Exception {
        String homeFolder = store.getScheme() + "://" + store.getAddress() + "/" + folderReference.getUuid();
        String one = Long.toString(System.currentTimeMillis());
        NewUserDetails[] newUsers = new NewUserDetails[]{new NewUserDetails("user" + one, "password" + one, this.createPersonProperties(homeFolder, "first" + one, "middle" + one, "last" + one, "email" + one, "org" + one)), new NewUserDetails("user" + one, "password" + one, this.createPersonProperties(homeFolder, "first" + one, "middle" + one, "last" + one, "email" + one, "org" + one))};
        try {
            WebServiceFactory.getAdministrationService().createUsers(newUsers);
            AdministrationServiceSystemTest.fail((String)"This should have failed as we attempted to create the same user twice");
        }
        catch (Throwable exception) {
            // empty catch block
        }
    }

    public void testCreateUsersMultiThreaded() {
        String userName = "user" + Long.toString(System.currentTimeMillis());
        CreateUser createUser1 = new CreateUser(userName, AuthenticationUtils.getAuthenticationDetails());
        CreateUser createUser2 = new CreateUser(userName, AuthenticationUtils.getAuthenticationDetails());
        CreateUser createUser3 = new CreateUser(userName, AuthenticationUtils.getAuthenticationDetails());
        createUser1.start();
        createUser2.start();
        createUser3.start();
        System.out.println("testCreateUsersMultiThreaded: " + userName);
    }

    private class CreateUser
    extends Thread {
        private String userName;
        private AuthenticationDetails authenticationDetails;

        public CreateUser(String userName, AuthenticationDetails authenticationDetails) {
            this.userName = userName;
            this.authenticationDetails = authenticationDetails;
        }

        @Override
        public void run() {
            try {
                AuthenticationUtils.setAuthenticationDetails(this.authenticationDetails);
                String homeFolder = BaseWebServiceSystemTest.store.getScheme() + "://" + BaseWebServiceSystemTest.store.getAddress() + "/" + BaseWebServiceSystemTest.folderReference.getUuid();
                NewUserDetails[] newUsers = new NewUserDetails[]{new NewUserDetails(this.userName, "password", AdministrationServiceSystemTest.this.createPersonProperties(homeFolder, "first" + this.userName, "middle" + this.userName, "last" + this.userName, "email" + this.userName, "org" + this.userName))};
                WebServiceFactory.getAdministrationService().createUsers(newUsers);
                System.out.println("Creating user in thread: " + this.userName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Unable to creat user in thread", exception);
            }
        }
    }
}

