/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import org.alfresco.webservice.authoring.AuthoringServiceSoapBindingStub;
import org.alfresco.webservice.authoring.CancelCheckoutResult;
import org.alfresco.webservice.authoring.CheckinResult;
import org.alfresco.webservice.authoring.CheckoutResult;
import org.alfresco.webservice.authoring.LockStatus;
import org.alfresco.webservice.authoring.LockTypeEnum;
import org.alfresco.webservice.authoring.VersionResult;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.types.Version;
import org.alfresco.webservice.types.VersionHistory;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.ContentUtils;
import org.alfresco.webservice.util.Utils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthoringServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(AuthoringServiceSystemTest.class);
    private static final String INITIAL_VERSION_CONTENT = "Content of the initial version";
    private static final String SECOND_VERSION_CONTENT = "The content for the second version is completely different";
    private static final String VALUE_DESCRIPTION = "description";
    private AuthoringServiceSoapBindingStub authoringService = WebServiceFactory.getAuthoringService();

    public void testCheckout() throws Exception {
        this.doCheckOut();
    }

    private Reference doCheckOut() throws Exception {
        Reference reference = this.createContentAtRoot("version_test.txt", INITIAL_VERSION_CONTENT);
        Predicate predicate = this.convertToPredicate(reference);
        CheckoutResult result = this.authoringService.checkout(predicate, null);
        AuthoringServiceSystemTest.assertNotNull((Object)result);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getOriginals().length);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getWorkingCopies().length);
        return result.getWorkingCopies()[0];
    }

    public void xtestCheckoutWithDestination() throws Exception {
        Reference reference = this.createContentAtRoot("version_test.txt", INITIAL_VERSION_CONTENT);
        Predicate predicate = this.convertToPredicate(reference);
        ParentReference parentReference = this.getFolderParentReference("{http://www.alfresco.org/model/content/1.0}workingCopy");
        CheckoutResult result = this.authoringService.checkout(predicate, parentReference);
        AuthoringServiceSystemTest.assertNotNull((Object)result);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getOriginals().length);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getWorkingCopies().length);
    }

    public void testCheckin() throws Exception {
        Reference workingCopy = this.doCheckOut();
        Predicate predicate = this.convertToPredicate(workingCopy);
        NamedValue[] comments = this.getVersionComments();
        CheckinResult checkinResult = this.authoringService.checkin(predicate, comments, true);
        AuthoringServiceSystemTest.assertNotNull((Object)checkinResult);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)checkinResult.getCheckedIn().length);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)checkinResult.getWorkingCopies().length);
        Predicate predicate2 = this.convertToPredicate(checkinResult.getWorkingCopies()[0]);
        CheckinResult checkinResult2 = this.authoringService.checkin(predicate2, comments, false);
        AuthoringServiceSystemTest.assertNotNull((Object)checkinResult2);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)checkinResult2.getCheckedIn().length);
        AuthoringServiceSystemTest.assertNull((Object)checkinResult2.getWorkingCopies());
    }

    private NamedValue[] getVersionComments() {
        NamedValue[] comments = new NamedValue[]{new NamedValue(VALUE_DESCRIPTION, false, VALUE_DESCRIPTION, null)};
        return comments;
    }

    public void testCheckinExternal() throws Exception {
        Reference workingCopy = this.doCheckOut();
        NamedValue[] comments = this.getVersionComments();
        ContentFormat contentFormat = new ContentFormat("text/plain", "UTF-8");
        Reference origionalNode = this.authoringService.checkinExternal(workingCopy, comments, false, contentFormat, SECOND_VERSION_CONTENT.getBytes());
        AuthoringServiceSystemTest.assertNotNull((Object)origionalNode);
        Content[] contents = this.contentService.read(new Predicate(new Reference[]{origionalNode}, BaseWebServiceSystemTest.store, null), Constants.PROP_CONTENT.toString());
        Content readResult = contents[0];
        AuthoringServiceSystemTest.assertNotNull((Object)readResult);
        String checkedInContent = ContentUtils.getContentAsString(readResult);
        AuthoringServiceSystemTest.assertNotNull((Object)checkedInContent);
        AuthoringServiceSystemTest.assertEquals((String)SECOND_VERSION_CONTENT, (String)checkedInContent);
    }

    public void testCancelCheckout() throws Exception {
        Reference workingCopy = this.doCheckOut();
        Predicate predicate = this.convertToPredicate(workingCopy);
        CancelCheckoutResult result = this.authoringService.cancelCheckout(predicate);
        AuthoringServiceSystemTest.assertNotNull((Object)result);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getOriginals().length);
    }

    public void testLockUnLockGetStatus() throws Exception {
        Reference reference = this.createContentAtRoot("lock_test1.txt", INITIAL_VERSION_CONTENT);
        Predicate predicate = this.convertToPredicate(reference);
        this.checkLockStatus(predicate, null, null);
        Reference[] lockedRefs = this.authoringService.lock(predicate, false, LockTypeEnum.write);
        AuthoringServiceSystemTest.assertNotNull((Object)lockedRefs);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)lockedRefs.length);
        this.checkLockStatus(predicate, "admin", LockTypeEnum.write);
        Reference[] unlocked = this.authoringService.unlock(predicate, false);
        AuthoringServiceSystemTest.assertNotNull((Object)unlocked);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)unlocked.length);
        this.checkLockStatus(predicate, null, null);
        Reference[] lockedRefs2 = this.authoringService.lock(predicate, false, LockTypeEnum.read);
        AuthoringServiceSystemTest.assertNotNull((Object)lockedRefs2);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)lockedRefs2.length);
        this.checkLockStatus(predicate, "admin", LockTypeEnum.read);
    }

    private void checkLockStatus(Predicate predicate, String lockOwner, LockTypeEnum lockType) throws Exception {
        LockStatus[] lockStatus1 = this.authoringService.getLockStatus(predicate);
        AuthoringServiceSystemTest.assertNotNull((Object)lockStatus1);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)lockStatus1.length);
        LockStatus ls1 = lockStatus1[0];
        AuthoringServiceSystemTest.assertNotNull((Object)ls1);
        AuthoringServiceSystemTest.assertEquals((String)lockOwner, (String)ls1.getLockOwner());
        AuthoringServiceSystemTest.assertEquals((Object)lockType, (Object)ls1.getLockType());
    }

    public void testVersionMethods() throws Exception {
        Reference reference = this.createContentAtRoot("create_version_test.txt", INITIAL_VERSION_CONTENT);
        Predicate predicate = this.convertToPredicate(reference);
        VersionHistory emptyVersionHistory = this.authoringService.getVersionHistory(reference);
        AuthoringServiceSystemTest.assertNotNull((Object)emptyVersionHistory);
        AuthoringServiceSystemTest.assertNull((Object)emptyVersionHistory.getVersions());
        VersionResult result = this.authoringService.createVersion(predicate, this.getVersionComments(), false);
        AuthoringServiceSystemTest.assertNotNull((Object)result);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getNodes().length);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result.getVersions().length);
        Version version = result.getVersions()[0];
        AuthoringServiceSystemTest.assertEquals((String)"0.1", (String)version.getLabel());
        this.authoringService.createVersion(predicate, this.getVersionComments(), false);
        VersionHistory versionHistory = this.authoringService.getVersionHistory(reference);
        AuthoringServiceSystemTest.assertNotNull((Object)versionHistory);
        AuthoringServiceSystemTest.assertEquals((int)2, (int)versionHistory.getVersions().length);
        this.contentService.write(reference, Constants.PROP_CONTENT, SECOND_VERSION_CONTENT.getBytes(), null);
        VersionResult versionResult2 = this.authoringService.createVersion(predicate, this.getVersionComments(), false);
        AuthoringServiceSystemTest.assertNotNull((Object)versionResult2);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)versionResult2.getNodes().length);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)versionResult2.getVersions().length);
        Version version2 = versionResult2.getVersions()[0];
        AuthoringServiceSystemTest.assertEquals((String)"0.4", (String)version2.getLabel());
        VersionHistory versionHistory2 = this.authoringService.getVersionHistory(reference);
        AuthoringServiceSystemTest.assertNotNull((Object)versionHistory2);
        AuthoringServiceSystemTest.assertEquals((int)4, (int)versionHistory2.getVersions().length);
        NamedValue versionVal = Utils.createNamedValue("versionType", "MAJOR");
        NamedValue descriptionVal = Utils.createNamedValue(VALUE_DESCRIPTION, "new description");
        NamedValue[] comments = new NamedValue[]{versionVal, descriptionVal};
        VersionResult result5 = this.authoringService.createVersion(predicate, comments, false);
        AuthoringServiceSystemTest.assertNotNull((Object)result5);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result5.getNodes().length);
        AuthoringServiceSystemTest.assertEquals((int)1, (int)result5.getVersions().length);
        Version version5 = result5.getVersions()[0];
        AuthoringServiceSystemTest.assertEquals((String)"1.0", (String)version5.getLabel());
        Content[] contents = this.contentService.read(new Predicate(new Reference[]{reference}, BaseWebServiceSystemTest.store, null), Constants.PROP_CONTENT.toString());
        Content readResult1 = contents[0];
        String content1 = ContentUtils.getContentAsString(readResult1);
        AuthoringServiceSystemTest.assertEquals((String)SECOND_VERSION_CONTENT, (String)content1);
        this.authoringService.revertVersion(reference, "0.1");
        Content[] contents2 = this.contentService.read(new Predicate(new Reference[]{reference}, BaseWebServiceSystemTest.store, null), Constants.PROP_CONTENT.toString());
        Content readResult2 = contents2[0];
        String content2 = ContentUtils.getContentAsString(readResult2);
        AuthoringServiceSystemTest.assertEquals((String)INITIAL_VERSION_CONTENT, (String)content2);
        VersionHistory deletedVersionHistory = this.authoringService.deleteAllVersions(reference);
        AuthoringServiceSystemTest.assertNotNull((Object)deletedVersionHistory);
        AuthoringServiceSystemTest.assertNull((Object)deletedVersionHistory.getVersions());
        VersionHistory versionHistory3 = this.authoringService.getVersionHistory(reference);
        AuthoringServiceSystemTest.assertNotNull((Object)versionHistory3);
        AuthoringServiceSystemTest.assertNull((Object)versionHistory3.getVersions());
    }
}

